# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from phrasetms_client.models.uid_reference import UidReference

class GUESTEDITAllOf(BaseModel):
    """
    GUESTEDITAllOf
    """
    client: UidReference = Field(...)
    enable_mt: Optional[StrictBool] = Field(None, alias="enableMT", description="Enable MT. Default: true")
    project_view_other: Optional[StrictBool] = Field(None, alias="projectViewOther", description="View projects created by other users. Default: true")
    project_view_other_linguist: Optional[StrictBool] = Field(None, alias="projectViewOtherLinguist", description="Show provider names. Default: true")
    project_view_other_editor: Optional[StrictBool] = Field(None, alias="projectViewOtherEditor", description="Edit jobs in Memsource Editor. Default: true")
    trans_memory_view_other: Optional[StrictBool] = Field(None, alias="transMemoryViewOther", description="View TMs created by other users. Default: true")
    trans_memory_edit_other: Optional[StrictBool] = Field(None, alias="transMemoryEditOther", description="Modify TMs created by other users. Default: true")
    trans_memory_export_other: Optional[StrictBool] = Field(None, alias="transMemoryExportOther", description="Export TMs created by other users. Default: true")
    trans_memory_import_other: Optional[StrictBool] = Field(None, alias="transMemoryImportOther", description="Import into TMs created by other users. Default: true")
    term_base_view_other: Optional[StrictBool] = Field(None, alias="termBaseViewOther", description="View TBs created by other users. Default: true")
    term_base_edit_other: Optional[StrictBool] = Field(None, alias="termBaseEditOther", description="Modify TBs created by other users. Default: true")
    term_base_export_other: Optional[StrictBool] = Field(None, alias="termBaseExportOther", description="Export TBs created by other users. Default: true")
    term_base_import_other: Optional[StrictBool] = Field(None, alias="termBaseImportOther", description="Import into TBs created by other users. Default: true")
    term_base_approve_other: Optional[StrictBool] = Field(None, alias="termBaseApproveOther", description="Approve terms in TBs created by other users. Default: true")
    __properties = ["client", "enableMT", "projectViewOther", "projectViewOtherLinguist", "projectViewOtherEditor", "transMemoryViewOther", "transMemoryEditOther", "transMemoryExportOther", "transMemoryImportOther", "termBaseViewOther", "termBaseEditOther", "termBaseExportOther", "termBaseImportOther", "termBaseApproveOther"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GUESTEDITAllOf:
        """Create an instance of GUESTEDITAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GUESTEDITAllOf:
        """Create an instance of GUESTEDITAllOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GUESTEDITAllOf.parse_obj(obj)

        _obj = GUESTEDITAllOf.parse_obj({
            "client": UidReference.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "enable_mt": obj.get("enableMT"),
            "project_view_other": obj.get("projectViewOther"),
            "project_view_other_linguist": obj.get("projectViewOtherLinguist"),
            "project_view_other_editor": obj.get("projectViewOtherEditor"),
            "trans_memory_view_other": obj.get("transMemoryViewOther"),
            "trans_memory_edit_other": obj.get("transMemoryEditOther"),
            "trans_memory_export_other": obj.get("transMemoryExportOther"),
            "trans_memory_import_other": obj.get("transMemoryImportOther"),
            "term_base_view_other": obj.get("termBaseViewOther"),
            "term_base_edit_other": obj.get("termBaseEditOther"),
            "term_base_export_other": obj.get("termBaseExportOther"),
            "term_base_import_other": obj.get("termBaseImportOther"),
            "term_base_approve_other": obj.get("termBaseApproveOther")
        })
        return _obj

