# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from phrasetms_client.models.error_dto import ErrorDto

class FileDto(BaseModel):
    """
    FileDto
    """
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    encoded_name: Optional[StrictStr] = Field(None, alias="encodedName")
    content_type: Optional[StrictStr] = Field(None, alias="contentType")
    note: Optional[StrictStr] = None
    size: Optional[StrictInt] = None
    directory: Optional[StrictBool] = None
    last_modified: Optional[datetime] = Field(None, alias="lastModified")
    selected: Optional[StrictBool] = None
    error: Optional[ErrorDto] = None
    __properties = ["id", "name", "encodedName", "contentType", "note", "size", "directory", "lastModified", "selected", "error"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FileDto:
        """Create an instance of FileDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FileDto:
        """Create an instance of FileDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FileDto.parse_obj(obj)

        _obj = FileDto.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "encoded_name": obj.get("encodedName"),
            "content_type": obj.get("contentType"),
            "note": obj.get("note"),
            "size": obj.get("size"),
            "directory": obj.get("directory"),
            "last_modified": obj.get("lastModified"),
            "selected": obj.get("selected"),
            "error": ErrorDto.from_dict(obj.get("error")) if obj.get("error") is not None else None
        })
        return _obj

