# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool

class FeaturesDto(BaseModel):
    """
    FeaturesDto
    """
    icu_enabled: Optional[StrictBool] = Field(None, alias="icuEnabled")
    reject_jobs: Optional[StrictBool] = Field(None, alias="rejectJobs")
    qa_highlights_enabled: Optional[StrictBool] = Field(None, alias="qaHighlightsEnabled")
    lqa_bulk_comments_creation: Optional[StrictBool] = Field(None, alias="lqaBulkCommentsCreation")
    mt_for_tm_above100_enabled: Optional[StrictBool] = Field(None, alias="mtForTMAbove100Enabled")
    __properties = ["icuEnabled", "rejectJobs", "qaHighlightsEnabled", "lqaBulkCommentsCreation", "mtForTMAbove100Enabled"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FeaturesDto:
        """Create an instance of FeaturesDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FeaturesDto:
        """Create an instance of FeaturesDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FeaturesDto.parse_obj(obj)

        _obj = FeaturesDto.parse_obj({
            "icu_enabled": obj.get("icuEnabled"),
            "reject_jobs": obj.get("rejectJobs"),
            "qa_highlights_enabled": obj.get("qaHighlightsEnabled"),
            "lqa_bulk_comments_creation": obj.get("lqaBulkCommentsCreation"),
            "mt_for_tm_above100_enabled": obj.get("mtForTMAbove100Enabled")
        })
        return _obj

