# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from phrasetms_client.models.accuracy_weights_dto import AccuracyWeightsDto
from phrasetms_client.models.design_weights_dto import DesignWeightsDto
from phrasetms_client.models.fluency_weights_dto import FluencyWeightsDto
from phrasetms_client.models.locale_convention_weights_dto import LocaleConventionWeightsDto
from phrasetms_client.models.other_weights_dto import OtherWeightsDto
from phrasetms_client.models.style_weights_dto import StyleWeightsDto
from phrasetms_client.models.terminology_weights_dto import TerminologyWeightsDto
from phrasetms_client.models.verity_weights_dto import VerityWeightsDto

class ErrorCategoriesDto(BaseModel):
    """
    Error categories and their importance weight. If not provided, defaults will be created.
    """
    accuracy: Optional[AccuracyWeightsDto] = None
    fluency: Optional[FluencyWeightsDto] = None
    terminology: Optional[TerminologyWeightsDto] = None
    style: Optional[StyleWeightsDto] = None
    locale_convention: Optional[LocaleConventionWeightsDto] = Field(None, alias="localeConvention")
    verity: Optional[VerityWeightsDto] = None
    design: Optional[DesignWeightsDto] = None
    other: Optional[OtherWeightsDto] = None
    __properties = ["accuracy", "fluency", "terminology", "style", "localeConvention", "verity", "design", "other"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ErrorCategoriesDto:
        """Create an instance of ErrorCategoriesDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of accuracy
        if self.accuracy:
            _dict['accuracy'] = self.accuracy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fluency
        if self.fluency:
            _dict['fluency'] = self.fluency.to_dict()
        # override the default output from pydantic by calling `to_dict()` of terminology
        if self.terminology:
            _dict['terminology'] = self.terminology.to_dict()
        # override the default output from pydantic by calling `to_dict()` of style
        if self.style:
            _dict['style'] = self.style.to_dict()
        # override the default output from pydantic by calling `to_dict()` of locale_convention
        if self.locale_convention:
            _dict['localeConvention'] = self.locale_convention.to_dict()
        # override the default output from pydantic by calling `to_dict()` of verity
        if self.verity:
            _dict['verity'] = self.verity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of design
        if self.design:
            _dict['design'] = self.design.to_dict()
        # override the default output from pydantic by calling `to_dict()` of other
        if self.other:
            _dict['other'] = self.other.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ErrorCategoriesDto:
        """Create an instance of ErrorCategoriesDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ErrorCategoriesDto.parse_obj(obj)

        _obj = ErrorCategoriesDto.parse_obj({
            "accuracy": AccuracyWeightsDto.from_dict(obj.get("accuracy")) if obj.get("accuracy") is not None else None,
            "fluency": FluencyWeightsDto.from_dict(obj.get("fluency")) if obj.get("fluency") is not None else None,
            "terminology": TerminologyWeightsDto.from_dict(obj.get("terminology")) if obj.get("terminology") is not None else None,
            "style": StyleWeightsDto.from_dict(obj.get("style")) if obj.get("style") is not None else None,
            "locale_convention": LocaleConventionWeightsDto.from_dict(obj.get("localeConvention")) if obj.get("localeConvention") is not None else None,
            "verity": VerityWeightsDto.from_dict(obj.get("verity")) if obj.get("verity") is not None else None,
            "design": DesignWeightsDto.from_dict(obj.get("design")) if obj.get("design") is not None else None,
            "other": OtherWeightsDto.from_dict(obj.get("other")) if obj.get("other") is not None else None
        })
        return _obj

