# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr, validator
from phrasetms_client.models.custom_field_instance_api_dto import CustomFieldInstanceApiDto
from phrasetms_client.models.id_reference import IdReference
from phrasetms_client.models.lqa_profiles_for_ws_v2_dto import LqaProfilesForWsV2Dto

class EditProjectV2Dto(BaseModel):
    """
    EditProjectV2Dto
    """
    name: constr(strict=True, max_length=255, min_length=0) = Field(...)
    status: Optional[StrictStr] = None
    client: Optional[IdReference] = None
    business_unit: Optional[IdReference] = Field(None, alias="businessUnit")
    domain: Optional[IdReference] = None
    sub_domain: Optional[IdReference] = Field(None, alias="subDomain")
    owner: Optional[IdReference] = None
    purchase_order: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(None, alias="purchaseOrder")
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    note: Optional[constr(strict=True, max_length=4096, min_length=0)] = None
    file_handover: Optional[StrictBool] = Field(None, alias="fileHandover", description="Default: false")
    lqa_profiles: Optional[conlist(LqaProfilesForWsV2Dto)] = Field(None, alias="lqaProfiles", description="Lqa profiles that will be added to workflow steps")
    archived: Optional[StrictBool] = Field(None, description="Default: false")
    custom_fields: Optional[conlist(CustomFieldInstanceApiDto)] = Field(None, alias="customFields", description="Custom fields for project")
    __properties = ["name", "status", "client", "businessUnit", "domain", "subDomain", "owner", "purchaseOrder", "dateDue", "note", "fileHandover", "lqaProfiles", "archived", "customFields"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NEW', 'ASSIGNED', 'COMPLETED', 'ACCEPTED_BY_VENDOR', 'DECLINED_BY_VENDOR', 'COMPLETED_BY_VENDOR', 'CANCELLED'):
            raise ValueError("must be one of enum values ('NEW', 'ASSIGNED', 'COMPLETED', 'ACCEPTED_BY_VENDOR', 'DECLINED_BY_VENDOR', 'COMPLETED_BY_VENDOR', 'CANCELLED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EditProjectV2Dto:
        """Create an instance of EditProjectV2Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_unit
        if self.business_unit:
            _dict['businessUnit'] = self.business_unit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in lqa_profiles (list)
        _items = []
        if self.lqa_profiles:
            for _item in self.lqa_profiles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lqaProfiles'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_fields (list)
        _items = []
        if self.custom_fields:
            for _item in self.custom_fields:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customFields'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EditProjectV2Dto:
        """Create an instance of EditProjectV2Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EditProjectV2Dto.parse_obj(obj)

        _obj = EditProjectV2Dto.parse_obj({
            "name": obj.get("name"),
            "status": obj.get("status"),
            "client": IdReference.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "business_unit": IdReference.from_dict(obj.get("businessUnit")) if obj.get("businessUnit") is not None else None,
            "domain": IdReference.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": IdReference.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "owner": IdReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None,
            "purchase_order": obj.get("purchaseOrder"),
            "date_due": obj.get("dateDue"),
            "note": obj.get("note"),
            "file_handover": obj.get("fileHandover"),
            "lqa_profiles": [LqaProfilesForWsV2Dto.from_dict(_item) for _item in obj.get("lqaProfiles")] if obj.get("lqaProfiles") is not None else None,
            "archived": obj.get("archived"),
            "custom_fields": [CustomFieldInstanceApiDto.from_dict(_item) for _item in obj.get("customFields")] if obj.get("customFields") is not None else None
        })
        return _obj

