# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from phrasetms_client.models.vendor_security_settings_dto import VendorSecuritySettingsDto

class EditProjectSecuritySettingsDtoV2(BaseModel):
    """
    EditProjectSecuritySettingsDtoV2
    """
    download_enabled: Optional[StrictBool] = Field(None, alias="downloadEnabled", description="Default: `false`")
    web_editor_enabled_for_linguists: Optional[StrictBool] = Field(None, alias="webEditorEnabledForLinguists", description="Default: `false`")
    show_user_data_to_linguists: Optional[StrictBool] = Field(None, alias="showUserDataToLinguists", description="Default: `false`")
    email_notifications: Optional[StrictBool] = Field(None, alias="emailNotifications", description="Default: `false`")
    strict_workflow_finish: Optional[StrictBool] = Field(None, alias="strictWorkflowFinish", description="Default: `false`")
    use_vendors: Optional[StrictBool] = Field(None, alias="useVendors", description="Default: `false`")
    linguists_may_edit_locked_segments: Optional[StrictBool] = Field(None, alias="linguistsMayEditLockedSegments", description="Default: `false`")
    users_may_set_auto_propagation: Optional[StrictBool] = Field(None, alias="usersMaySetAutoPropagation", description="Default: `true`")
    allow_loading_external_content_in_editors: Optional[StrictBool] = Field(None, alias="allowLoadingExternalContentInEditors", description="Default: `true`")
    allow_loading_iframes: Optional[StrictBool] = Field(None, alias="allowLoadingIframes", description="Default: `false`")
    linguists_may_edit_source: Optional[StrictBool] = Field(None, alias="linguistsMayEditSource", description="Default: `true`")
    linguists_may_edit_tag_content: Optional[StrictBool] = Field(None, alias="linguistsMayEditTagContent", description="Default: `true`")
    linguists_may_download_lqa_report: Optional[StrictBool] = Field(None, alias="linguistsMayDownloadLqaReport", description="Default: `true`")
    usernames_displayed_in_lqa_report: Optional[StrictBool] = Field(None, alias="usernamesDisplayedInLqaReport", description="Default: `true`")
    user_may_set_instant_qa: Optional[StrictBool] = Field(None, alias="userMaySetInstantQA", description="Default: `true`")
    trigger_webhooks: Optional[StrictBool] = Field(None, alias="triggerWebhooks", description="Default: `true`")
    notify_job_owner_status_changed: Optional[StrictBool] = Field(None, alias="notifyJobOwnerStatusChanged", description="Default: `false`")
    vendors: Optional[VendorSecuritySettingsDto] = None
    allowed_domains: Optional[conlist(StrictStr)] = Field(None, alias="allowedDomains")
    __properties = ["downloadEnabled", "webEditorEnabledForLinguists", "showUserDataToLinguists", "emailNotifications", "strictWorkflowFinish", "useVendors", "linguistsMayEditLockedSegments", "usersMaySetAutoPropagation", "allowLoadingExternalContentInEditors", "allowLoadingIframes", "linguistsMayEditSource", "linguistsMayEditTagContent", "linguistsMayDownloadLqaReport", "usernamesDisplayedInLqaReport", "userMaySetInstantQA", "triggerWebhooks", "notifyJobOwnerStatusChanged", "vendors", "allowedDomains"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EditProjectSecuritySettingsDtoV2:
        """Create an instance of EditProjectSecuritySettingsDtoV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of vendors
        if self.vendors:
            _dict['vendors'] = self.vendors.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EditProjectSecuritySettingsDtoV2:
        """Create an instance of EditProjectSecuritySettingsDtoV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EditProjectSecuritySettingsDtoV2.parse_obj(obj)

        _obj = EditProjectSecuritySettingsDtoV2.parse_obj({
            "download_enabled": obj.get("downloadEnabled"),
            "web_editor_enabled_for_linguists": obj.get("webEditorEnabledForLinguists"),
            "show_user_data_to_linguists": obj.get("showUserDataToLinguists"),
            "email_notifications": obj.get("emailNotifications"),
            "strict_workflow_finish": obj.get("strictWorkflowFinish"),
            "use_vendors": obj.get("useVendors"),
            "linguists_may_edit_locked_segments": obj.get("linguistsMayEditLockedSegments"),
            "users_may_set_auto_propagation": obj.get("usersMaySetAutoPropagation"),
            "allow_loading_external_content_in_editors": obj.get("allowLoadingExternalContentInEditors"),
            "allow_loading_iframes": obj.get("allowLoadingIframes"),
            "linguists_may_edit_source": obj.get("linguistsMayEditSource"),
            "linguists_may_edit_tag_content": obj.get("linguistsMayEditTagContent"),
            "linguists_may_download_lqa_report": obj.get("linguistsMayDownloadLqaReport"),
            "usernames_displayed_in_lqa_report": obj.get("usernamesDisplayedInLqaReport"),
            "user_may_set_instant_qa": obj.get("userMaySetInstantQA"),
            "trigger_webhooks": obj.get("triggerWebhooks"),
            "notify_job_owner_status_changed": obj.get("notifyJobOwnerStatusChanged"),
            "vendors": VendorSecuritySettingsDto.from_dict(obj.get("vendors")) if obj.get("vendors") is not None else None,
            "allowed_domains": obj.get("allowedDomains")
        })
        return _obj

