# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class DocSettingsDto(BaseModel):
    """
    DocSettingsDto
    """
    comments: Optional[StrictBool] = Field(None, description="Default: false")
    index: Optional[StrictBool] = Field(None, description="Default: true")
    other: Optional[StrictBool] = Field(None, description="Default: false")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    hyperlink_target: Optional[StrictBool] = Field(None, alias="hyperlinkTarget", description="Default: false")
    join_similar_runs: Optional[StrictBool] = Field(None, alias="joinSimilarRuns", description="Default: false")
    target_font: Optional[StrictStr] = Field(None, alias="targetFont")
    properties: Optional[StrictBool] = Field(None, description="Default: false")
    hidden: Optional[StrictBool] = Field(None, description="Default: false")
    header_footer: Optional[StrictBool] = Field(None, alias="headerFooter", description="Default: true")
    __properties = ["comments", "index", "other", "tagRegexp", "hyperlinkTarget", "joinSimilarRuns", "targetFont", "properties", "hidden", "headerFooter"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DocSettingsDto:
        """Create an instance of DocSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DocSettingsDto:
        """Create an instance of DocSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DocSettingsDto.parse_obj(obj)

        _obj = DocSettingsDto.parse_obj({
            "comments": obj.get("comments"),
            "index": obj.get("index"),
            "other": obj.get("other"),
            "tag_regexp": obj.get("tagRegexp"),
            "hyperlink_target": obj.get("hyperlinkTarget"),
            "join_similar_runs": obj.get("joinSimilarRuns"),
            "target_font": obj.get("targetFont"),
            "properties": obj.get("properties"),
            "hidden": obj.get("hidden"),
            "header_footer": obj.get("headerFooter")
        })
        return _obj

