# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from phrasetms_client.models.toggleable_weight_dto import ToggleableWeightDto

class DesignWeightsDto(BaseModel):
    """
    DesignWeightsDto
    """
    design: Optional[ToggleableWeightDto] = None
    length: Optional[ToggleableWeightDto] = None
    local_formatting: Optional[ToggleableWeightDto] = Field(None, alias="localFormatting")
    markup: Optional[ToggleableWeightDto] = None
    missing_text: Optional[ToggleableWeightDto] = Field(None, alias="missingText")
    truncation: Optional[ToggleableWeightDto] = None
    __properties = ["design", "length", "localFormatting", "markup", "missingText", "truncation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DesignWeightsDto:
        """Create an instance of DesignWeightsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of design
        if self.design:
            _dict['design'] = self.design.to_dict()
        # override the default output from pydantic by calling `to_dict()` of length
        if self.length:
            _dict['length'] = self.length.to_dict()
        # override the default output from pydantic by calling `to_dict()` of local_formatting
        if self.local_formatting:
            _dict['localFormatting'] = self.local_formatting.to_dict()
        # override the default output from pydantic by calling `to_dict()` of markup
        if self.markup:
            _dict['markup'] = self.markup.to_dict()
        # override the default output from pydantic by calling `to_dict()` of missing_text
        if self.missing_text:
            _dict['missingText'] = self.missing_text.to_dict()
        # override the default output from pydantic by calling `to_dict()` of truncation
        if self.truncation:
            _dict['truncation'] = self.truncation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DesignWeightsDto:
        """Create an instance of DesignWeightsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DesignWeightsDto.parse_obj(obj)

        _obj = DesignWeightsDto.parse_obj({
            "design": ToggleableWeightDto.from_dict(obj.get("design")) if obj.get("design") is not None else None,
            "length": ToggleableWeightDto.from_dict(obj.get("length")) if obj.get("length") is not None else None,
            "local_formatting": ToggleableWeightDto.from_dict(obj.get("localFormatting")) if obj.get("localFormatting") is not None else None,
            "markup": ToggleableWeightDto.from_dict(obj.get("markup")) if obj.get("markup") is not None else None,
            "missing_text": ToggleableWeightDto.from_dict(obj.get("missingText")) if obj.get("missingText") is not None else None,
            "truncation": ToggleableWeightDto.from_dict(obj.get("truncation")) if obj.get("truncation") is not None else None
        })
        return _obj

