# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from phrasetms_client.models.counts_dto import CountsDto
from phrasetms_client.models.match_counts101_dto import MatchCounts101Dto
from phrasetms_client.models.match_counts_dto import MatchCountsDto
from phrasetms_client.models.match_counts_nt_dto_v1 import MatchCountsNTDtoV1

class DataDtoV1(BaseModel):
    """
    DataDtoV1
    """
    available: Optional[StrictBool] = None
    all: Optional[CountsDto] = None
    repetitions: Optional[CountsDto] = None
    trans_memory_matches: Optional[MatchCounts101Dto] = Field(None, alias="transMemoryMatches")
    machine_translation_matches: Optional[MatchCountsDto] = Field(None, alias="machineTranslationMatches")
    non_translatables_matches: Optional[MatchCountsNTDtoV1] = Field(None, alias="nonTranslatablesMatches")
    internal_fuzzy_matches: Optional[MatchCountsDto] = Field(None, alias="internalFuzzyMatches")
    __properties = ["available", "all", "repetitions", "transMemoryMatches", "machineTranslationMatches", "nonTranslatablesMatches", "internalFuzzyMatches"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DataDtoV1:
        """Create an instance of DataDtoV1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of all
        if self.all:
            _dict['all'] = self.all.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repetitions
        if self.repetitions:
            _dict['repetitions'] = self.repetitions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trans_memory_matches
        if self.trans_memory_matches:
            _dict['transMemoryMatches'] = self.trans_memory_matches.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine_translation_matches
        if self.machine_translation_matches:
            _dict['machineTranslationMatches'] = self.machine_translation_matches.to_dict()
        # override the default output from pydantic by calling `to_dict()` of non_translatables_matches
        if self.non_translatables_matches:
            _dict['nonTranslatablesMatches'] = self.non_translatables_matches.to_dict()
        # override the default output from pydantic by calling `to_dict()` of internal_fuzzy_matches
        if self.internal_fuzzy_matches:
            _dict['internalFuzzyMatches'] = self.internal_fuzzy_matches.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DataDtoV1:
        """Create an instance of DataDtoV1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DataDtoV1.parse_obj(obj)

        _obj = DataDtoV1.parse_obj({
            "available": obj.get("available"),
            "all": CountsDto.from_dict(obj.get("all")) if obj.get("all") is not None else None,
            "repetitions": CountsDto.from_dict(obj.get("repetitions")) if obj.get("repetitions") is not None else None,
            "trans_memory_matches": MatchCounts101Dto.from_dict(obj.get("transMemoryMatches")) if obj.get("transMemoryMatches") is not None else None,
            "machine_translation_matches": MatchCountsDto.from_dict(obj.get("machineTranslationMatches")) if obj.get("machineTranslationMatches") is not None else None,
            "non_translatables_matches": MatchCountsNTDtoV1.from_dict(obj.get("nonTranslatablesMatches")) if obj.get("nonTranslatablesMatches") is not None else None,
            "internal_fuzzy_matches": MatchCountsDto.from_dict(obj.get("internalFuzzyMatches")) if obj.get("internalFuzzyMatches") is not None else None
        })
        return _obj

