# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from phrasetms_client.models.position import Position
from phrasetms_client.models.segment_warning import SegmentWarning

class CustomQAWarningDto(SegmentWarning):
    """
    CustomQAWarningDto
    """
    message: Optional[StrictStr] = None
    sub_type: Optional[StrictStr] = Field(None, alias="subType")
    src_position: Optional[Position] = Field(None, alias="srcPosition")
    tgt_position: Optional[Position] = Field(None, alias="tgtPosition")
    __properties = ["id", "ignored", "type", "repetitionGroupId", "message", "subType", "srcPosition", "tgtPosition"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomQAWarningDto:
        """Create an instance of CustomQAWarningDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of src_position
        if self.src_position:
            _dict['srcPosition'] = self.src_position.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tgt_position
        if self.tgt_position:
            _dict['tgtPosition'] = self.tgt_position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomQAWarningDto:
        """Create an instance of CustomQAWarningDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CustomQAWarningDto.parse_obj(obj)

        _obj = CustomQAWarningDto.parse_obj({
            "id": obj.get("id"),
            "ignored": obj.get("ignored"),
            "type": obj.get("type"),
            "repetition_group_id": obj.get("repetitionGroupId"),
            "message": obj.get("message"),
            "sub_type": obj.get("subType"),
            "src_position": Position.from_dict(obj.get("srcPosition")) if obj.get("srcPosition") is not None else None,
            "tgt_position": Position.from_dict(obj.get("tgtPosition")) if obj.get("tgtPosition") is not None else None
        })
        return _obj

