# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from phrasetms_client.models.custom_field_options_truncated_dto import CustomFieldOptionsTruncatedDto
from phrasetms_client.models.user_reference import UserReference

class CustomFieldDto(BaseModel):
    """
    CustomFieldDto
    """
    uid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    allowed_entities: Optional[conlist(StrictStr)] = Field(None, alias="allowedEntities")
    options: Optional[CustomFieldOptionsTruncatedDto] = None
    created_at: Optional[datetime] = Field(None, alias="createdAt")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    last_modified: Optional[datetime] = Field(None, alias="lastModified")
    last_modified_by: Optional[UserReference] = Field(None, alias="lastModifiedBy")
    required_from: Optional[datetime] = Field(None, alias="requiredFrom")
    required: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    __properties = ["uid", "name", "type", "allowedEntities", "options", "createdAt", "createdBy", "lastModified", "lastModifiedBy", "requiredFrom", "required", "description"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('MULTI_SELECT', 'SINGLE_SELECT', 'STRING', 'NUMBER', 'URL', 'DATE'):
            raise ValueError("must be one of enum values ('MULTI_SELECT', 'SINGLE_SELECT', 'STRING', 'NUMBER', 'URL', 'DATE')")
        return value

    @validator('allowed_entities')
    def allowed_entities_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('PROJECT'):
                raise ValueError("each list item must be one of ('PROJECT')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CustomFieldDto:
        """Create an instance of CustomFieldDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_by
        if self.last_modified_by:
            _dict['lastModifiedBy'] = self.last_modified_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CustomFieldDto:
        """Create an instance of CustomFieldDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CustomFieldDto.parse_obj(obj)

        _obj = CustomFieldDto.parse_obj({
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "allowed_entities": obj.get("allowedEntities"),
            "options": CustomFieldOptionsTruncatedDto.from_dict(obj.get("options")) if obj.get("options") is not None else None,
            "created_at": obj.get("createdAt"),
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "last_modified": obj.get("lastModified"),
            "last_modified_by": UserReference.from_dict(obj.get("lastModifiedBy")) if obj.get("lastModifiedBy") is not None else None,
            "required_from": obj.get("requiredFrom"),
            "required": obj.get("required"),
            "description": obj.get("description")
        })
        return _obj

