# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class CsvSettingsDto(BaseModel):
    """
    CsvSettingsDto
    """
    delimiter: Optional[StrictStr] = Field(None, description="Default: ,")
    delimiter_type: Optional[StrictStr] = Field(None, alias="delimiterType", description="Default: COMMA")
    html_sub_filter: Optional[StrictBool] = Field(None, alias="htmlSubFilter", description="Default: false")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    import_columns: Optional[StrictStr] = Field(None, alias="importColumns")
    context_note_columns: Optional[StrictStr] = Field(None, alias="contextNoteColumns")
    context_key_column: Optional[StrictStr] = Field(None, alias="contextKeyColumn")
    max_len_column: Optional[StrictStr] = Field(None, alias="maxLenColumn")
    import_rows: Optional[StrictStr] = Field(None, alias="importRows")
    __properties = ["delimiter", "delimiterType", "htmlSubFilter", "tagRegexp", "importColumns", "contextNoteColumns", "contextKeyColumn", "maxLenColumn", "importRows"]

    @validator('delimiter_type')
    def delimiter_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('TAB', 'COMMA', 'SEMICOLON', 'OTHER'):
            raise ValueError("must be one of enum values ('TAB', 'COMMA', 'SEMICOLON', 'OTHER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CsvSettingsDto:
        """Create an instance of CsvSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CsvSettingsDto:
        """Create an instance of CsvSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CsvSettingsDto.parse_obj(obj)

        _obj = CsvSettingsDto.parse_obj({
            "delimiter": obj.get("delimiter"),
            "delimiter_type": obj.get("delimiterType"),
            "html_sub_filter": obj.get("htmlSubFilter"),
            "tag_regexp": obj.get("tagRegexp"),
            "import_columns": obj.get("importColumns"),
            "context_note_columns": obj.get("contextNoteColumns"),
            "context_key_column": obj.get("contextKeyColumn"),
            "max_len_column": obj.get("maxLenColumn"),
            "import_rows": obj.get("importRows")
        })
        return _obj

