# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from phrasetms_client.models.error_categories_dto import ErrorCategoriesDto
from phrasetms_client.models.pass_fail_threshold_dto import PassFailThresholdDto
from phrasetms_client.models.penalty_points_dto import PenaltyPointsDto

class CreateLqaProfileDto(BaseModel):
    """
    CreateLqaProfileDto
    """
    name: constr(strict=True, max_length=255, min_length=1) = Field(...)
    error_categories: ErrorCategoriesDto = Field(..., alias="errorCategories")
    penalty_points: Optional[PenaltyPointsDto] = Field(None, alias="penaltyPoints")
    pass_fail_threshold: Optional[PassFailThresholdDto] = Field(None, alias="passFailThreshold")
    __properties = ["name", "errorCategories", "penaltyPoints", "passFailThreshold"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateLqaProfileDto:
        """Create an instance of CreateLqaProfileDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of error_categories
        if self.error_categories:
            _dict['errorCategories'] = self.error_categories.to_dict()
        # override the default output from pydantic by calling `to_dict()` of penalty_points
        if self.penalty_points:
            _dict['penaltyPoints'] = self.penalty_points.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pass_fail_threshold
        if self.pass_fail_threshold:
            _dict['passFailThreshold'] = self.pass_fail_threshold.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateLqaProfileDto:
        """Create an instance of CreateLqaProfileDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateLqaProfileDto.parse_obj(obj)

        _obj = CreateLqaProfileDto.parse_obj({
            "name": obj.get("name"),
            "error_categories": ErrorCategoriesDto.from_dict(obj.get("errorCategories")) if obj.get("errorCategories") is not None else None,
            "penalty_points": PenaltyPointsDto.from_dict(obj.get("penaltyPoints")) if obj.get("penaltyPoints") is not None else None,
            "pass_fail_threshold": PassFailThresholdDto.from_dict(obj.get("passFailThreshold")) if obj.get("passFailThreshold") is not None else None
        })
        return _obj

