# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr, validator

class CreateCustomFieldDto(BaseModel):
    """
    CreateCustomFieldDto
    """
    name: constr(strict=True, max_length=255, min_length=0) = Field(...)
    allowed_entities: conlist(StrictStr) = Field(..., alias="allowedEntities")
    options: Optional[conlist(StrictStr)] = None
    type: Optional[StrictStr] = None
    required: Optional[StrictBool] = None
    description: Optional[constr(strict=True, max_length=500, min_length=0)] = None
    __properties = ["name", "allowedEntities", "options", "type", "required", "description"]

    @validator('allowed_entities')
    def allowed_entities_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ('PROJECT'):
                raise ValueError("each list item must be one of ('PROJECT')")
        return value

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('MULTI_SELECT', 'SINGLE_SELECT', 'STRING', 'NUMBER', 'URL', 'DATE'):
            raise ValueError("must be one of enum values ('MULTI_SELECT', 'SINGLE_SELECT', 'STRING', 'NUMBER', 'URL', 'DATE')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateCustomFieldDto:
        """Create an instance of CreateCustomFieldDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateCustomFieldDto:
        """Create an instance of CreateCustomFieldDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateCustomFieldDto.parse_obj(obj)

        _obj = CreateCustomFieldDto.parse_obj({
            "name": obj.get("name"),
            "allowed_entities": obj.get("allowedEntities"),
            "options": obj.get("options"),
            "type": obj.get("type"),
            "required": obj.get("required"),
            "description": obj.get("description")
        })
        return _obj

