# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, conlist, constr, validator
from phrasetms_client.models.id_reference import IdReference
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.uid_reference import UidReference

class CreateAnalyseAsyncV2Dto(BaseModel):
    """
    CreateAnalyseAsyncV2Dto
    """
    jobs: conlist(UidReference, max_items=50000, min_items=1) = Field(...)
    type: Optional[StrictStr] = Field(None, description="default: PreAnalyse")
    include_fuzzy_repetitions: Optional[StrictBool] = Field(None, alias="includeFuzzyRepetitions", description="Default: true")
    separate_fuzzy_repetitions: Optional[StrictBool] = Field(None, alias="separateFuzzyRepetitions", description="Default: false")
    include_confirmed_segments: Optional[StrictBool] = Field(None, alias="includeConfirmedSegments", description="Default: true")
    include_numbers: Optional[StrictBool] = Field(None, alias="includeNumbers", description="Default: true")
    include_locked_segments: Optional[StrictBool] = Field(None, alias="includeLockedSegments", description="Default: true")
    count_source_units: Optional[StrictBool] = Field(None, alias="countSourceUnits", description="Default: true")
    include_trans_memory: Optional[StrictBool] = Field(None, alias="includeTransMemory", description="Default: true. Works only for type=PreAnalyse.")
    include_non_translatables: Optional[StrictBool] = Field(None, alias="includeNonTranslatables", description="Default: false. Works only for type=PreAnalyse.")
    include_machine_translation_matches: Optional[StrictBool] = Field(None, alias="includeMachineTranslationMatches", description="Default: false. Works only for type=PreAnalyse.")
    trans_memory_post_editing: Optional[StrictBool] = Field(None, alias="transMemoryPostEditing", description="Default: false. Works only for type=PostAnalyse.")
    non_translatable_post_editing: Optional[StrictBool] = Field(None, alias="nonTranslatablePostEditing", description="Default: false. Works only for type=PostAnalyse.")
    machine_translate_post_editing: Optional[StrictBool] = Field(None, alias="machineTranslatePostEditing", description="Default: false. Works only for type=PostAnalyse.")
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    net_rate_scheme: Optional[IdReference] = Field(None, alias="netRateScheme")
    compare_workflow_level: Optional[conint(strict=True, le=15, ge=1)] = Field(None, alias="compareWorkflowLevel", description="Required for type=Compare")
    use_project_analysis_settings: Optional[StrictBool] = Field(None, alias="useProjectAnalysisSettings", description="Default: false. Use default project settings. Will be overwritten with setting sent         in the API call.")
    callback_url: Optional[StrictStr] = Field(None, alias="callbackUrl")
    provider: Optional[ProviderReference] = None
    __properties = ["jobs", "type", "includeFuzzyRepetitions", "separateFuzzyRepetitions", "includeConfirmedSegments", "includeNumbers", "includeLockedSegments", "countSourceUnits", "includeTransMemory", "includeNonTranslatables", "includeMachineTranslationMatches", "transMemoryPostEditing", "nonTranslatablePostEditing", "machineTranslatePostEditing", "name", "netRateScheme", "compareWorkflowLevel", "useProjectAnalysisSettings", "callbackUrl", "provider"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PreAnalyse', 'PostAnalyse', 'Compare'):
            raise ValueError("must be one of enum values ('PreAnalyse', 'PostAnalyse', 'Compare')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateAnalyseAsyncV2Dto:
        """Create an instance of CreateAnalyseAsyncV2Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in jobs (list)
        _items = []
        if self.jobs:
            for _item in self.jobs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['jobs'] = _items
        # override the default output from pydantic by calling `to_dict()` of net_rate_scheme
        if self.net_rate_scheme:
            _dict['netRateScheme'] = self.net_rate_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAnalyseAsyncV2Dto:
        """Create an instance of CreateAnalyseAsyncV2Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateAnalyseAsyncV2Dto.parse_obj(obj)

        _obj = CreateAnalyseAsyncV2Dto.parse_obj({
            "jobs": [UidReference.from_dict(_item) for _item in obj.get("jobs")] if obj.get("jobs") is not None else None,
            "type": obj.get("type"),
            "include_fuzzy_repetitions": obj.get("includeFuzzyRepetitions"),
            "separate_fuzzy_repetitions": obj.get("separateFuzzyRepetitions"),
            "include_confirmed_segments": obj.get("includeConfirmedSegments"),
            "include_numbers": obj.get("includeNumbers"),
            "include_locked_segments": obj.get("includeLockedSegments"),
            "count_source_units": obj.get("countSourceUnits"),
            "include_trans_memory": obj.get("includeTransMemory"),
            "include_non_translatables": obj.get("includeNonTranslatables"),
            "include_machine_translation_matches": obj.get("includeMachineTranslationMatches"),
            "trans_memory_post_editing": obj.get("transMemoryPostEditing"),
            "non_translatable_post_editing": obj.get("nonTranslatablePostEditing"),
            "machine_translate_post_editing": obj.get("machineTranslatePostEditing"),
            "name": obj.get("name"),
            "net_rate_scheme": IdReference.from_dict(obj.get("netRateScheme")) if obj.get("netRateScheme") is not None else None,
            "compare_workflow_level": obj.get("compareWorkflowLevel"),
            "use_project_analysis_settings": obj.get("useProjectAnalysisSettings"),
            "callback_url": obj.get("callbackUrl"),
            "provider": ProviderReference.from_dict(obj.get("provider")) if obj.get("provider") is not None else None
        })
        return _obj

