# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ContentstackAllOf(BaseModel):
    """
    ContentstackAllOf
    """
    auth_type: StrictStr = Field(..., alias="authType")
    region: Optional[StrictStr] = None
    non_localizable_blocks_uids: Optional[StrictStr] = Field(None, alias="nonLocalizableBlocksUids")
    target_langs_field_id: Optional[StrictStr] = Field(None, alias="targetLangsFieldId")
    api_key: StrictStr = Field(..., alias="apiKey")
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    translate_urls: Optional[StrictBool] = Field(None, alias="translateUrls", description="Default false")
    translate_tags: Optional[StrictBool] = Field(None, alias="translateTags", description="Default false")
    management_token: Optional[StrictStr] = Field(None, alias="managementToken")
    password: Optional[StrictStr] = None
    user_name: Optional[StrictStr] = Field(None, alias="userName")
    stack_wf_observed: Optional[StrictStr] = Field(None, alias="stackWFObserved")
    stack_wf_upon_import: Optional[StrictStr] = Field(None, alias="stackWFUponImport")
    stack_wf_export_source: Optional[StrictStr] = Field(None, alias="stackWFExportSource")
    stack_wf_export_translate: Optional[StrictStr] = Field(None, alias="stackWFExportTranslate")
    __properties = ["authType", "region", "nonLocalizableBlocksUids", "targetLangsFieldId", "apiKey", "sourceLang", "translateUrls", "translateTags", "managementToken", "password", "userName", "stackWFObserved", "stackWFUponImport", "stackWFExportSource", "stackWFExportTranslate"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ContentstackAllOf:
        """Create an instance of ContentstackAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ContentstackAllOf:
        """Create an instance of ContentstackAllOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ContentstackAllOf.parse_obj(obj)

        _obj = ContentstackAllOf.parse_obj({
            "auth_type": obj.get("authType"),
            "region": obj.get("region"),
            "non_localizable_blocks_uids": obj.get("nonLocalizableBlocksUids"),
            "target_langs_field_id": obj.get("targetLangsFieldId"),
            "api_key": obj.get("apiKey"),
            "source_lang": obj.get("sourceLang"),
            "translate_urls": obj.get("translateUrls"),
            "translate_tags": obj.get("translateTags"),
            "management_token": obj.get("managementToken"),
            "password": obj.get("password"),
            "user_name": obj.get("userName"),
            "stack_wf_observed": obj.get("stackWFObserved"),
            "stack_wf_upon_import": obj.get("stackWFUponImport"),
            "stack_wf_export_source": obj.get("stackWFExportSource"),
            "stack_wf_export_translate": obj.get("stackWFExportTranslate")
        })
        return _obj

