# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist

class ConceptDtov2(BaseModel):
    """
    ConceptDtov2
    """
    id: Optional[StrictStr] = None
    definition: Optional[StrictStr] = None
    domain: Optional[StrictStr] = None
    sub_domains: Optional[conlist(StrictStr)] = Field(None, alias="subDomains")
    url: Optional[StrictStr] = None
    note: Optional[StrictStr] = None
    __properties = ["id", "definition", "domain", "subDomains", "url", "note"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConceptDtov2:
        """Create an instance of ConceptDtov2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConceptDtov2:
        """Create an instance of ConceptDtov2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConceptDtov2.parse_obj(obj)

        _obj = ConceptDtov2.parse_obj({
            "id": obj.get("id"),
            "definition": obj.get("definition"),
            "domain": obj.get("domain"),
            "sub_domains": obj.get("subDomains"),
            "url": obj.get("url"),
            "note": obj.get("note")
        })
        return _obj

