# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from phrasetms_client.models.mention_dto import MentionDto
from phrasetms_client.models.mentionable_user_dto import MentionableUserDto

class CommentDto(BaseModel):
    """
    CommentDto
    """
    id: Optional[StrictStr] = None
    text: Optional[StrictStr] = None
    created_by: Optional[MentionableUserDto] = Field(None, alias="createdBy")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    date_modified: Optional[datetime] = Field(None, alias="dateModified")
    mentions: Optional[conlist(MentionDto)] = None
    __properties = ["id", "text", "createdBy", "dateCreated", "dateModified", "mentions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CommentDto:
        """Create an instance of CommentDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mentions (list)
        _items = []
        if self.mentions:
            for _item in self.mentions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mentions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CommentDto:
        """Create an instance of CommentDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CommentDto.parse_obj(obj)

        _obj = CommentDto.parse_obj({
            "id": obj.get("id"),
            "text": obj.get("text"),
            "created_by": MentionableUserDto.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "date_created": obj.get("dateCreated"),
            "date_modified": obj.get("dateModified"),
            "mentions": [MentionDto.from_dict(_item) for _item in obj.get("mentions")] if obj.get("mentions") is not None else None
        })
        return _obj

