# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from phrasetms_client.models.net_rate_scheme_reference import NetRateSchemeReference
from phrasetms_client.models.price_list_reference import PriceListReference
from phrasetms_client.models.user_reference import UserReference

class ClientDto(BaseModel):
    """
    ClientDto
    """
    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(None, alias="externalId")
    note: Optional[StrictStr] = None
    display_note_in_project: Optional[StrictBool] = Field(None, alias="displayNoteInProject", description="Default: false")
    price_list: Optional[PriceListReference] = Field(None, alias="priceList")
    net_rate_scheme: Optional[NetRateSchemeReference] = Field(None, alias="netRateScheme")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    __properties = ["id", "uid", "name", "externalId", "note", "displayNoteInProject", "priceList", "netRateScheme", "createdBy"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClientDto:
        """Create an instance of ClientDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of price_list
        if self.price_list:
            _dict['priceList'] = self.price_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of net_rate_scheme
        if self.net_rate_scheme:
            _dict['netRateScheme'] = self.net_rate_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClientDto:
        """Create an instance of ClientDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ClientDto.parse_obj(obj)

        _obj = ClientDto.parse_obj({
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "external_id": obj.get("externalId"),
            "note": obj.get("note"),
            "display_note_in_project": obj.get("displayNoteInProject"),
            "price_list": PriceListReference.from_dict(obj.get("priceList")) if obj.get("priceList") is not None else None,
            "net_rate_scheme": NetRateSchemeReference.from_dict(obj.get("netRateScheme")) if obj.get("netRateScheme") is not None else None,
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None
        })
        return _obj

