# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from phrasetms_client.models.async_request_dto import AsyncRequestDto
from phrasetms_client.models.metadata_response import MetadataResponse

class BackgroundTasksTmDto(BaseModel):
    """
    BackgroundTasksTmDto
    """
    status: Optional[StrictStr] = None
    finished_data_text: Optional[StrictStr] = Field(None, alias="finishedDataText")
    async_request: Optional[AsyncRequestDto] = Field(None, alias="asyncRequest")
    last_task_string: Optional[StrictStr] = Field(None, alias="lastTaskString")
    metadata: Optional[MetadataResponse] = None
    last_task_ok: Optional[StrictStr] = Field(None, alias="lastTaskOk")
    last_task_error: Optional[StrictStr] = Field(None, alias="lastTaskError")
    last_task_error_html: Optional[StrictStr] = Field(None, alias="lastTaskErrorHtml")
    __properties = ["status", "finishedDataText", "asyncRequest", "lastTaskString", "metadata", "lastTaskOk", "lastTaskError", "lastTaskErrorHtml"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BackgroundTasksTmDto:
        """Create an instance of BackgroundTasksTmDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of async_request
        if self.async_request:
            _dict['asyncRequest'] = self.async_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BackgroundTasksTmDto:
        """Create an instance of BackgroundTasksTmDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BackgroundTasksTmDto.parse_obj(obj)

        _obj = BackgroundTasksTmDto.parse_obj({
            "status": obj.get("status"),
            "finished_data_text": obj.get("finishedDataText"),
            "async_request": AsyncRequestDto.from_dict(obj.get("asyncRequest")) if obj.get("asyncRequest") is not None else None,
            "last_task_string": obj.get("lastTaskString"),
            "metadata": MetadataResponse.from_dict(obj.get("metadata")) if obj.get("metadata") is not None else None,
            "last_task_ok": obj.get("lastTaskOk"),
            "last_task_error": obj.get("lastTaskError"),
            "last_task_error_html": obj.get("lastTaskErrorHtml")
        })
        return _obj

