# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator

class Attribute(BaseModel):
    """
    Attribute
    """
    name: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    sub_attributes: Optional[conlist(Attribute)] = Field(None, alias="subAttributes")
    multi_valued: Optional[StrictBool] = Field(None, alias="multiValued")
    description: Optional[StrictStr] = None
    required: Optional[StrictBool] = None
    case_exact: Optional[StrictBool] = Field(None, alias="caseExact")
    mutability: Optional[StrictStr] = None
    returned: Optional[StrictStr] = None
    uniqueness: Optional[StrictStr] = None
    __properties = ["name", "type", "subAttributes", "multiValued", "description", "required", "caseExact", "mutability", "returned", "uniqueness"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('STRING', 'BOOLEAN', 'DECIMAL', 'INTEGER', 'DATE_TIME', 'BINARY', 'REFERENCE', 'COMPLEX'):
            raise ValueError("must be one of enum values ('STRING', 'BOOLEAN', 'DECIMAL', 'INTEGER', 'DATE_TIME', 'BINARY', 'REFERENCE', 'COMPLEX')")
        return value

    @validator('mutability')
    def mutability_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('READ_ONLY', 'READ_WRITE', 'IMMUTABLE', 'WRITE_ONLY'):
            raise ValueError("must be one of enum values ('READ_ONLY', 'READ_WRITE', 'IMMUTABLE', 'WRITE_ONLY')")
        return value

    @validator('returned')
    def returned_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('ALWAYS', 'NEVER', 'DEFAULT', 'REQUEST'):
            raise ValueError("must be one of enum values ('ALWAYS', 'NEVER', 'DEFAULT', 'REQUEST')")
        return value

    @validator('uniqueness')
    def uniqueness_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NONE', 'SERVER', 'GLOBAL'):
            raise ValueError("must be one of enum values ('NONE', 'SERVER', 'GLOBAL')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Attribute:
        """Create an instance of Attribute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in sub_attributes (list)
        _items = []
        if self.sub_attributes:
            for _item in self.sub_attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['subAttributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Attribute:
        """Create an instance of Attribute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Attribute.parse_obj(obj)

        _obj = Attribute.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "sub_attributes": [Attribute.from_dict(_item) for _item in obj.get("subAttributes")] if obj.get("subAttributes") is not None else None,
            "multi_valued": obj.get("multiValued"),
            "description": obj.get("description"),
            "required": obj.get("required"),
            "case_exact": obj.get("caseExact"),
            "mutability": obj.get("mutability"),
            "returned": obj.get("returned"),
            "uniqueness": obj.get("uniqueness")
        })
        return _obj

