# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from phrasetms_client.models.async_response_dto import AsyncResponseDto
from phrasetms_client.models.project_reference import ProjectReference
from phrasetms_client.models.user_reference import UserReference

class AsyncRequestDto(BaseModel):
    """
    AsyncRequestDto
    """
    id: Optional[StrictStr] = None
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    action: Optional[StrictStr] = None
    async_response: Optional[AsyncResponseDto] = Field(None, alias="asyncResponse")
    parent: Optional[AsyncRequestDto] = None
    project: Optional[ProjectReference] = None
    __properties = ["id", "createdBy", "dateCreated", "action", "asyncResponse", "parent", "project"]

    @validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PRE_ANALYSE', 'POST_ANALYSE', 'COMPARE_ANALYSE', 'PARENT_ANALYSE', 'PRE_TRANSLATE', 'ASYNC_TRANSLATE', 'IMPORT_JOB', 'IMPORT_FILE', 'ALIGN', 'EXPORT_TMX_BY_QUERY', 'EXPORT_TMX', 'IMPORT_TMX', 'INSERT_INTO_TM', 'DELETE_TM', 'CLEAR_TM', 'QA', 'QA_V3', 'UPDATE_CONTINUOUS_JOB', 'UPDATE_SOURCE', 'UPDATE_TARGET', 'EXTRACT_CLEANED_TMS', 'GLOSSARY_PUT', 'GLOSSARY_DELETE', 'CREATE_PROJECT', 'EXPORT_COMPLETE_FILE'):
            raise ValueError("must be one of enum values ('PRE_ANALYSE', 'POST_ANALYSE', 'COMPARE_ANALYSE', 'PARENT_ANALYSE', 'PRE_TRANSLATE', 'ASYNC_TRANSLATE', 'IMPORT_JOB', 'IMPORT_FILE', 'ALIGN', 'EXPORT_TMX_BY_QUERY', 'EXPORT_TMX', 'IMPORT_TMX', 'INSERT_INTO_TM', 'DELETE_TM', 'CLEAR_TM', 'QA', 'QA_V3', 'UPDATE_CONTINUOUS_JOB', 'UPDATE_SOURCE', 'UPDATE_TARGET', 'EXTRACT_CLEANED_TMS', 'GLOSSARY_PUT', 'GLOSSARY_DELETE', 'CREATE_PROJECT', 'EXPORT_COMPLETE_FILE')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AsyncRequestDto:
        """Create an instance of AsyncRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of async_response
        if self.async_response:
            _dict['asyncResponse'] = self.async_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent
        if self.parent:
            _dict['parent'] = self.parent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AsyncRequestDto:
        """Create an instance of AsyncRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AsyncRequestDto.parse_obj(obj)

        _obj = AsyncRequestDto.parse_obj({
            "id": obj.get("id"),
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "date_created": obj.get("dateCreated"),
            "action": obj.get("action"),
            "async_response": AsyncResponseDto.from_dict(obj.get("asyncResponse")) if obj.get("asyncResponse") is not None else None,
            "parent": AsyncRequestDto.from_dict(obj.get("parent")) if obj.get("parent") is not None else None,
            "project": ProjectReference.from_dict(obj.get("project")) if obj.get("project") is not None else None
        })
        return _obj

