# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from phrasetms_client.models.async_export_tmby_query_dto import AsyncExportTMByQueryDto
from phrasetms_client.models.async_request_dto import AsyncRequestDto

class AsyncExportTMByQueryResponseDto(BaseModel):
    """
    AsyncExportTMByQueryResponseDto
    """
    async_request: Optional[AsyncRequestDto] = Field(None, alias="asyncRequest")
    async_export: Optional[AsyncExportTMByQueryDto] = Field(None, alias="asyncExport")
    __properties = ["asyncRequest", "asyncExport"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AsyncExportTMByQueryResponseDto:
        """Create an instance of AsyncExportTMByQueryResponseDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of async_request
        if self.async_request:
            _dict['asyncRequest'] = self.async_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of async_export
        if self.async_export:
            _dict['asyncExport'] = self.async_export.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AsyncExportTMByQueryResponseDto:
        """Create an instance of AsyncExportTMByQueryResponseDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AsyncExportTMByQueryResponseDto.parse_obj(obj)

        _obj = AsyncExportTMByQueryResponseDto.parse_obj({
            "async_request": AsyncRequestDto.from_dict(obj.get("asyncRequest")) if obj.get("asyncRequest") is not None else None,
            "async_export": AsyncExportTMByQueryDto.from_dict(obj.get("asyncExport")) if obj.get("asyncExport") is not None else None
        })
        return _obj

