# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from phrasetms_client.models.import_status_dto import ImportStatusDto
from phrasetms_client.models.project_reference import ProjectReference
from phrasetms_client.models.project_workflow_step_reference import ProjectWorkflowStepReference

class AssignedJobDto(BaseModel):
    """
    AssignedJobDto
    """
    uid: Optional[StrictStr] = None
    inner_id: Optional[StrictStr] = Field(None, alias="innerId")
    filename: Optional[StrictStr] = None
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    status: Optional[StrictStr] = None
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    project: Optional[ProjectReference] = None
    workflow_step: Optional[ProjectWorkflowStepReference] = Field(None, alias="workflowStep")
    import_status: Optional[ImportStatusDto] = Field(None, alias="importStatus")
    imported: Optional[StrictBool] = None
    __properties = ["uid", "innerId", "filename", "dateDue", "dateCreated", "status", "targetLang", "sourceLang", "project", "workflowStep", "importStatus", "imported"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED'):
            raise ValueError("must be one of enum values ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AssignedJobDto:
        """Create an instance of AssignedJobDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        # override the default output from pydantic by calling `to_dict()` of import_status
        if self.import_status:
            _dict['importStatus'] = self.import_status.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AssignedJobDto:
        """Create an instance of AssignedJobDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AssignedJobDto.parse_obj(obj)

        _obj = AssignedJobDto.parse_obj({
            "uid": obj.get("uid"),
            "inner_id": obj.get("innerId"),
            "filename": obj.get("filename"),
            "date_due": obj.get("dateDue"),
            "date_created": obj.get("dateCreated"),
            "status": obj.get("status"),
            "target_lang": obj.get("targetLang"),
            "source_lang": obj.get("sourceLang"),
            "project": ProjectReference.from_dict(obj.get("project")) if obj.get("project") is not None else None,
            "workflow_step": ProjectWorkflowStepReference.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "import_status": ImportStatusDto.from_dict(obj.get("importStatus")) if obj.get("importStatus") is not None else None,
            "imported": obj.get("imported")
        })
        return _obj

