# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, validator
from phrasetms_client.models.abstract_analyse_settings_dto import AbstractAnalyseSettingsDto
from phrasetms_client.models.analyse_language_part_v3_dto import AnalyseLanguagePartV3Dto
from phrasetms_client.models.import_status_dto import ImportStatusDto
from phrasetms_client.models.net_rate_scheme_reference import NetRateSchemeReference
from phrasetms_client.models.project_reference import ProjectReference
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.user_reference import UserReference

class AnalyseV3Dto(BaseModel):
    """
    AnalyseV3Dto
    """
    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    inner_id: Optional[StrictInt] = Field(None, alias="innerId")
    type: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    provider: Optional[ProviderReference] = None
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    net_rate_scheme: Optional[NetRateSchemeReference] = Field(None, alias="netRateScheme")
    can_change_net_rate_scheme: Optional[StrictBool] = Field(None, alias="canChangeNetRateScheme")
    analyse_language_parts: Optional[conlist(AnalyseLanguagePartV3Dto)] = Field(None, alias="analyseLanguageParts")
    settings: Optional[AbstractAnalyseSettingsDto] = None
    outdated: Optional[StrictBool] = None
    import_status: Optional[ImportStatusDto] = Field(None, alias="importStatus")
    pure_warnings: Optional[conlist(StrictStr)] = Field(None, alias="pureWarnings")
    project: Optional[ProjectReference] = None
    __properties = ["id", "uid", "innerId", "type", "name", "provider", "createdBy", "dateCreated", "netRateScheme", "canChangeNetRateScheme", "analyseLanguageParts", "settings", "outdated", "importStatus", "pureWarnings", "project"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PreAnalyse', 'PostAnalyse', 'PreAnalyseTarget', 'Compare', 'PreAnalyseProvider'):
            raise ValueError("must be one of enum values ('PreAnalyse', 'PostAnalyse', 'PreAnalyseTarget', 'Compare', 'PreAnalyseProvider')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnalyseV3Dto:
        """Create an instance of AnalyseV3Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of net_rate_scheme
        if self.net_rate_scheme:
            _dict['netRateScheme'] = self.net_rate_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in analyse_language_parts (list)
        _items = []
        if self.analyse_language_parts:
            for _item in self.analyse_language_parts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['analyseLanguageParts'] = _items
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of import_status
        if self.import_status:
            _dict['importStatus'] = self.import_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AnalyseV3Dto:
        """Create an instance of AnalyseV3Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AnalyseV3Dto.parse_obj(obj)

        _obj = AnalyseV3Dto.parse_obj({
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "inner_id": obj.get("innerId"),
            "type": obj.get("type"),
            "name": obj.get("name"),
            "provider": ProviderReference.from_dict(obj.get("provider")) if obj.get("provider") is not None else None,
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "date_created": obj.get("dateCreated"),
            "net_rate_scheme": NetRateSchemeReference.from_dict(obj.get("netRateScheme")) if obj.get("netRateScheme") is not None else None,
            "can_change_net_rate_scheme": obj.get("canChangeNetRateScheme"),
            "analyse_language_parts": [AnalyseLanguagePartV3Dto.from_dict(_item) for _item in obj.get("analyseLanguageParts")] if obj.get("analyseLanguageParts") is not None else None,
            "settings": AbstractAnalyseSettingsDto.from_dict(obj.get("settings")) if obj.get("settings") is not None else None,
            "outdated": obj.get("outdated"),
            "import_status": ImportStatusDto.from_dict(obj.get("importStatus")) if obj.get("importStatus") is not None else None,
            "pure_warnings": obj.get("pureWarnings"),
            "project": ProjectReference.from_dict(obj.get("project")) if obj.get("project") is not None else None
        })
        return _obj

