# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class AnalyseSettingsDto(BaseModel):
    """
    AnalyseSettingsDto
    """
    type: Optional[StrictStr] = None
    include_fuzzy_repetitions: Optional[StrictBool] = Field(None, alias="includeFuzzyRepetitions", description="Default: false")
    separate_fuzzy_repetitions: Optional[StrictBool] = Field(None, alias="separateFuzzyRepetitions", description="Default: false")
    include_non_translatables: Optional[StrictBool] = Field(None, alias="includeNonTranslatables", description="Default: false")
    include_machine_translation_matches: Optional[StrictBool] = Field(None, alias="includeMachineTranslationMatches", description="Default: false")
    include_confirmed_segments: Optional[StrictBool] = Field(None, alias="includeConfirmedSegments", description="Default: false")
    include_numbers: Optional[StrictBool] = Field(None, alias="includeNumbers", description="Default: false")
    include_locked_segments: Optional[StrictBool] = Field(None, alias="includeLockedSegments", description="Default: false")
    count_source_units: Optional[StrictBool] = Field(None, alias="countSourceUnits", description="Default: false")
    include_trans_memory: Optional[StrictBool] = Field(None, alias="includeTransMemory", description="Default: false")
    naming_pattern: Optional[StrictStr] = Field(None, alias="namingPattern")
    analyze_by_language: Optional[StrictBool] = Field(None, alias="analyzeByLanguage", description="Default: false")
    analyze_by_provider: Optional[StrictBool] = Field(None, alias="analyzeByProvider", description="Default: false")
    allow_automatic_post_analysis: Optional[StrictBool] = Field(None, alias="allowAutomaticPostAnalysis", description="If automatic post analysis should be created after update source. Default: false")
    trans_memory_post_editing: Optional[StrictBool] = Field(None, alias="transMemoryPostEditing", description="Default: false")
    non_translatable_post_editing: Optional[StrictBool] = Field(None, alias="nonTranslatablePostEditing", description="Default: false")
    machine_translate_post_editing: Optional[StrictBool] = Field(None, alias="machineTranslatePostEditing", description="Default: false")
    __properties = ["type", "includeFuzzyRepetitions", "separateFuzzyRepetitions", "includeNonTranslatables", "includeMachineTranslationMatches", "includeConfirmedSegments", "includeNumbers", "includeLockedSegments", "countSourceUnits", "includeTransMemory", "namingPattern", "analyzeByLanguage", "analyzeByProvider", "allowAutomaticPostAnalysis", "transMemoryPostEditing", "nonTranslatablePostEditing", "machineTranslatePostEditing"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PreAnalyse', 'PostAnalyse', 'PreAnalyseTarget', 'Compare'):
            raise ValueError("must be one of enum values ('PreAnalyse', 'PostAnalyse', 'PreAnalyseTarget', 'Compare')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnalyseSettingsDto:
        """Create an instance of AnalyseSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AnalyseSettingsDto:
        """Create an instance of AnalyseSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AnalyseSettingsDto.parse_obj(obj)

        _obj = AnalyseSettingsDto.parse_obj({
            "type": obj.get("type"),
            "include_fuzzy_repetitions": obj.get("includeFuzzyRepetitions"),
            "separate_fuzzy_repetitions": obj.get("separateFuzzyRepetitions"),
            "include_non_translatables": obj.get("includeNonTranslatables"),
            "include_machine_translation_matches": obj.get("includeMachineTranslationMatches"),
            "include_confirmed_segments": obj.get("includeConfirmedSegments"),
            "include_numbers": obj.get("includeNumbers"),
            "include_locked_segments": obj.get("includeLockedSegments"),
            "count_source_units": obj.get("countSourceUnits"),
            "include_trans_memory": obj.get("includeTransMemory"),
            "naming_pattern": obj.get("namingPattern"),
            "analyze_by_language": obj.get("analyzeByLanguage"),
            "analyze_by_provider": obj.get("analyzeByProvider"),
            "allow_automatic_post_analysis": obj.get("allowAutomaticPostAnalysis"),
            "trans_memory_post_editing": obj.get("transMemoryPostEditing"),
            "non_translatable_post_editing": obj.get("nonTranslatablePostEditing"),
            "machine_translate_post_editing": obj.get("machineTranslatePostEditing")
        })
        return _obj

