# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from phrasetms_client.models.analyse_job_reference import AnalyseJobReference
from phrasetms_client.models.data_dto import DataDto
from phrasetms_client.models.trans_memory_reference_dto_v2 import TransMemoryReferenceDtoV2

class AnalyseLanguagePartV3Dto(BaseModel):
    """
    AnalyseLanguagePartV3Dto
    """
    id: Optional[StrictStr] = None
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    data: Optional[DataDto] = None
    discounted_data: Optional[DataDto] = Field(None, alias="discountedData")
    jobs: Optional[conlist(AnalyseJobReference)] = None
    trans_memories: Optional[conlist(TransMemoryReferenceDtoV2)] = Field(None, alias="transMemories")
    __properties = ["id", "sourceLang", "targetLang", "data", "discountedData", "jobs", "transMemories"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AnalyseLanguagePartV3Dto:
        """Create an instance of AnalyseLanguagePartV3Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discounted_data
        if self.discounted_data:
            _dict['discountedData'] = self.discounted_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in jobs (list)
        _items = []
        if self.jobs:
            for _item in self.jobs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['jobs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in trans_memories (list)
        _items = []
        if self.trans_memories:
            for _item in self.trans_memories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['transMemories'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AnalyseLanguagePartV3Dto:
        """Create an instance of AnalyseLanguagePartV3Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AnalyseLanguagePartV3Dto.parse_obj(obj)

        _obj = AnalyseLanguagePartV3Dto.parse_obj({
            "id": obj.get("id"),
            "source_lang": obj.get("sourceLang"),
            "target_lang": obj.get("targetLang"),
            "data": DataDto.from_dict(obj.get("data")) if obj.get("data") is not None else None,
            "discounted_data": DataDto.from_dict(obj.get("discountedData")) if obj.get("discountedData") is not None else None,
            "jobs": [AnalyseJobReference.from_dict(_item) for _item in obj.get("jobs")] if obj.get("jobs") is not None else None,
            "trans_memories": [TransMemoryReferenceDtoV2.from_dict(_item) for _item in obj.get("transMemories")] if obj.get("transMemories") is not None else None
        })
        return _obj

