# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from phrasetms_client.models.business_unit_reference import BusinessUnitReference
from phrasetms_client.models.client_reference import ClientReference
from phrasetms_client.models.cost_center_reference import CostCenterReference
from phrasetms_client.models.progress_dto_v2 import ProgressDtoV2
from phrasetms_client.models.project_workflow_step_dto_v2 import ProjectWorkflowStepDtoV2
from phrasetms_client.models.user_reference import UserReference

class AdminProjectManagerV2AllOf(BaseModel):
    """
    AdminProjectManagerV2AllOf
    """
    shared: Optional[StrictBool] = Field(None, description="Default: false")
    progress: Optional[ProgressDtoV2] = None
    client: Optional[ClientReference] = None
    cost_center: Optional[CostCenterReference] = Field(None, alias="costCenter")
    business_unit: Optional[BusinessUnitReference] = Field(None, alias="businessUnit")
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    status: Optional[StrictStr] = None
    purchase_order: Optional[StrictStr] = Field(None, alias="purchaseOrder")
    is_published_on_job_board: Optional[StrictBool] = Field(None, alias="isPublishedOnJobBoard", description="Default: false")
    note: Optional[StrictStr] = None
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    quality_assurance_settings: Optional[Dict[str, Any]] = Field(None, alias="qualityAssuranceSettings")
    workflow_steps: Optional[conlist(ProjectWorkflowStepDtoV2)] = Field(None, alias="workflowSteps")
    analyse_settings: Optional[Dict[str, Any]] = Field(None, alias="analyseSettings")
    access_settings: Optional[Dict[str, Any]] = Field(None, alias="accessSettings")
    financial_settings: Optional[Dict[str, Any]] = Field(None, alias="financialSettings")
    __properties = ["shared", "progress", "client", "costCenter", "businessUnit", "dateDue", "status", "purchaseOrder", "isPublishedOnJobBoard", "note", "createdBy", "qualityAssuranceSettings", "workflowSteps", "analyseSettings", "accessSettings", "financialSettings"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NEW', 'ASSIGNED', 'COMPLETED', 'ACCEPTED_BY_VENDOR', 'DECLINED_BY_VENDOR', 'COMPLETED_BY_VENDOR', 'CANCELLED'):
            raise ValueError("must be one of enum values ('NEW', 'ASSIGNED', 'COMPLETED', 'ACCEPTED_BY_VENDOR', 'DECLINED_BY_VENDOR', 'COMPLETED_BY_VENDOR', 'CANCELLED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AdminProjectManagerV2AllOf:
        """Create an instance of AdminProjectManagerV2AllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of progress
        if self.progress:
            _dict['progress'] = self.progress.to_dict()
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_center
        if self.cost_center:
            _dict['costCenter'] = self.cost_center.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_unit
        if self.business_unit:
            _dict['businessUnit'] = self.business_unit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_steps (list)
        _items = []
        if self.workflow_steps:
            for _item in self.workflow_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workflowSteps'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminProjectManagerV2AllOf:
        """Create an instance of AdminProjectManagerV2AllOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AdminProjectManagerV2AllOf.parse_obj(obj)

        _obj = AdminProjectManagerV2AllOf.parse_obj({
            "shared": obj.get("shared"),
            "progress": ProgressDtoV2.from_dict(obj.get("progress")) if obj.get("progress") is not None else None,
            "client": ClientReference.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "cost_center": CostCenterReference.from_dict(obj.get("costCenter")) if obj.get("costCenter") is not None else None,
            "business_unit": BusinessUnitReference.from_dict(obj.get("businessUnit")) if obj.get("businessUnit") is not None else None,
            "date_due": obj.get("dateDue"),
            "status": obj.get("status"),
            "purchase_order": obj.get("purchaseOrder"),
            "is_published_on_job_board": obj.get("isPublishedOnJobBoard"),
            "note": obj.get("note"),
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "quality_assurance_settings": obj.get("qualityAssuranceSettings"),
            "workflow_steps": [ProjectWorkflowStepDtoV2.from_dict(_item) for _item in obj.get("workflowSteps")] if obj.get("workflowSteps") is not None else None,
            "analyse_settings": obj.get("analyseSettings"),
            "access_settings": obj.get("accessSettings"),
            "financial_settings": obj.get("financialSettings")
        })
        return _obj

