# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from phrasetms_client.models.toggleable_weight_dto import ToggleableWeightDto

class AccuracyWeightsDto(BaseModel):
    """
    AccuracyWeightsDto
    """
    accuracy: Optional[ToggleableWeightDto] = None
    addition: Optional[ToggleableWeightDto] = None
    omission: Optional[ToggleableWeightDto] = None
    mistranslation: Optional[ToggleableWeightDto] = None
    under_translation: Optional[ToggleableWeightDto] = Field(None, alias="underTranslation")
    untranslated: Optional[ToggleableWeightDto] = None
    improper_tm_match: Optional[ToggleableWeightDto] = Field(None, alias="improperTmMatch")
    over_translation: Optional[ToggleableWeightDto] = Field(None, alias="overTranslation")
    __properties = ["accuracy", "addition", "omission", "mistranslation", "underTranslation", "untranslated", "improperTmMatch", "overTranslation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccuracyWeightsDto:
        """Create an instance of AccuracyWeightsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of accuracy
        if self.accuracy:
            _dict['accuracy'] = self.accuracy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of addition
        if self.addition:
            _dict['addition'] = self.addition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of omission
        if self.omission:
            _dict['omission'] = self.omission.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mistranslation
        if self.mistranslation:
            _dict['mistranslation'] = self.mistranslation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of under_translation
        if self.under_translation:
            _dict['underTranslation'] = self.under_translation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of untranslated
        if self.untranslated:
            _dict['untranslated'] = self.untranslated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of improper_tm_match
        if self.improper_tm_match:
            _dict['improperTmMatch'] = self.improper_tm_match.to_dict()
        # override the default output from pydantic by calling `to_dict()` of over_translation
        if self.over_translation:
            _dict['overTranslation'] = self.over_translation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccuracyWeightsDto:
        """Create an instance of AccuracyWeightsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccuracyWeightsDto.parse_obj(obj)

        _obj = AccuracyWeightsDto.parse_obj({
            "accuracy": ToggleableWeightDto.from_dict(obj.get("accuracy")) if obj.get("accuracy") is not None else None,
            "addition": ToggleableWeightDto.from_dict(obj.get("addition")) if obj.get("addition") is not None else None,
            "omission": ToggleableWeightDto.from_dict(obj.get("omission")) if obj.get("omission") is not None else None,
            "mistranslation": ToggleableWeightDto.from_dict(obj.get("mistranslation")) if obj.get("mistranslation") is not None else None,
            "under_translation": ToggleableWeightDto.from_dict(obj.get("underTranslation")) if obj.get("underTranslation") is not None else None,
            "untranslated": ToggleableWeightDto.from_dict(obj.get("untranslated")) if obj.get("untranslated") is not None else None,
            "improper_tm_match": ToggleableWeightDto.from_dict(obj.get("improperTmMatch")) if obj.get("improperTmMatch") is not None else None,
            "over_translation": ToggleableWeightDto.from_dict(obj.get("overTranslation")) if obj.get("overTranslation") is not None else None
        })
        return _obj

