# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json
import phrasetms_client.models

from datetime import datetime
from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from phrasetms_client.models.domain_reference import DomainReference
from phrasetms_client.models.mt_settings_per_language_reference import MTSettingsPerLanguageReference
from phrasetms_client.models.reference_file_reference import ReferenceFileReference
from phrasetms_client.models.sub_domain_reference import SubDomainReference
from phrasetms_client.models.user_reference import UserReference

class AbstractProjectDtoV2(BaseModel):
    """
    Base projectDto
    """
    uid: Optional[StrictStr] = None
    internal_id: Optional[StrictInt] = Field(None, alias="internalId")
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    domain: Optional[DomainReference] = None
    sub_domain: Optional[SubDomainReference] = Field(None, alias="subDomain")
    owner: Optional[UserReference] = None
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    target_langs: Optional[conlist(StrictStr, unique_items=True)] = Field(None, alias="targetLangs")
    references: Optional[conlist(ReferenceFileReference)] = None
    mt_settings_per_language_list: Optional[conlist(MTSettingsPerLanguageReference)] = Field(None, alias="mtSettingsPerLanguageList")
    user_role: Optional[StrictStr] = Field(None, alias="userRole", description="Response differs based on user's role")
    __properties = ["uid", "internalId", "id", "name", "dateCreated", "domain", "subDomain", "owner", "sourceLang", "targetLangs", "references", "mtSettingsPerLanguageList", "userRole"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AbstractProjectDtoV2:  # noqa: F821
        """Create an instance of AbstractProjectDtoV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "user_role",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item in self.references:
                if _item:
                    _items.append(_item.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mt_settings_per_language_list (list)
        _items = []
        if self.mt_settings_per_language_list:
            for _item in self.mt_settings_per_language_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtSettingsPerLanguageList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AbstractProjectDtoV2:  # noqa: F821
        """Create an instance of AbstractProjectDtoV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AbstractProjectDtoV2.parse_obj(obj)

        _obj = AbstractProjectDtoV2.parse_obj({
            "uid": obj.get("uid"),
            "internal_id": obj.get("internalId"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "date_created": obj.get("dateCreated"),
            "domain": DomainReference.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": SubDomainReference.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "owner": UserReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None,
            "source_lang": obj.get("sourceLang"),
            "target_langs": obj.get("targetLangs"),
            "references": [ReferenceFileReference.from_dict(_item) for _item in obj.get("references")] if obj.get("references") is not None else None,
            "mt_settings_per_language_list": [MTSettingsPerLanguageReference.from_dict(_item) for _item in obj.get("mtSettingsPerLanguageList")] if obj.get("mtSettingsPerLanguageList") is not None else None,
            "user_role": obj.get("userRole"),
        })
        return _obj

