# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, conint, conlist, validator

from typing import Optional

from phrasetms_client.models.create_web_hook_dto import CreateWebHookDto
from phrasetms_client.models.page_dto_web_hook_dto_v2 import PageDtoWebHookDtoV2
from phrasetms_client.models.page_dto_webhook_call_dto import PageDtoWebhookCallDto
from phrasetms_client.models.replay_request_dto import ReplayRequestDto
from phrasetms_client.models.web_hook_dto_v2 import WebHookDtoV2
from phrasetms_client.models.webhook_previews_dto import WebhookPreviewsDto

from phrasetms_client.api_client import ApiClient
from phrasetms_client.api_response import ApiResponse
from phrasetms_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WebhookApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_web_hook1(self, body : Optional[CreateWebHookDto] = None, **kwargs) -> WebHookDtoV2:  # noqa: E501
        """Create webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_web_hook1(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: CreateWebHookDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebHookDtoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_web_hook1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_web_hook1_with_http_info(body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_web_hook1_with_http_info(self, body : Optional[CreateWebHookDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_web_hook1_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: CreateWebHookDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebHookDtoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_web_hook1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '201': "WebHookDtoV2",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/webhooks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_web_hook1(self, web_hook_uid : StrictStr, **kwargs) -> None:  # noqa: E501
        """Delete webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_web_hook1(web_hook_uid, async_req=True)
        >>> result = thread.get()

        :param web_hook_uid: (required)
        :type web_hook_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_web_hook1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_web_hook1_with_http_info(web_hook_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_web_hook1_with_http_info(self, web_hook_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_web_hook1_with_http_info(web_hook_uid, async_req=True)
        >>> result = thread.get()

        :param web_hook_uid: (required)
        :type web_hook_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'web_hook_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_web_hook1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['web_hook_uid']:
            _path_params['webHookUid'] = _params['web_hook_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v2/webhooks/{webHookUid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_web_hook1(self, web_hook_uid : StrictStr, **kwargs) -> WebHookDtoV2:  # noqa: E501
        """Get webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_web_hook1(web_hook_uid, async_req=True)
        >>> result = thread.get()

        :param web_hook_uid: (required)
        :type web_hook_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebHookDtoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_web_hook1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_web_hook1_with_http_info(web_hook_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def get_web_hook1_with_http_info(self, web_hook_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_web_hook1_with_http_info(web_hook_uid, async_req=True)
        >>> result = thread.get()

        :param web_hook_uid: (required)
        :type web_hook_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebHookDtoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'web_hook_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_hook1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['web_hook_uid']:
            _path_params['webHookUid'] = _params['web_hook_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "WebHookDtoV2",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/webhooks/{webHookUid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_web_hook_list1(self, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 50")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter by webhook name")] = None, status : Annotated[Optional[StrictStr], Field(description="Filter by enabled/disabled status")] = None, url : Annotated[Optional[StrictStr], Field(description="Filter by webhook URL")] = None, events : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook events")] = None, created_by : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook creators UIDs")] = None, modified_by : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook updaters UIDs")] = None, sort_field : Annotated[Optional[StrictStr], Field(description="Sort by this field")] = None, sort_trend : Annotated[Optional[StrictStr], Field(description="Sort direction")] = None, **kwargs) -> PageDtoWebHookDtoV2:  # noqa: E501
        """Lists webhooks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_web_hook_list1(page_number, page_size, name, status, url, events, created_by, modified_by, sort_field, sort_trend, async_req=True)
        >>> result = thread.get()

        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 50
        :type page_size: int
        :param name: Filter by webhook name
        :type name: str
        :param status: Filter by enabled/disabled status
        :type status: str
        :param url: Filter by webhook URL
        :type url: str
        :param events: Filter by webhook events
        :type events: List[str]
        :param created_by: Filter by webhook creators UIDs
        :type created_by: List[str]
        :param modified_by: Filter by webhook updaters UIDs
        :type modified_by: List[str]
        :param sort_field: Sort by this field
        :type sort_field: str
        :param sort_trend: Sort direction
        :type sort_trend: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoWebHookDtoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_web_hook_list1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_web_hook_list1_with_http_info(page_number, page_size, name, status, url, events, created_by, modified_by, sort_field, sort_trend, **kwargs)  # noqa: E501

    @validate_arguments
    def get_web_hook_list1_with_http_info(self, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 50")] = None, name : Annotated[Optional[StrictStr], Field(description="Filter by webhook name")] = None, status : Annotated[Optional[StrictStr], Field(description="Filter by enabled/disabled status")] = None, url : Annotated[Optional[StrictStr], Field(description="Filter by webhook URL")] = None, events : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook events")] = None, created_by : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook creators UIDs")] = None, modified_by : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook updaters UIDs")] = None, sort_field : Annotated[Optional[StrictStr], Field(description="Sort by this field")] = None, sort_trend : Annotated[Optional[StrictStr], Field(description="Sort direction")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Lists webhooks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_web_hook_list1_with_http_info(page_number, page_size, name, status, url, events, created_by, modified_by, sort_field, sort_trend, async_req=True)
        >>> result = thread.get()

        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 50
        :type page_size: int
        :param name: Filter by webhook name
        :type name: str
        :param status: Filter by enabled/disabled status
        :type status: str
        :param url: Filter by webhook URL
        :type url: str
        :param events: Filter by webhook events
        :type events: List[str]
        :param created_by: Filter by webhook creators UIDs
        :type created_by: List[str]
        :param modified_by: Filter by webhook updaters UIDs
        :type modified_by: List[str]
        :param sort_field: Sort by this field
        :type sort_field: str
        :param sort_trend: Sort direction
        :type sort_trend: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoWebHookDtoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'page_number',
            'page_size',
            'name',
            'status',
            'url',
            'events',
            'created_by',
            'modified_by',
            'sort_field',
            'sort_trend'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_hook_list1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status'].value))

        if _params.get('url') is not None:  # noqa: E501
            _query_params.append(('url', _params['url']))

        if _params.get('events') is not None:  # noqa: E501
            _query_params.append(('events', _params['events']))
            _collection_formats['events'] = 'multi'

        if _params.get('created_by') is not None:  # noqa: E501
            _query_params.append(('createdBy', _params['created_by']))
            _collection_formats['createdBy'] = 'multi'

        if _params.get('modified_by') is not None:  # noqa: E501
            _query_params.append(('modifiedBy', _params['modified_by']))
            _collection_formats['modifiedBy'] = 'multi'

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sortField', _params['sort_field'].value))

        if _params.get('sort_trend') is not None:  # noqa: E501
            _query_params.append(('sortTrend', _params['sort_trend'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoWebHookDtoV2",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/webhooks', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_webhook_calls_list(self, page_number : Annotated[Optional[StrictInt], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 50")] = None, events : Annotated[Optional[conlist(StrictStr)], Field(description="List of Webhook events to filter by")] = None, status : Annotated[Optional[StrictStr], Field(description="Status of Webhook calls to filter by")] = None, webhook_uid : Annotated[Optional[StrictStr], Field(description="UID of Webhook to filter by")] = None, parent_uid : Annotated[Optional[StrictStr], Field(description="UID of parent webhook call to filter by")] = None, **kwargs) -> PageDtoWebhookCallDto:  # noqa: E501
        """Lists webhook calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_webhook_calls_list(page_number, page_size, events, status, webhook_uid, parent_uid, async_req=True)
        >>> result = thread.get()

        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 50
        :type page_size: int
        :param events: List of Webhook events to filter by
        :type events: List[str]
        :param status: Status of Webhook calls to filter by
        :type status: str
        :param webhook_uid: UID of Webhook to filter by
        :type webhook_uid: str
        :param parent_uid: UID of parent webhook call to filter by
        :type parent_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoWebhookCallDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_webhook_calls_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_webhook_calls_list_with_http_info(page_number, page_size, events, status, webhook_uid, parent_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def get_webhook_calls_list_with_http_info(self, page_number : Annotated[Optional[StrictInt], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 50")] = None, events : Annotated[Optional[conlist(StrictStr)], Field(description="List of Webhook events to filter by")] = None, status : Annotated[Optional[StrictStr], Field(description="Status of Webhook calls to filter by")] = None, webhook_uid : Annotated[Optional[StrictStr], Field(description="UID of Webhook to filter by")] = None, parent_uid : Annotated[Optional[StrictStr], Field(description="UID of parent webhook call to filter by")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Lists webhook calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_webhook_calls_list_with_http_info(page_number, page_size, events, status, webhook_uid, parent_uid, async_req=True)
        >>> result = thread.get()

        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 50
        :type page_size: int
        :param events: List of Webhook events to filter by
        :type events: List[str]
        :param status: Status of Webhook calls to filter by
        :type status: str
        :param webhook_uid: UID of Webhook to filter by
        :type webhook_uid: str
        :param parent_uid: UID of parent webhook call to filter by
        :type parent_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoWebhookCallDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'page_number',
            'page_size',
            'events',
            'status',
            'webhook_uid',
            'parent_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_calls_list" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        if _params.get('events') is not None:  # noqa: E501
            _query_params.append(('events', _params['events']))
            _collection_formats['events'] = 'multi'

        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status'].value))

        if _params.get('webhook_uid') is not None:  # noqa: E501
            _query_params.append(('webhookUid', _params['webhook_uid']))

        if _params.get('parent_uid') is not None:  # noqa: E501
            _query_params.append(('parentUid', _params['parent_uid']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoWebhookCallDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/webhooksCalls', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_webhook_previews(self, events : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook events, example for multiple: ?events=JOB_CREATED&events=JOB_UPDATED")] = None, **kwargs) -> WebhookPreviewsDto:  # noqa: E501
        """Get webhook body previews  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_webhook_previews(events, async_req=True)
        >>> result = thread.get()

        :param events: Filter by webhook events, example for multiple: ?events=JOB_CREATED&events=JOB_UPDATED
        :type events: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebhookPreviewsDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_webhook_previews_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_webhook_previews_with_http_info(events, **kwargs)  # noqa: E501

    @validate_arguments
    def get_webhook_previews_with_http_info(self, events : Annotated[Optional[conlist(StrictStr)], Field(description="Filter by webhook events, example for multiple: ?events=JOB_CREATED&events=JOB_UPDATED")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get webhook body previews  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_webhook_previews_with_http_info(events, async_req=True)
        >>> result = thread.get()

        :param events: Filter by webhook events, example for multiple: ?events=JOB_CREATED&events=JOB_UPDATED
        :type events: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebhookPreviewsDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'events'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_previews" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('events') is not None:  # noqa: E501
            _query_params.append(('events', _params['events']))
            _collection_formats['events'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "WebhookPreviewsDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/webhooks/previews', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def replay_last(self, number_of_calls : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Number of calls to be replayed")] = None, events : Annotated[Optional[conlist(StrictStr)], Field(description="List of Webhook events to filter by")] = None, status : Annotated[Optional[StrictStr], Field(description="Status of Webhook calls to filter by")] = None, **kwargs) -> None:  # noqa: E501
        """Replay last webhook calls  # noqa: E501

         Replays specified number of last Webhook calls from oldest to the newest one   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replay_last(number_of_calls, events, status, async_req=True)
        >>> result = thread.get()

        :param number_of_calls: Number of calls to be replayed
        :type number_of_calls: int
        :param events: List of Webhook events to filter by
        :type events: List[str]
        :param status: Status of Webhook calls to filter by
        :type status: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the replay_last_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.replay_last_with_http_info(number_of_calls, events, status, **kwargs)  # noqa: E501

    @validate_arguments
    def replay_last_with_http_info(self, number_of_calls : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Number of calls to be replayed")] = None, events : Annotated[Optional[conlist(StrictStr)], Field(description="List of Webhook events to filter by")] = None, status : Annotated[Optional[StrictStr], Field(description="Status of Webhook calls to filter by")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Replay last webhook calls  # noqa: E501

         Replays specified number of last Webhook calls from oldest to the newest one   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replay_last_with_http_info(number_of_calls, events, status, async_req=True)
        >>> result = thread.get()

        :param number_of_calls: Number of calls to be replayed
        :type number_of_calls: int
        :param events: List of Webhook events to filter by
        :type events: List[str]
        :param status: Status of Webhook calls to filter by
        :type status: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'number_of_calls',
            'events',
            'status'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replay_last" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('number_of_calls') is not None:  # noqa: E501
            _query_params.append(('numberOfCalls', _params['number_of_calls']))

        if _params.get('events') is not None:  # noqa: E501
            _query_params.append(('events', _params['events']))
            _collection_formats['events'] = 'multi'

        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/webhooksCalls/replay/latest', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def replay_webhook_calls(self, body : Optional[ReplayRequestDto] = None, **kwargs) -> None:  # noqa: E501
        """Replay webhook calls  # noqa: E501

         Replays given list of Webhook Calls in specified order in the request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replay_webhook_calls(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: ReplayRequestDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the replay_webhook_calls_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.replay_webhook_calls_with_http_info(body, **kwargs)  # noqa: E501

    @validate_arguments
    def replay_webhook_calls_with_http_info(self, body : Optional[ReplayRequestDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Replay webhook calls  # noqa: E501

         Replays given list of Webhook Calls in specified order in the request   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.replay_webhook_calls_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: ReplayRequestDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replay_webhook_calls" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/webhooksCalls/replay', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def send_test_webhook(self, webhook_uid : Annotated[StrictStr, Field(..., description="UID of the webhook")], event : Annotated[StrictStr, Field(..., description="Event of test webhook")], **kwargs) -> None:  # noqa: E501
        """Send test webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_test_webhook(webhook_uid, event, async_req=True)
        >>> result = thread.get()

        :param webhook_uid: UID of the webhook (required)
        :type webhook_uid: str
        :param event: Event of test webhook (required)
        :type event: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the send_test_webhook_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.send_test_webhook_with_http_info(webhook_uid, event, **kwargs)  # noqa: E501

    @validate_arguments
    def send_test_webhook_with_http_info(self, webhook_uid : Annotated[StrictStr, Field(..., description="UID of the webhook")], event : Annotated[StrictStr, Field(..., description="Event of test webhook")], **kwargs) -> ApiResponse:  # noqa: E501
        """Send test webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_test_webhook_with_http_info(webhook_uid, event, async_req=True)
        >>> result = thread.get()

        :param webhook_uid: UID of the webhook (required)
        :type webhook_uid: str
        :param event: Event of test webhook (required)
        :type event: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'webhook_uid',
            'event'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_test_webhook" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['webhook_uid']:
            _path_params['webhookUid'] = _params['webhook_uid']


        # process the query parameters
        _query_params = []
        if _params.get('event') is not None:  # noqa: E501
            _query_params.append(('event', _params['event'].value))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v2/webhooks/{webhookUid}/test', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_web_hook1(self, web_hook_uid : StrictStr, body : Optional[CreateWebHookDto] = None, **kwargs) -> WebHookDtoV2:  # noqa: E501
        """Edit webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_web_hook1(web_hook_uid, body, async_req=True)
        >>> result = thread.get()

        :param web_hook_uid: (required)
        :type web_hook_uid: str
        :param body:
        :type body: CreateWebHookDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebHookDtoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_web_hook1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_web_hook1_with_http_info(web_hook_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_web_hook1_with_http_info(self, web_hook_uid : StrictStr, body : Optional[CreateWebHookDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Edit webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_web_hook1_with_http_info(web_hook_uid, body, async_req=True)
        >>> result = thread.get()

        :param web_hook_uid: (required)
        :type web_hook_uid: str
        :param body:
        :type body: CreateWebHookDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebHookDtoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'web_hook_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_web_hook1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['web_hook_uid']:
            _path_params['webHookUid'] = _params['web_hook_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "WebHookDtoV2",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/webhooks/{webHookUid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
