# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, conint, conlist, constr, validator

from typing import Optional

from phrasetms_client.models.abstract_user_create_dto import AbstractUserCreateDto
from phrasetms_client.models.abstract_user_edit_dto import AbstractUserEditDto
from phrasetms_client.models.page_dto_assigned_job_dto import PageDtoAssignedJobDto
from phrasetms_client.models.page_dto_last_login_dto import PageDtoLastLoginDto
from phrasetms_client.models.page_dto_project_reference import PageDtoProjectReference
from phrasetms_client.models.page_dto_string import PageDtoString
from phrasetms_client.models.page_dto_user_dto import PageDtoUserDto
from phrasetms_client.models.page_dto_workflow_step_reference import PageDtoWorkflowStepReference
from phrasetms_client.models.user_details_dto_v3 import UserDetailsDtoV3
from phrasetms_client.models.user_dto import UserDto
from phrasetms_client.models.user_password_edit_dto import UserPasswordEditDto
from phrasetms_client.models.user_statistics_list_dto import UserStatisticsListDto

from phrasetms_client.api_client import ApiClient
from phrasetms_client.api_response import ApiResponse
from phrasetms_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class UserApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def cancel_deletion(self, user_uid : StrictStr, **kwargs) -> UserDto:  # noqa: E501
        """Restore user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_deletion(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the cancel_deletion_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.cancel_deletion_with_http_info(user_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def cancel_deletion_with_http_info(self, user_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Restore user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_deletion_with_http_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_deletion" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UserDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/undelete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_user_v3(self, body : Optional[AbstractUserCreateDto] = None, **kwargs) -> UserDetailsDtoV3:  # noqa: E501
        """Create user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_v3(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: AbstractUserCreateDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserDetailsDtoV3
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_user_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_user_v3_with_http_info(body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_user_v3_with_http_info(self, body : Optional[AbstractUserCreateDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_v3_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: AbstractUserCreateDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserDetailsDtoV3, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '201': "UserDetailsDtoV3",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/users', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_user1(self, user_uid : StrictStr, **kwargs) -> None:  # noqa: E501
        """Delete user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user1(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_user1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_user1_with_http_info(user_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_user1_with_http_info(self, user_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user1_with_http_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def disable_two_factor_auth_v3(self, user_uid : StrictStr, **kwargs) -> UserDetailsDtoV3:  # noqa: E501
        """Disable two-factor authentication  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_two_factor_auth_v3(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserDetailsDtoV3
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the disable_two_factor_auth_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.disable_two_factor_auth_v3_with_http_info(user_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def disable_two_factor_auth_v3_with_http_info(self, user_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Disable two-factor authentication  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_two_factor_auth_v3_with_http_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserDetailsDtoV3, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_two_factor_auth_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UserDetailsDtoV3",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/users/{userUid}/disableTwoFactorAuth', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_list_of_users_filtered(self, first_name : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for first name, that starts with value")] = None, last_name : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for last name, that starts with value")] = None, name : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for last name or first name, that starts with value")] = None, user_name : Optional[constr(strict=True, max_length=255, min_length=0)] = None, email : Optional[constr(strict=True, max_length=255, min_length=0)] = None, name_or_email : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for last name, first name or email starting with the value")] = None, role : Optional[conlist(StrictStr)] = None, include_deleted : Optional[StrictBool] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 50")] = None, sort : Optional[conlist(StrictStr)] = None, order : Optional[conlist(StrictStr)] = None, **kwargs) -> PageDtoUserDto:  # noqa: E501
        """List users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_list_of_users_filtered(first_name, last_name, name, user_name, email, name_or_email, role, include_deleted, page_number, page_size, sort, order, async_req=True)
        >>> result = thread.get()

        :param first_name: Filter for first name, that starts with value
        :type first_name: str
        :param last_name: Filter for last name, that starts with value
        :type last_name: str
        :param name: Filter for last name or first name, that starts with value
        :type name: str
        :param user_name:
        :type user_name: str
        :param email:
        :type email: str
        :param name_or_email: Filter for last name, first name or email starting with the value
        :type name_or_email: str
        :param role:
        :type role: List[str]
        :param include_deleted:
        :type include_deleted: bool
        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 50
        :type page_size: int
        :param sort:
        :type sort: List[str]
        :param order:
        :type order: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoUserDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_list_of_users_filtered_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_list_of_users_filtered_with_http_info(first_name, last_name, name, user_name, email, name_or_email, role, include_deleted, page_number, page_size, sort, order, **kwargs)  # noqa: E501

    @validate_arguments
    def get_list_of_users_filtered_with_http_info(self, first_name : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for first name, that starts with value")] = None, last_name : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for last name, that starts with value")] = None, name : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for last name or first name, that starts with value")] = None, user_name : Optional[constr(strict=True, max_length=255, min_length=0)] = None, email : Optional[constr(strict=True, max_length=255, min_length=0)] = None, name_or_email : Annotated[Optional[constr(strict=True, max_length=255, min_length=0)], Field(description="Filter for last name, first name or email starting with the value")] = None, role : Optional[conlist(StrictStr)] = None, include_deleted : Optional[StrictBool] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 50")] = None, sort : Optional[conlist(StrictStr)] = None, order : Optional[conlist(StrictStr)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List users  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_list_of_users_filtered_with_http_info(first_name, last_name, name, user_name, email, name_or_email, role, include_deleted, page_number, page_size, sort, order, async_req=True)
        >>> result = thread.get()

        :param first_name: Filter for first name, that starts with value
        :type first_name: str
        :param last_name: Filter for last name, that starts with value
        :type last_name: str
        :param name: Filter for last name or first name, that starts with value
        :type name: str
        :param user_name:
        :type user_name: str
        :param email:
        :type email: str
        :param name_or_email: Filter for last name, first name or email starting with the value
        :type name_or_email: str
        :param role:
        :type role: List[str]
        :param include_deleted:
        :type include_deleted: bool
        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 50
        :type page_size: int
        :param sort:
        :type sort: List[str]
        :param order:
        :type order: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoUserDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'first_name',
            'last_name',
            'name',
            'user_name',
            'email',
            'name_or_email',
            'role',
            'include_deleted',
            'page_number',
            'page_size',
            'sort',
            'order'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_list_of_users_filtered" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('first_name') is not None:  # noqa: E501
            _query_params.append(('firstName', _params['first_name']))

        if _params.get('last_name') is not None:  # noqa: E501
            _query_params.append(('lastName', _params['last_name']))

        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('user_name') is not None:  # noqa: E501
            _query_params.append(('userName', _params['user_name']))

        if _params.get('email') is not None:  # noqa: E501
            _query_params.append(('email', _params['email']))

        if _params.get('name_or_email') is not None:  # noqa: E501
            _query_params.append(('nameOrEmail', _params['name_or_email']))

        if _params.get('role') is not None:  # noqa: E501
            _query_params.append(('role', _params['role']))
            _collection_formats['role'] = 'multi'

        if _params.get('include_deleted') is not None:  # noqa: E501
            _query_params.append(('includeDeleted', _params['include_deleted']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        if _params.get('order') is not None:  # noqa: E501
            _query_params.append(('order', _params['order']))
            _collection_formats['order'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoUserDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_user_v3(self, user_uid : StrictStr, **kwargs) -> UserDetailsDtoV3:  # noqa: E501
        """Get user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_v3(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserDetailsDtoV3
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_user_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_user_v3_with_http_info(user_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def get_user_v3_with_http_info(self, user_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_v3_with_http_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserDetailsDtoV3, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UserDetailsDtoV3",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/users/{userUid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_assigned_projects(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, target_lang : Optional[conlist(StrictStr)] = None, workflow_step_id : Optional[StrictInt] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, project_name : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> PageDtoProjectReference:  # noqa: E501
        """List assigned projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_assigned_projects(user_uid, status, target_lang, workflow_step_id, due_in_hours, filename, project_name, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param target_lang:
        :type target_lang: List[str]
        :param workflow_step_id:
        :type workflow_step_id: int
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param project_name:
        :type project_name: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoProjectReference
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_assigned_projects_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_assigned_projects_with_http_info(user_uid, status, target_lang, workflow_step_id, due_in_hours, filename, project_name, page_number, page_size, **kwargs)  # noqa: E501

    @validate_arguments
    def list_assigned_projects_with_http_info(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, target_lang : Optional[conlist(StrictStr)] = None, workflow_step_id : Optional[StrictInt] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, project_name : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List assigned projects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_assigned_projects_with_http_info(user_uid, status, target_lang, workflow_step_id, due_in_hours, filename, project_name, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param target_lang:
        :type target_lang: List[str]
        :param workflow_step_id:
        :type workflow_step_id: int
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param project_name:
        :type project_name: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoProjectReference, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid',
            'status',
            'target_lang',
            'workflow_step_id',
            'due_in_hours',
            'filename',
            'project_name',
            'page_number',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assigned_projects" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
            _collection_formats['status'] = 'multi'

        if _params.get('target_lang') is not None:  # noqa: E501
            _query_params.append(('targetLang', _params['target_lang']))
            _collection_formats['targetLang'] = 'multi'

        if _params.get('workflow_step_id') is not None:  # noqa: E501
            _query_params.append(('workflowStepId', _params['workflow_step_id']))

        if _params.get('due_in_hours') is not None:  # noqa: E501
            _query_params.append(('dueInHours', _params['due_in_hours']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        if _params.get('project_name') is not None:  # noqa: E501
            _query_params.append(('projectName', _params['project_name']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoProjectReference",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/projects', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_jobs(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, project_uid : Optional[StrictStr] = None, target_lang : Optional[conlist(StrictStr)] = None, workflow_step_id : Optional[StrictInt] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> PageDtoAssignedJobDto:  # noqa: E501
        """List assigned jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_jobs(user_uid, status, project_uid, target_lang, workflow_step_id, due_in_hours, filename, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param project_uid:
        :type project_uid: str
        :param target_lang:
        :type target_lang: List[str]
        :param workflow_step_id:
        :type workflow_step_id: int
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoAssignedJobDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_jobs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_jobs_with_http_info(user_uid, status, project_uid, target_lang, workflow_step_id, due_in_hours, filename, page_number, page_size, **kwargs)  # noqa: E501

    @validate_arguments
    def list_jobs_with_http_info(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, project_uid : Optional[StrictStr] = None, target_lang : Optional[conlist(StrictStr)] = None, workflow_step_id : Optional[StrictInt] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List assigned jobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_jobs_with_http_info(user_uid, status, project_uid, target_lang, workflow_step_id, due_in_hours, filename, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param project_uid:
        :type project_uid: str
        :param target_lang:
        :type target_lang: List[str]
        :param workflow_step_id:
        :type workflow_step_id: int
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoAssignedJobDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid',
            'status',
            'project_uid',
            'target_lang',
            'workflow_step_id',
            'due_in_hours',
            'filename',
            'page_number',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_jobs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
            _collection_formats['status'] = 'multi'

        if _params.get('project_uid') is not None:  # noqa: E501
            _query_params.append(('projectUid', _params['project_uid']))

        if _params.get('target_lang') is not None:  # noqa: E501
            _query_params.append(('targetLang', _params['target_lang']))
            _collection_formats['targetLang'] = 'multi'

        if _params.get('workflow_step_id') is not None:  # noqa: E501
            _query_params.append(('workflowStepId', _params['workflow_step_id']))

        if _params.get('due_in_hours') is not None:  # noqa: E501
            _query_params.append(('dueInHours', _params['due_in_hours']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoAssignedJobDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/jobs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_target_langs(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, project_uid : Optional[StrictStr] = None, workflow_step_id : Optional[StrictInt] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> PageDtoString:  # noqa: E501
        """List assigned target languages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_target_langs(user_uid, status, project_uid, workflow_step_id, due_in_hours, filename, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param project_uid:
        :type project_uid: str
        :param workflow_step_id:
        :type workflow_step_id: int
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoString
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_target_langs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_target_langs_with_http_info(user_uid, status, project_uid, workflow_step_id, due_in_hours, filename, page_number, page_size, **kwargs)  # noqa: E501

    @validate_arguments
    def list_target_langs_with_http_info(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, project_uid : Optional[StrictStr] = None, workflow_step_id : Optional[StrictInt] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List assigned target languages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_target_langs_with_http_info(user_uid, status, project_uid, workflow_step_id, due_in_hours, filename, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param project_uid:
        :type project_uid: str
        :param workflow_step_id:
        :type workflow_step_id: int
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoString, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid',
            'status',
            'project_uid',
            'workflow_step_id',
            'due_in_hours',
            'filename',
            'page_number',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_target_langs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
            _collection_formats['status'] = 'multi'

        if _params.get('project_uid') is not None:  # noqa: E501
            _query_params.append(('projectUid', _params['project_uid']))

        if _params.get('workflow_step_id') is not None:  # noqa: E501
            _query_params.append(('workflowStepId', _params['workflow_step_id']))

        if _params.get('due_in_hours') is not None:  # noqa: E501
            _query_params.append(('dueInHours', _params['due_in_hours']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoString",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/targetLangs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_workflow_steps(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, project_uid : Optional[StrictStr] = None, target_lang : Optional[conlist(StrictStr)] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> PageDtoWorkflowStepReference:  # noqa: E501
        """List assigned workflow steps  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workflow_steps(user_uid, status, project_uid, target_lang, due_in_hours, filename, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param project_uid:
        :type project_uid: str
        :param target_lang:
        :type target_lang: List[str]
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoWorkflowStepReference
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the list_workflow_steps_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.list_workflow_steps_with_http_info(user_uid, status, project_uid, target_lang, due_in_hours, filename, page_number, page_size, **kwargs)  # noqa: E501

    @validate_arguments
    def list_workflow_steps_with_http_info(self, user_uid : StrictStr, status : Optional[conlist(StrictStr)] = None, project_uid : Optional[StrictStr] = None, target_lang : Optional[conlist(StrictStr)] = None, due_in_hours : Annotated[Optional[conint(strict=True, ge=-1)], Field(description="-1 for jobs that are overdue")] = None, filename : Optional[StrictStr] = None, page_number : Optional[conint(strict=True, ge=0)] = None, page_size : Optional[conint(strict=True, le=50, ge=1)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List assigned workflow steps  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_workflow_steps_with_http_info(user_uid, status, project_uid, target_lang, due_in_hours, filename, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param status:
        :type status: List[str]
        :param project_uid:
        :type project_uid: str
        :param target_lang:
        :type target_lang: List[str]
        :param due_in_hours: -1 for jobs that are overdue
        :type due_in_hours: int
        :param filename:
        :type filename: str
        :param page_number:
        :type page_number: int
        :param page_size:
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoWorkflowStepReference, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid',
            'status',
            'project_uid',
            'target_lang',
            'due_in_hours',
            'filename',
            'page_number',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflow_steps" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
            _collection_formats['status'] = 'multi'

        if _params.get('project_uid') is not None:  # noqa: E501
            _query_params.append(('projectUid', _params['project_uid']))

        if _params.get('target_lang') is not None:  # noqa: E501
            _query_params.append(('targetLang', _params['target_lang']))
            _collection_formats['targetLang'] = 'multi'

        if _params.get('due_in_hours') is not None:  # noqa: E501
            _query_params.append(('dueInHours', _params['due_in_hours']))

        if _params.get('filename') is not None:  # noqa: E501
            _query_params.append(('filename', _params['filename']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoWorkflowStepReference",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/workflowSteps', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def login_activity(self, user_uid : StrictStr, **kwargs) -> UserStatisticsListDto:  # noqa: E501
        """Login statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_activity(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserStatisticsListDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the login_activity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.login_activity_with_http_info(user_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def login_activity_with_http_info(self, user_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Login statistics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.login_activity_with_http_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserStatisticsListDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method login_activity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UserStatisticsListDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/loginStatistics', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def send_login_info(self, user_uid : StrictStr, **kwargs) -> None:  # noqa: E501
        """Send login information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_login_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the send_login_info_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.send_login_info_with_http_info(user_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def send_login_info_with_http_info(self, user_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Send login information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_login_info_with_http_info(user_uid, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_login_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/emailLoginInformation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_password(self, user_uid : StrictStr, body : Optional[UserPasswordEditDto] = None, **kwargs) -> None:  # noqa: E501
        """Update password  # noqa: E501

         * Password length must be between 8 and 255 * Password must not be same as the username   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_password(user_uid, body, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param body:
        :type body: UserPasswordEditDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_password_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_password_with_http_info(user_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_password_with_http_info(self, user_uid : StrictStr, body : Optional[UserPasswordEditDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update password  # noqa: E501

         * Password length must be between 8 and 255 * Password must not be same as the username   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_password_with_http_info(user_uid, body, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param body:
        :type body: UserPasswordEditDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_password" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/users/{userUid}/updatePassword', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_user_v3(self, user_uid : StrictStr, body : Optional[AbstractUserEditDto] = None, **kwargs) -> UserDetailsDtoV3:  # noqa: E501
        """Edit user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_v3(user_uid, body, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param body:
        :type body: AbstractUserEditDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserDetailsDtoV3
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_user_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_user_v3_with_http_info(user_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_user_v3_with_http_info(self, user_uid : StrictStr, body : Optional[AbstractUserEditDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Edit user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_v3_with_http_info(user_uid, body, async_req=True)
        >>> result = thread.get()

        :param user_uid: (required)
        :type user_uid: str
        :param body:
        :type body: AbstractUserEditDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UserDetailsDtoV3, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_uid']:
            _path_params['userUid'] = _params['user_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UserDetailsDtoV3",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/users/{userUid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def user_last_logins(self, user_name : Optional[constr(strict=True, max_length=255, min_length=0)] = None, role : Optional[conlist(StrictStr)] = None, sort : Optional[conlist(StrictStr)] = None, order : Optional[conlist(StrictStr)] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Page size, accepts values between 1 and 100, default 100")] = None, **kwargs) -> PageDtoLastLoginDto:  # noqa: E501
        """List last login dates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_last_logins(user_name, role, sort, order, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_name:
        :type user_name: str
        :param role:
        :type role: List[str]
        :param sort:
        :type sort: List[str]
        :param order:
        :type order: List[str]
        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 100, default 100
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoLastLoginDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the user_last_logins_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.user_last_logins_with_http_info(user_name, role, sort, order, page_number, page_size, **kwargs)  # noqa: E501

    @validate_arguments
    def user_last_logins_with_http_info(self, user_name : Optional[constr(strict=True, max_length=255, min_length=0)] = None, role : Optional[conlist(StrictStr)] = None, sort : Optional[conlist(StrictStr)] = None, order : Optional[conlist(StrictStr)] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Page size, accepts values between 1 and 100, default 100")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List last login dates  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.user_last_logins_with_http_info(user_name, role, sort, order, page_number, page_size, async_req=True)
        >>> result = thread.get()

        :param user_name:
        :type user_name: str
        :param role:
        :type role: List[str]
        :param sort:
        :type sort: List[str]
        :param order:
        :type order: List[str]
        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 100, default 100
        :type page_size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoLastLoginDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_name',
            'role',
            'sort',
            'order',
            'page_number',
            'page_size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_last_logins" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('user_name') is not None:  # noqa: E501
            _query_params.append(('userName', _params['user_name']))

        if _params.get('role') is not None:  # noqa: E501
            _query_params.append(('role', _params['role']))
            _collection_formats['role'] = 'multi'

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        if _params.get('order') is not None:  # noqa: E501
            _query_params.append(('order', _params['order']))
            _collection_formats['order'] = 'multi'

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoLastLoginDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/users/lastLogins', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
