# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import StrictStr

from typing import Optional

from phrasetms_client.models.async_request_wrapper_dto import AsyncRequestWrapperDto
from phrasetms_client.models.async_request_wrapper_v2_dto import AsyncRequestWrapperV2Dto
from phrasetms_client.models.human_translate_jobs_dto import HumanTranslateJobsDto
from phrasetms_client.models.machine_translate_response import MachineTranslateResponse
from phrasetms_client.models.pre_translate_jobs_v2_dto import PreTranslateJobsV2Dto
from phrasetms_client.models.translation_request_dto import TranslationRequestDto

from phrasetms_client.api_client import ApiClient
from phrasetms_client.api_response import ApiResponse
from phrasetms_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TranslationApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def human_translate(self, project_uid : StrictStr, body : Optional[HumanTranslateJobsDto] = None, **kwargs) -> AsyncRequestWrapperDto:  # noqa: E501
        """Human translate (Gengo or Unbabel)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.human_translate(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: HumanTranslateJobsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AsyncRequestWrapperDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the human_translate_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.human_translate_with_http_info(project_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def human_translate_with_http_info(self, project_uid : StrictStr, body : Optional[HumanTranslateJobsDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Human translate (Gengo or Unbabel)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.human_translate_with_http_info(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: HumanTranslateJobsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AsyncRequestWrapperDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method human_translate" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "AsyncRequestWrapperDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/humanTranslate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def machine_translation_job(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[TranslationRequestDto] = None, **kwargs) -> MachineTranslateResponse:  # noqa: E501
        """Translate using machine translation  # noqa: E501

        Configured machine translate settings is used  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.machine_translation_job(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: TranslationRequestDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MachineTranslateResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the machine_translation_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.machine_translation_job_with_http_info(project_uid, job_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def machine_translation_job_with_http_info(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[TranslationRequestDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Translate using machine translation  # noqa: E501

        Configured machine translate settings is used  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.machine_translation_job_with_http_info(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: TranslationRequestDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MachineTranslateResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'job_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method machine_translation_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']

        if _params['job_uid']:
            _path_params['jobUid'] = _params['job_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "MachineTranslateResponse",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/translations/translateWithMachineTranslation', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def pre_translate1(self, project_uid : StrictStr, body : Optional[PreTranslateJobsV2Dto] = None, **kwargs) -> AsyncRequestWrapperV2Dto:  # noqa: E501
        """Pre-translate job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pre_translate1(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: PreTranslateJobsV2Dto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AsyncRequestWrapperV2Dto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the pre_translate1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.pre_translate1_with_http_info(project_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def pre_translate1_with_http_info(self, project_uid : StrictStr, body : Optional[PreTranslateJobsV2Dto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Pre-translate job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.pre_translate1_with_http_info(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: PreTranslateJobsV2Dto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AsyncRequestWrapperV2Dto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pre_translate1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '202': "AsyncRequestWrapperV2Dto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/preTranslate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
