# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint, conlist, validator

from typing import List, Optional

from phrasetms_client.models.create_lqa_profile_dto import CreateLqaProfileDto
from phrasetms_client.models.lqa_profile_detail_dto import LqaProfileDetailDto
from phrasetms_client.models.lqa_profile_reference_dto import LqaProfileReferenceDto
from phrasetms_client.models.page_dto_lqa_profile_reference_dto import PageDtoLqaProfileReferenceDto
from phrasetms_client.models.quality_assurance_batch_run_dto_v3 import QualityAssuranceBatchRunDtoV3
from phrasetms_client.models.quality_assurance_checks_dto_v2 import QualityAssuranceChecksDtoV2
from phrasetms_client.models.quality_assurance_response_dto import QualityAssuranceResponseDto
from phrasetms_client.models.quality_assurance_run_dto_v3 import QualityAssuranceRunDtoV3
from phrasetms_client.models.quality_assurance_segments_run_dto_v3 import QualityAssuranceSegmentsRunDtoV3
from phrasetms_client.models.update_ignored_checks_dto import UpdateIgnoredChecksDto
from phrasetms_client.models.update_ignored_warnings_dto import UpdateIgnoredWarningsDto
from phrasetms_client.models.update_lqa_profile_dto import UpdateLqaProfileDto
from phrasetms_client.models.user_reference import UserReference

from phrasetms_client.api_client import ApiClient
from phrasetms_client.api_response import ApiResponse
from phrasetms_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class QualityAssuranceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def add_ignored_warnings(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> UpdateIgnoredWarningsDto:  # noqa: E501
        """Add ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ignored_warnings(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpdateIgnoredWarningsDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the add_ignored_warnings_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.add_ignored_warnings_with_http_info(project_uid, job_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def add_ignored_warnings_with_http_info(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Add ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ignored_warnings_with_http_info(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpdateIgnoredWarningsDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'job_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ignored_warnings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']

        if _params['job_uid']:
            _path_params['jobUid'] = _params['job_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UpdateIgnoredWarningsDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/qualityAssurances/ignoredWarnings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_ignored_warnings1(self, project_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> UpdateIgnoredWarningsDto:  # noqa: E501
        """Add ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ignored_warnings1(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpdateIgnoredWarningsDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the add_ignored_warnings1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.add_ignored_warnings1_with_http_info(project_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def add_ignored_warnings1_with_http_info(self, project_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Add ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_ignored_warnings1_with_http_info(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpdateIgnoredWarningsDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ignored_warnings1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UpdateIgnoredWarningsDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/qualityAssurances/ignoredWarnings', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_lqa_profile(self, body : Optional[CreateLqaProfileDto] = None, **kwargs) -> LqaProfileDetailDto:  # noqa: E501
        """Create LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lqa_profile(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: CreateLqaProfileDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LqaProfileDetailDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_lqa_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_lqa_profile_with_http_info(body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_lqa_profile_with_http_info(self, body : Optional[CreateLqaProfileDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_lqa_profile_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param body:
        :type body: CreateLqaProfileDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LqaProfileDetailDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_lqa_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '201': "LqaProfileDetailDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_ignored_warnings(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> None:  # noqa: E501
        """Delete ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ignored_warnings(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_ignored_warnings_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_ignored_warnings_with_http_info(project_uid, job_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_ignored_warnings_with_http_info(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ignored_warnings_with_http_info(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'job_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ignored_warnings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']

        if _params['job_uid']:
            _path_params['jobUid'] = _params['job_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/qualityAssurances/ignoredWarnings', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_ignored_warnings1(self, project_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> None:  # noqa: E501
        """Delete ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ignored_warnings1(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_ignored_warnings1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_ignored_warnings1_with_http_info(project_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_ignored_warnings1_with_http_info(self, project_uid : StrictStr, body : Optional[UpdateIgnoredWarningsDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete ignored warnings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_ignored_warnings1_with_http_info(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: UpdateIgnoredWarningsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ignored_warnings1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/qualityAssurances/ignoredWarnings', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_lqa_profile(self, profile_uid : StrictStr, **kwargs) -> None:  # noqa: E501
        """Delete LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lqa_profile(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_lqa_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_lqa_profile_with_http_info(profile_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_lqa_profile_with_http_info(self, profile_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_lqa_profile_with_http_info(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'profile_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lqa_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['profile_uid']:
            _path_params['profileUid'] = _params['profile_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles/{profileUid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def duplicate_profile(self, profile_uid : StrictStr, **kwargs) -> LqaProfileReferenceDto:  # noqa: E501
        """Duplicate LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_profile(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LqaProfileReferenceDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the duplicate_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.duplicate_profile_with_http_info(profile_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def duplicate_profile_with_http_info(self, profile_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Duplicate LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.duplicate_profile_with_http_info(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LqaProfileReferenceDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'profile_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method duplicate_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['profile_uid']:
            _path_params['profileUid'] = _params['profile_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "LqaProfileReferenceDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles/{profileUid}/duplicate', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def enabled_quality_checks_for_job(self, project_uid : StrictStr, job_uid : StrictStr, **kwargs) -> QualityAssuranceChecksDtoV2:  # noqa: E501
        """Get QA settings for job  # noqa: E501

        Returns enabled quality assurance checks and settings for job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enabled_quality_checks_for_job(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QualityAssuranceChecksDtoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the enabled_quality_checks_for_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.enabled_quality_checks_for_job_with_http_info(project_uid, job_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def enabled_quality_checks_for_job_with_http_info(self, project_uid : StrictStr, job_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get QA settings for job  # noqa: E501

        Returns enabled quality assurance checks and settings for job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enabled_quality_checks_for_job_with_http_info(project_uid, job_uid, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QualityAssuranceChecksDtoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'job_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enabled_quality_checks_for_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']

        if _params['job_uid']:
            _path_params['jobUid'] = _params['job_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "QualityAssuranceChecksDtoV2",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/{jobUid}/qualityAssurances/settings', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def enabled_quality_checks_for_job1(self, project_uid : StrictStr, **kwargs) -> QualityAssuranceChecksDtoV2:  # noqa: E501
        """Get QA settings  # noqa: E501

        Returns enabled quality assurance checks and settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enabled_quality_checks_for_job1(project_uid, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QualityAssuranceChecksDtoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the enabled_quality_checks_for_job1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.enabled_quality_checks_for_job1_with_http_info(project_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def enabled_quality_checks_for_job1_with_http_info(self, project_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get QA settings  # noqa: E501

        Returns enabled quality assurance checks and settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enabled_quality_checks_for_job1_with_http_info(project_uid, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QualityAssuranceChecksDtoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enabled_quality_checks_for_job1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "QualityAssuranceChecksDtoV2",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/projects/{projectUid}/jobs/qualityAssurances/settings', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_lqa_profile(self, profile_uid : StrictStr, **kwargs) -> LqaProfileDetailDto:  # noqa: E501
        """Get LQA profile details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lqa_profile(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LqaProfileDetailDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_lqa_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_lqa_profile_with_http_info(profile_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def get_lqa_profile_with_http_info(self, profile_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get LQA profile details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lqa_profile_with_http_info(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LqaProfileDetailDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'profile_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lqa_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['profile_uid']:
            _path_params['profileUid'] = _params['profile_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "LqaProfileDetailDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles/{profileUid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_lqa_profile_authors(self, **kwargs) -> List[UserReference]:  # noqa: E501
        """Get list of LQA profile authors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lqa_profile_authors(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[UserReference]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_lqa_profile_authors_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_lqa_profile_authors_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def get_lqa_profile_authors_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Get list of LQA profile authors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lqa_profile_authors_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[UserReference], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lqa_profile_authors" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "List[UserReference]",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles/authors', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_lqa_profiles(self, name : Annotated[Optional[StrictStr], Field(description="Name of LQA profiles, it is used for filter the list by name")] = None, created_by : Annotated[Optional[StrictStr], Field(description="It is used for filter the list by who created the profile")] = None, date_created : Annotated[Optional[StrictStr], Field(description="It is used for filter the list by date created")] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 20")] = None, sort : Optional[conlist(StrictStr)] = None, order : Optional[conlist(StrictStr)] = None, **kwargs) -> PageDtoLqaProfileReferenceDto:  # noqa: E501
        """GET list LQA profiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lqa_profiles(name, created_by, date_created, page_number, page_size, sort, order, async_req=True)
        >>> result = thread.get()

        :param name: Name of LQA profiles, it is used for filter the list by name
        :type name: str
        :param created_by: It is used for filter the list by who created the profile
        :type created_by: str
        :param date_created: It is used for filter the list by date created
        :type date_created: str
        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 20
        :type page_size: int
        :param sort:
        :type sort: List[str]
        :param order:
        :type order: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PageDtoLqaProfileReferenceDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_lqa_profiles_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_lqa_profiles_with_http_info(name, created_by, date_created, page_number, page_size, sort, order, **kwargs)  # noqa: E501

    @validate_arguments
    def get_lqa_profiles_with_http_info(self, name : Annotated[Optional[StrictStr], Field(description="Name of LQA profiles, it is used for filter the list by name")] = None, created_by : Annotated[Optional[StrictStr], Field(description="It is used for filter the list by who created the profile")] = None, date_created : Annotated[Optional[StrictStr], Field(description="It is used for filter the list by date created")] = None, page_number : Annotated[Optional[conint(strict=True, ge=0)], Field(description="Page number, starting with 0, default 0")] = None, page_size : Annotated[Optional[conint(strict=True, le=50, ge=1)], Field(description="Page size, accepts values between 1 and 50, default 20")] = None, sort : Optional[conlist(StrictStr)] = None, order : Optional[conlist(StrictStr)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """GET list LQA profiles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_lqa_profiles_with_http_info(name, created_by, date_created, page_number, page_size, sort, order, async_req=True)
        >>> result = thread.get()

        :param name: Name of LQA profiles, it is used for filter the list by name
        :type name: str
        :param created_by: It is used for filter the list by who created the profile
        :type created_by: str
        :param date_created: It is used for filter the list by date created
        :type date_created: str
        :param page_number: Page number, starting with 0, default 0
        :type page_number: int
        :param page_size: Page size, accepts values between 1 and 50, default 20
        :type page_size: int
        :param sort:
        :type sort: List[str]
        :param order:
        :type order: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PageDtoLqaProfileReferenceDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'name',
            'created_by',
            'date_created',
            'page_number',
            'page_size',
            'sort',
            'order'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lqa_profiles" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))

        if _params.get('created_by') is not None:  # noqa: E501
            _query_params.append(('createdBy', _params['created_by']))

        if _params.get('date_created') is not None:  # noqa: E501
            _query_params.append(('dateCreated', _params['date_created']))

        if _params.get('page_number') is not None:  # noqa: E501
            _query_params.append(('pageNumber', _params['page_number']))

        if _params.get('page_size') is not None:  # noqa: E501
            _query_params.append(('pageSize', _params['page_size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        if _params.get('order') is not None:  # noqa: E501
            _query_params.append(('order', _params['order']))
            _collection_formats['order'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PageDtoLqaProfileReferenceDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def make_default(self, profile_uid : StrictStr, **kwargs) -> LqaProfileReferenceDto:  # noqa: E501
        """Make LQA profile default  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.make_default(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LqaProfileReferenceDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the make_default_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.make_default_with_http_info(profile_uid, **kwargs)  # noqa: E501

    @validate_arguments
    def make_default_with_http_info(self, profile_uid : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Make LQA profile default  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.make_default_with_http_info(profile_uid, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LqaProfileReferenceDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'profile_uid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method make_default" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['profile_uid']:
            _path_params['profileUid'] = _params['profile_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "LqaProfileReferenceDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles/{profileUid}/default', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_qa_for_job_part_v3(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[QualityAssuranceRunDtoV3] = None, **kwargs) -> QualityAssuranceResponseDto:  # noqa: E501
        """Run quality assurance  # noqa: E501

        Call \"Get QA settings\" endpoint to get the list of enabled QA checks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_qa_for_job_part_v3(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: QualityAssuranceRunDtoV3
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QualityAssuranceResponseDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the run_qa_for_job_part_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.run_qa_for_job_part_v3_with_http_info(project_uid, job_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def run_qa_for_job_part_v3_with_http_info(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[QualityAssuranceRunDtoV3] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Run quality assurance  # noqa: E501

        Call \"Get QA settings\" endpoint to get the list of enabled QA checks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_qa_for_job_part_v3_with_http_info(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: QualityAssuranceRunDtoV3
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QualityAssuranceResponseDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'job_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_qa_for_job_part_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']

        if _params['job_uid']:
            _path_params['jobUid'] = _params['job_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "QualityAssuranceResponseDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/projects/{projectUid}/jobs/{jobUid}/qualityAssurances/run', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_qa_for_job_parts_v3(self, project_uid : StrictStr, body : Optional[QualityAssuranceBatchRunDtoV3] = None, **kwargs) -> QualityAssuranceResponseDto:  # noqa: E501
        """Run quality assurance (batch)  # noqa: E501

        Call \"Get QA settings\" endpoint to get the list of enabled QA checks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_qa_for_job_parts_v3(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: QualityAssuranceBatchRunDtoV3
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QualityAssuranceResponseDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the run_qa_for_job_parts_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.run_qa_for_job_parts_v3_with_http_info(project_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def run_qa_for_job_parts_v3_with_http_info(self, project_uid : StrictStr, body : Optional[QualityAssuranceBatchRunDtoV3] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Run quality assurance (batch)  # noqa: E501

        Call \"Get QA settings\" endpoint to get the list of enabled QA checks  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_qa_for_job_parts_v3_with_http_info(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: QualityAssuranceBatchRunDtoV3
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QualityAssuranceResponseDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_qa_for_job_parts_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "QualityAssuranceResponseDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/projects/{projectUid}/jobs/qualityAssurances/run', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_qa_for_segments_v3(self, project_uid : StrictStr, body : Optional[QualityAssuranceSegmentsRunDtoV3] = None, **kwargs) -> QualityAssuranceResponseDto:  # noqa: E501
        """Run quality assurance on selected segments  # noqa: E501

        By default runs only fast running checks. Source and target language of jobs have to match.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_qa_for_segments_v3(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: QualityAssuranceSegmentsRunDtoV3
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QualityAssuranceResponseDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the run_qa_for_segments_v3_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.run_qa_for_segments_v3_with_http_info(project_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def run_qa_for_segments_v3_with_http_info(self, project_uid : StrictStr, body : Optional[QualityAssuranceSegmentsRunDtoV3] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Run quality assurance on selected segments  # noqa: E501

        By default runs only fast running checks. Source and target language of jobs have to match.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_qa_for_segments_v3_with_http_info(project_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param body:
        :type body: QualityAssuranceSegmentsRunDtoV3
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QualityAssuranceResponseDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_qa_for_segments_v3" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "QualityAssuranceResponseDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v3/projects/{projectUid}/jobs/qualityAssurances/segments/run', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_ignored_checks(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[UpdateIgnoredChecksDto] = None, **kwargs) -> None:  # noqa: E501
        """Edit ignored checks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ignored_checks(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: UpdateIgnoredChecksDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_ignored_checks_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_ignored_checks_with_http_info(project_uid, job_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_ignored_checks_with_http_info(self, project_uid : StrictStr, job_uid : StrictStr, body : Optional[UpdateIgnoredChecksDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Edit ignored checks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_ignored_checks_with_http_info(project_uid, job_uid, body, async_req=True)
        >>> result = thread.get()

        :param project_uid: (required)
        :type project_uid: str
        :param job_uid: (required)
        :type job_uid: str
        :param body:
        :type body: UpdateIgnoredChecksDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'project_uid',
            'job_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ignored_checks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_uid']:
            _path_params['projectUid'] = _params['project_uid']

        if _params['job_uid']:
            _path_params['jobUid'] = _params['job_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api2/v1/projects/{projectUid}/jobs/{jobUid}/qualityAssurances/ignoreChecks', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_lqa_profile(self, profile_uid : StrictStr, body : Optional[UpdateLqaProfileDto] = None, **kwargs) -> LqaProfileDetailDto:  # noqa: E501
        """Update LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_lqa_profile(profile_uid, body, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param body:
        :type body: UpdateLqaProfileDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LqaProfileDetailDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_lqa_profile_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_lqa_profile_with_http_info(profile_uid, body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_lqa_profile_with_http_info(self, profile_uid : StrictStr, body : Optional[UpdateLqaProfileDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update LQA profile  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_lqa_profile_with_http_info(profile_uid, body, async_req=True)
        >>> result = thread.get()

        :param profile_uid: (required)
        :type profile_uid: str
        :param body:
        :type body: UpdateLqaProfileDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LqaProfileDetailDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'profile_uid',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lqa_profile" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['profile_uid']:
            _path_params['profileUid'] = _params['profile_uid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "LqaProfileDetailDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/lqa/profiles/{profileUid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
