# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictBytes, StrictStr, constr, validator

from typing import Optional, Union

from phrasetms_client.models.abstract_connector_dto import AbstractConnectorDto
from phrasetms_client.models.async_file_op_response_dto import AsyncFileOpResponseDto
from phrasetms_client.models.connector_create_response_dto import ConnectorCreateResponseDto
from phrasetms_client.models.connector_dto import ConnectorDto
from phrasetms_client.models.connector_list_dto import ConnectorListDto
from phrasetms_client.models.file_list_dto import FileListDto
from phrasetms_client.models.get_file_request_params_dto import GetFileRequestParamsDto
from phrasetms_client.models.input_stream_length import InputStreamLength
from phrasetms_client.models.upload_result_dto import UploadResultDto

from phrasetms_client.api_client import ApiClient
from phrasetms_client.api_response import ApiResponse
from phrasetms_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ConnectorApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def edit_connector(self, connector_id : StrictStr, connection_test : Annotated[Optional[StrictBool], Field(description="For running connection test")] = None, body : Optional[AbstractConnectorDto] = None, **kwargs) -> ConnectorCreateResponseDto:  # noqa: E501
        """Edit connector  # noqa: E501

        Edit selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_connector(connector_id, connection_test, body, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param connection_test: For running connection test
        :type connection_test: bool
        :param body:
        :type body: AbstractConnectorDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorCreateResponseDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the edit_connector_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.edit_connector_with_http_info(connector_id, connection_test, body, **kwargs)  # noqa: E501

    @validate_arguments
    def edit_connector_with_http_info(self, connector_id : StrictStr, connection_test : Annotated[Optional[StrictBool], Field(description="For running connection test")] = None, body : Optional[AbstractConnectorDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Edit connector  # noqa: E501

        Edit selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.edit_connector_with_http_info(connector_id, connection_test, body, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param connection_test: For running connection test
        :type connection_test: bool
        :param body:
        :type body: AbstractConnectorDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ConnectorCreateResponseDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'connection_test',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_connector" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']


        # process the query parameters
        _query_params = []
        if _params.get('connection_test') is not None:  # noqa: E501
            _query_params.append(('connectionTest', _params['connection_test']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "ConnectorCreateResponseDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_connector(self, connector_id : StrictStr, **kwargs) -> ConnectorDto:  # noqa: E501
        """Get a connector  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_connector(connector_id, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_connector_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_connector_with_http_info(connector_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_connector_with_http_info(self, connector_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get a connector  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_connector_with_http_info(connector_id, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ConnectorDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "ConnectorDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_connector_list(self, type : Optional[StrictStr] = None, **kwargs) -> ConnectorListDto:  # noqa: E501
        """List connectors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_connector_list(type, async_req=True)
        >>> result = thread.get()

        :param type:
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConnectorListDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_connector_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_connector_list_with_http_info(type, **kwargs)  # noqa: E501

    @validate_arguments
    def get_connector_list_with_http_info(self, type : Optional[StrictStr] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List connectors  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_connector_list_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param type:
        :type type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ConnectorListDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector_list" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('type') is not None:  # noqa: E501
            _query_params.append(('type', _params['type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "ConnectorListDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_file(self, connector_id : StrictStr, folder : StrictStr, file : StrictStr, **kwargs) -> InputStreamLength:  # noqa: E501
        """Download file  # noqa: E501

        Download a file from a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file(connector_id, folder, file, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file: (required)
        :type file: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InputStreamLength
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_file_with_http_info(connector_id, folder, file, **kwargs)  # noqa: E501

    @validate_arguments
    def get_file_with_http_info(self, connector_id : StrictStr, folder : StrictStr, file : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Download file  # noqa: E501

        Download a file from a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file_with_http_info(connector_id, folder, file, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file: (required)
        :type file: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InputStreamLength, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'folder',
            'file'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']

        if _params['folder']:
            _path_params['folder'] = _params['folder']

        if _params['file']:
            _path_params['file'] = _params['file']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "InputStreamLength",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders/{folder}/files/{file}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_file1(self, connector_id : StrictStr, folder : StrictStr, file : StrictStr, body : Optional[GetFileRequestParamsDto] = None, **kwargs) -> AsyncFileOpResponseDto:  # noqa: E501
        """Download file (async)  # noqa: E501

         Create an asynchronous request to download a file from a (sub)folder of the selected connector.  After a callback with successful response is received, prepared file can be downloaded by [Download prepared file](#operation/getPreparedFile)  or [Create job from connector asynchronous download task](#operation/createJobFromAsyncDownloadTask).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file1(connector_id, folder, file, body, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file: (required)
        :type file: str
        :param body:
        :type body: GetFileRequestParamsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AsyncFileOpResponseDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_file1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_file1_with_http_info(connector_id, folder, file, body, **kwargs)  # noqa: E501

    @validate_arguments
    def get_file1_with_http_info(self, connector_id : StrictStr, folder : StrictStr, file : StrictStr, body : Optional[GetFileRequestParamsDto] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Download file (async)  # noqa: E501

         Create an asynchronous request to download a file from a (sub)folder of the selected connector.  After a callback with successful response is received, prepared file can be downloaded by [Download prepared file](#operation/getPreparedFile)  or [Create job from connector asynchronous download task](#operation/createJobFromAsyncDownloadTask).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_file1_with_http_info(connector_id, folder, file, body, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file: (required)
        :type file: str
        :param body:
        :type body: GetFileRequestParamsDto
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AsyncFileOpResponseDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'folder',
            'file',
            'body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']

        if _params['folder']:
            _path_params['folder'] = _params['folder']

        if _params['file']:
            _path_params['file'] = _params['file']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['body'] is not None:
            _body_params = _params['body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "AsyncFileOpResponseDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/connectors/{connectorId}/folders/{folder}/files/{file}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_folder(self, connector_id : StrictStr, folder : StrictStr, project_uid : Optional[StrictStr] = None, file_type : Optional[constr(strict=True)] = None, sort : Optional[constr(strict=True)] = None, direction : Optional[constr(strict=True)] = None, **kwargs) -> FileListDto:  # noqa: E501
        """List files in a subfolder  # noqa: E501

        List files in a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_folder(connector_id, folder, project_uid, file_type, sort, direction, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param project_uid:
        :type project_uid: str
        :param file_type:
        :type file_type: str
        :param sort:
        :type sort: str
        :param direction:
        :type direction: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileListDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_folder_with_http_info(connector_id, folder, project_uid, file_type, sort, direction, **kwargs)  # noqa: E501

    @validate_arguments
    def get_folder_with_http_info(self, connector_id : StrictStr, folder : StrictStr, project_uid : Optional[StrictStr] = None, file_type : Optional[constr(strict=True)] = None, sort : Optional[constr(strict=True)] = None, direction : Optional[constr(strict=True)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List files in a subfolder  # noqa: E501

        List files in a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_folder_with_http_info(connector_id, folder, project_uid, file_type, sort, direction, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param project_uid:
        :type project_uid: str
        :param file_type:
        :type file_type: str
        :param sort:
        :type sort: str
        :param direction:
        :type direction: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileListDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'folder',
            'project_uid',
            'file_type',
            'sort',
            'direction'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']

        if _params['folder']:
            _path_params['folder'] = _params['folder']


        # process the query parameters
        _query_params = []
        if _params.get('project_uid') is not None:  # noqa: E501
            _query_params.append(('projectUid', _params['project_uid']))

        if _params.get('file_type') is not None:  # noqa: E501
            _query_params.append(('fileType', _params['file_type']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))

        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "FileListDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders/{folder}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_prepared_file(self, connector_id : StrictStr, folder : StrictStr, file : StrictStr, task_id : StrictStr, **kwargs) -> InputStreamLength:  # noqa: E501
        """Download prepared file  # noqa: E501

        Download the file by referencing successfully finished async download request [Connector - Download file (async)](#operation/getFile_1).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_prepared_file(connector_id, folder, file, task_id, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file: (required)
        :type file: str
        :param task_id: (required)
        :type task_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InputStreamLength
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_prepared_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_prepared_file_with_http_info(connector_id, folder, file, task_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_prepared_file_with_http_info(self, connector_id : StrictStr, folder : StrictStr, file : StrictStr, task_id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Download prepared file  # noqa: E501

        Download the file by referencing successfully finished async download request [Connector - Download file (async)](#operation/getFile_1).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_prepared_file_with_http_info(connector_id, folder, file, task_id, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file: (required)
        :type file: str
        :param task_id: (required)
        :type task_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InputStreamLength, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'folder',
            'file',
            'task_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_prepared_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']

        if _params['folder']:
            _path_params['folder'] = _params['folder']

        if _params['file']:
            _path_params['file'] = _params['file']

        if _params['task_id']:
            _path_params['taskId'] = _params['task_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "InputStreamLength",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/connectors/{connectorId}/folders/{folder}/files/{file}/tasks/{taskId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_root_folder(self, connector_id : StrictStr, file_type : Optional[constr(strict=True)] = None, sort : Optional[constr(strict=True)] = None, direction : Optional[constr(strict=True)] = None, **kwargs) -> FileListDto:  # noqa: E501
        """List files in root  # noqa: E501

        List files in a root folder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_root_folder(connector_id, file_type, sort, direction, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param file_type:
        :type file_type: str
        :param sort:
        :type sort: str
        :param direction:
        :type direction: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FileListDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_root_folder_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_root_folder_with_http_info(connector_id, file_type, sort, direction, **kwargs)  # noqa: E501

    @validate_arguments
    def get_root_folder_with_http_info(self, connector_id : StrictStr, file_type : Optional[constr(strict=True)] = None, sort : Optional[constr(strict=True)] = None, direction : Optional[constr(strict=True)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List files in root  # noqa: E501

        List files in a root folder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_root_folder_with_http_info(connector_id, file_type, sort, direction, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param file_type:
        :type file_type: str
        :param sort:
        :type sort: str
        :param direction:
        :type direction: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FileListDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'file_type',
            'sort',
            'direction'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_root_folder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']


        # process the query parameters
        _query_params = []
        if _params.get('file_type') is not None:  # noqa: E501
            _query_params.append(('fileType', _params['file_type']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))

        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "FileListDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def upload_file(self, connector_id : StrictStr, folder : StrictStr, content_type : StrictStr, file : Annotated[Union[StrictBytes, StrictStr], Field(..., description="Translated file to upload")], source_file_name : Annotated[Optional[StrictStr], Field(description="Name or ID of the original file")] = None, subfolder_name : Annotated[Optional[StrictStr], Field(description="Optional subfolder to upload the file to")] = None, mime_type : Annotated[Optional[StrictStr], Field(description="Mime type of the file to upload")] = None, commit_message : Annotated[Optional[StrictStr], Field(description="Commit message for upload to Git, etc.")] = None, **kwargs) -> UploadResultDto:  # noqa: E501
        """Upload a file to a subfolder of the selected connector  # noqa: E501

        Upload a file to a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_file(connector_id, folder, content_type, file, source_file_name, subfolder_name, mime_type, commit_message, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param content_type: (required)
        :type content_type: str
        :param file: Translated file to upload (required)
        :type file: bytearray
        :param source_file_name: Name or ID of the original file
        :type source_file_name: str
        :param subfolder_name: Optional subfolder to upload the file to
        :type subfolder_name: str
        :param mime_type: Mime type of the file to upload
        :type mime_type: str
        :param commit_message: Commit message for upload to Git, etc.
        :type commit_message: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UploadResultDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the upload_file_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.upload_file_with_http_info(connector_id, folder, content_type, file, source_file_name, subfolder_name, mime_type, commit_message, **kwargs)  # noqa: E501

    @validate_arguments
    def upload_file_with_http_info(self, connector_id : StrictStr, folder : StrictStr, content_type : StrictStr, file : Annotated[Union[StrictBytes, StrictStr], Field(..., description="Translated file to upload")], source_file_name : Annotated[Optional[StrictStr], Field(description="Name or ID of the original file")] = None, subfolder_name : Annotated[Optional[StrictStr], Field(description="Optional subfolder to upload the file to")] = None, mime_type : Annotated[Optional[StrictStr], Field(description="Mime type of the file to upload")] = None, commit_message : Annotated[Optional[StrictStr], Field(description="Commit message for upload to Git, etc.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Upload a file to a subfolder of the selected connector  # noqa: E501

        Upload a file to a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_file_with_http_info(connector_id, folder, content_type, file, source_file_name, subfolder_name, mime_type, commit_message, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param content_type: (required)
        :type content_type: str
        :param file: Translated file to upload (required)
        :type file: bytearray
        :param source_file_name: Name or ID of the original file
        :type source_file_name: str
        :param subfolder_name: Optional subfolder to upload the file to
        :type subfolder_name: str
        :param mime_type: Mime type of the file to upload
        :type mime_type: str
        :param commit_message: Commit message for upload to Git, etc.
        :type commit_message: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UploadResultDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'folder',
            'content_type',
            'file',
            'source_file_name',
            'subfolder_name',
            'mime_type',
            'commit_message'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']

        if _params['folder']:
            _path_params['folder'] = _params['folder']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['content_type']:
            _header_params['Content-Type'] = _params['content_type']

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file']:
            _files['file'] = _params['file']

        if _params['source_file_name']:
            _form_params.append(('sourceFileName', _params['source_file_name']))

        if _params['subfolder_name']:
            _form_params.append(('subfolderName', _params['subfolder_name']))

        if _params['mime_type']:
            _form_params.append(('mimeType', _params['mime_type']))

        if _params['commit_message']:
            _form_params.append(('commitMessage', _params['commit_message']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "UploadResultDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v1/connectors/{connectorId}/folders/{folder}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def upload_file1(self, connector_id : StrictStr, folder : StrictStr, file_name : StrictStr, memsource : StrictStr, content_type : StrictStr, file : Annotated[Union[StrictBytes, StrictStr], Field(..., description="Translated file to upload")], mime_type : Annotated[Optional[StrictStr], Field(description="Mime type of the file to upload")] = None, **kwargs) -> AsyncFileOpResponseDto:  # noqa: E501
        """Upload file (async)  # noqa: E501

        Upload a file to a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_file1(connector_id, folder, file_name, memsource, content_type, file, mime_type, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file_name: (required)
        :type file_name: str
        :param memsource: (required)
        :type memsource: str
        :param content_type: (required)
        :type content_type: str
        :param file: Translated file to upload (required)
        :type file: bytearray
        :param mime_type: Mime type of the file to upload
        :type mime_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AsyncFileOpResponseDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the upload_file1_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.upload_file1_with_http_info(connector_id, folder, file_name, memsource, content_type, file, mime_type, **kwargs)  # noqa: E501

    @validate_arguments
    def upload_file1_with_http_info(self, connector_id : StrictStr, folder : StrictStr, file_name : StrictStr, memsource : StrictStr, content_type : StrictStr, file : Annotated[Union[StrictBytes, StrictStr], Field(..., description="Translated file to upload")], mime_type : Annotated[Optional[StrictStr], Field(description="Mime type of the file to upload")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Upload file (async)  # noqa: E501

        Upload a file to a subfolder of the selected connector  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upload_file1_with_http_info(connector_id, folder, file_name, memsource, content_type, file, mime_type, async_req=True)
        >>> result = thread.get()

        :param connector_id: (required)
        :type connector_id: str
        :param folder: (required)
        :type folder: str
        :param file_name: (required)
        :type file_name: str
        :param memsource: (required)
        :type memsource: str
        :param content_type: (required)
        :type content_type: str
        :param file: Translated file to upload (required)
        :type file: bytearray
        :param mime_type: Mime type of the file to upload
        :type mime_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AsyncFileOpResponseDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'connector_id',
            'folder',
            'file_name',
            'memsource',
            'content_type',
            'file',
            'mime_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file1" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['connector_id']:
            _path_params['connectorId'] = _params['connector_id']

        if _params['folder']:
            _path_params['folder'] = _params['folder']

        if _params['file_name']:
            _path_params['fileName'] = _params['file_name']


        # process the query parameters
        _query_params = []
        if _params.get('mime_type') is not None:  # noqa: E501
            _query_params.append(('mimeType', _params['mime_type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if _params['memsource']:
            _header_params['Memsource'] = _params['memsource']

        if _params['content_type']:
            _header_params['Content-Type'] = _params['content_type']

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['file']:
            _files['file'] = _params['file']

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "AsyncFileOpResponseDto",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '405': None,
            '408': None,
            '410': None,
            '415': None,
            '429': None,
            '500': None,
            '501': None,
        }

        return self.api_client.call_api(
            '/api2/v2/connectors/{connectorId}/folders/{folder}/files/{fileName}/upload', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
