# phrasetms-client

Python client for Phrase TMS.

This Python package was initially automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project.

## Requirements.

Python 3.7+

## Installation & Usage

### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install phrasetms-client
```

(you may need to run `pip` with root permission: `sudo pip install phrasetms-client`)

Then import the package:

```python
import phrasetms_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```

(or `sudo python setup.py install` to install the package for all users)

Then import the package:

```python
import phrasetms_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import time
import phrasetms_client
from phrasetms_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://cloud.memsource.com/web
# See configuration.py for a list of all supported configuration parameters.
configuration = phrasetms_client.Configuration(
    host = "https://cloud.memsource.com/web"
)

# Enter a context with an instance of the API client
with phrasetms_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = phrasetms_client.AdditionalWorkflowStepApi(api_client)
    body = phrasetms_client.AdditionalWorkflowStepRequestDto() # AdditionalWorkflowStepRequestDto |  (optional)

    try:
        # Create additional workflow step
        api_response = api_instance.create_awf_step(body=body)
        print("The response of AdditionalWorkflowStepApi->create_awf_step:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdditionalWorkflowStepApi->create_awf_step: %s\n" % e)
```
