"""Contains enumerations for SolidWorks Warnings."""

from enum import Enum


class FileSaveWarning(Enum):
    ANIMATOR_CAMERA_VIEWS = 128
    ANIMATOR_FEATURE_EDITS = 16
    ANIMATOR_LIGHT_EDITS = 64
    ANIMATOR_NEED_TO_SOLVE = 8
    ANIMATOR_SECTION_VIEWS = 256
    EDRWINGS_BAD_SELECTION = 32
    MISSING_OLE_OBJECTS = 512
    NEEDS_REBUILD = 2
    OPENED_VIEW_ONLY = 1024
    REBUILD_ERROR = 1
    VIEWS_NEED_UPDATE = 4


class FileLoadWarning(Enum):
    ALREADY_OPEN = 128
    BASE_PART_NOT_LOADED = 64
    COMPONENT_MISSING_REFERENCED_CONFIG = 32768
    DIMENSIONS_REFERENCED_INCORRECTLY_TO_MODELS = 16384
    DRAWING_ANSI_UPDATE = 8
    DRAWING_SF_SYMBOL_CONVERT = 2048
    DRAWINGS_ONLY_RAPID_DRAFT = 256
    ID_MISMATCH = 1
    INVISIBLE_DOC_LINKED_DESIGN_TABLE_UPDATE_FAIL = 65536
    MISSING_DESIGN_TABLE = 131072
    MODEL_OUT_OF_DATE = 8192
    NEEDS_REGEN = 32
    READ_ONLY = 2
    RESOLVE_DIM_TOLERANCE = 4096
    SHARING_VIOLATION = 4
    SHEET_SCALE_UPDATE = 16
    VIEW_MISSING_REFERENCED_CONFIG = 1024
    VIEW_ONLY_RESTRICTIONS = 512
