# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['catimage']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=9.1.0,<10']

extras_require = \
{'full': ['cli2gui>=2022,<2024']}

entry_points = \
{'console_scripts': ['catimage = catimage.catimage:cli']}

setup_kwargs = {
    'name': 'catimage',
    'version': '2022.0.1',
    'description': 'Use to cat an image to the terminal',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/CatImage.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/CatImage.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/catimage.svg?style=for-the-badge)](https://pypistats.org/packages/catimage)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fcatimage)](https://pepy.tech/project/catimage)\n[![PyPI Version](https://img.shields.io/pypi/v/catimage.svg?style=for-the-badge)](https://pypi.org/project/catimage)\n\n<!-- omit in toc -->\n# CatImage\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nCat an image to the terminal.\n\n- [Example](#example)\n- [How To Use](#how-to-use)\n- [Documentation](#documentation)\n- [Install Single Script](#install-single-script)\n\t- [Wget](#wget)\n\t- [Curl](#curl)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Windows - Python.org](#windows---pythonorg)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n\t- [Dnf](#dnf)\n- [Install Python on MacOS](#install-python-on-macos)\n\t- [Homebrew](#homebrew)\n\t- [MacOS - Python.org](#macos---pythonorg)\n- [How to run](#how-to-run)\n\t- [Windows](#windows)\n\t- [Linux/ MacOS](#linux-macos)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n- [Screenshots](#screenshots)\n\t- [Desktop](#desktop)\n\n## Example\n\nOriginal Image:\n\n<img src="readme-assets/screenshots/desktop/example-0.png" alt="Screenshot 1" width="600">\n\nGreyscale Image:\n\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -g\n```\n\n<img src="readme-assets/screenshots/desktop/example-1.png" alt="Screenshot 2" width="600">\n\nRegular Definition Image:\n\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -r -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-2.png" alt="Screenshot 3" width="600">\n\nRegular Definition Image with \'@\':\n\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -r -c @ -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-3.png" alt="Screenshot 4" width="600">\n\nHD Image:\n\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-4.png" alt="Screenshot 5" width="600">\n\nHD Image with right half block:\n\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png -c $\'\\u2590\' -t\n```\n\n<img src="readme-assets/screenshots/desktop/example-5.png" alt="Screenshot 6" width="600">\n\nHD Image True Colour:\n\n```python\n./catimage.py readme-assets/screenshots/desktop/example-0.png\n```\n\n<img src="readme-assets/screenshots/desktop/example-6.png" alt="Screenshot 7" width="600">\n\n## How To Use\n\nUse to cat an image to the terminal, see the help text below for more\ninformation on using this tool from the command line:\n\n```bash\nusage: catimage [-h] [-u] [-b] [-c CHAR] [-t] [-g | -r] image\n\ncat an image to the terminal\n\npositional arguments:\n  image                 image file or url\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -u, --url             image is a URL\n  -b, --big             big image\n  -c CHAR, --char CHAR  char to use in colour print use $\'chr\' for escaped chars\n  -t, --disable-truecolour\n                        disable output in truecolour\n\nchoose one of the following:\n  use the following arguments to change the look of the image\n\n  -g, --greyscale       output image in greyscale (best for terminals that cannot handle ANSI)\n  -r, --regular         output image in regular definition\n```\n\nGUI\n\nUse the --cli2gui flag to launch a GUI\n\n<div>\n<img src="readme-assets/screenshots/desktop/gui-0.png" alt="GUI 1" width="600">\n<img src="readme-assets/screenshots/desktop/gui-1.png" alt="GUI 2" width="600">\n</div>\n\nAlternatively, import into your project and use:\n\n```python\ndef generateHDColour(imageName, maxLen, trueColour=True, char="\\u2584"):\n\t"""Iterate through image pixels to make a printable string\n\n\tArgs:\n\t\timageName (str): path of the image on the filesystem (relative of\n\t\tabsolute)\n\t\tmaxLen (int): maximum of width and height in chars\n\t\ttrueColour (bool, optional): print in true colour. Defaults to True.\n\t\tchar (str, optional): use this char for each pixel. Defaults to "\\u2584".\n\n\tReturns:\n\t\tstr: string to print\n\t"""\n\ndef generateColour(imageName, maxLen, trueColour=True, char="\\u2588"):\n\t"""Iterate through all of the pixels in an image and construct a printable\n\tstring\n\n\tArgs:\n\t\timageName (str): path of the image on the filesystem (relative of\n\t\tabsolute)\n\t\tmaxLen (int): maximum of width and height in chars\n\t\ttrueColour (bool, optional): print in true colour. Defaults to True.\n\t\tchar (str, optional): use this char for each pixel. Defaults to "\\u2588".\n\n\tReturns:\n\t\tstr: string to print\n\t"""\n\ndef generateGreyscale(imageName, maxLen):\n\t"""Iterate through image pixels to make a printable string\n\n\tArgs:\n\t\timageName (str): path of the image on the filesystem (relative of\n\t\tabsolute)\n\t\tmaxLen (int): maximum of width and height in chars\n\n\tReturns:\n\t\tstr: string to print\n\t"""\n```\n\n## Documentation\n\nA high-level overview of how the documentation is organized organized will help you know\nwhere to look for certain things:\n\n<!--\n- [Tutorials](/documentation/tutorials) take you by the hand through a series of steps to get\n  started using the software. Start here if you’re new.\n-->\n- The [Technical Reference](/documentation/reference) documents APIs and other aspects of the\n  machinery. This documentation describes how to use the classes and functions at a lower level\n  and assume that you have a good high-level understanding of the software.\n<!--\n- The [Help](/documentation/help) guide provides a starting point and outlines common issues that you\n  may have.\n-->\n\n## Install Single Script\n\n### Wget\n\n```bash\nwget -O /usr/bin/catimage https://raw.githubusercontent.com/FHPythonUtils/CatImage/master/catimage.py && sudo chmod 774 /usr/bin/catimage\n```\n\n### Curl\n\n```bash\ncurl -o /usr/bin/catimage https://raw.githubusercontent.com/FHPythonUtils/CatImage/master/catimage.py && sudo chmod 774 /usr/bin/catimage\n```\n\n## Install With PIP\n\n```python\npip install catimage\n```\n\nHead to https://pypi.org/project/catimage/ for more info\n\n## Language information\n\n### Built for\n\nThis program has been written for Python versions 3.7 - 3.10 and has been tested with both 3.7 and\n3.10\n\n## Install Python on Windows\n\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Windows - Python.org\n\nTo install Python, go to https://www.python.org/downloads/windows/ and download the latest\nversion.\n\n## Install Python on Linux\n\n### Apt\n\n```bash\nsudo apt install python3.x\n```\n\n### Dnf\n\n```bash\nsudo dnf install python3.x\n```\n\n## Install Python on MacOS\n\n### Homebrew\n\n```bash\nbrew install python@3.x\n```\n\n### MacOS - Python.org\n\nTo install Python, go to https://www.python.org/downloads/macos/ and download the latest\nversion.\n\n## How to run\n\n### Windows\n\n- Module\n\t`py -3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`py -3.x [file]` or `./[file]`\n\n### Linux/ MacOS\n\n- Module\n\t`python3.x -m [module]` or `[module]` (if module installs a script)\n\n- File\n\t`python3.x [file]` or `./[file]`\n\n## Download Project\n\n### Clone\n\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/CatImage\n\t```\n\nMore information can be found at\nhttps://help.github.com/en/articles/cloning-a-repository\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\nhttps://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n\n### Licence\n\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\n\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\n\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\n\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\n\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\n\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\n\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n\n## Screenshots\n\n### Desktop\n\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.png" alt="Screenshot 1" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-1.png" alt="Screenshot 2" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-2.png" alt="Screenshot 3" width="600">\n</div>\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FredHappyface/Python.CatImage',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
