# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from unicatdb.openapi_client.configuration import Configuration


class TenantUser(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'idm_subject_id': 'str',
        'full_name': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'email': 'str',
        'picture_url': 'str',
        'role': 'TenantUserRole'
    }

    attribute_map = {
        'id': 'id',
        'idm_subject_id': 'idmSubjectId',
        'full_name': 'fullName',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'email': 'email',
        'picture_url': 'pictureUrl',
        'role': 'role'
    }

    def __init__(self, id=None, idm_subject_id=None, full_name=None, first_name=None, last_name=None, email=None, picture_url=None, role=None, local_vars_configuration=None):  # noqa: E501
        """TenantUser - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._idm_subject_id = None
        self._full_name = None
        self._first_name = None
        self._last_name = None
        self._email = None
        self._picture_url = None
        self._role = None
        self.discriminator = None

        self.id = id
        self.idm_subject_id = idm_subject_id
        self.full_name = full_name
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if email is not None:
            self.email = email
        if picture_url is not None:
            self.picture_url = picture_url
        self.role = role

    @property
    def id(self):
        """Gets the id of this TenantUser.  # noqa: E501

        Tenant user's ID  # noqa: E501

        :return: The id of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TenantUser.

        Tenant user's ID  # noqa: E501

        :param id: The id of this TenantUser.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def idm_subject_id(self):
        """Gets the idm_subject_id of this TenantUser.  # noqa: E501

        External unique ID of the IDM user.  # noqa: E501

        :return: The idm_subject_id of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._idm_subject_id

    @idm_subject_id.setter
    def idm_subject_id(self, idm_subject_id):
        """Sets the idm_subject_id of this TenantUser.

        External unique ID of the IDM user.  # noqa: E501

        :param idm_subject_id: The idm_subject_id of this TenantUser.  # noqa: E501
        :type idm_subject_id: str
        """
        if self.local_vars_configuration.client_side_validation and idm_subject_id is None:  # noqa: E501
            raise ValueError("Invalid value for `idm_subject_id`, must not be `None`")  # noqa: E501

        self._idm_subject_id = idm_subject_id

    @property
    def full_name(self):
        """Gets the full_name of this TenantUser.  # noqa: E501

        Full name of the user, incl. titles, middle names etc.  # noqa: E501

        :return: The full_name of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """Sets the full_name of this TenantUser.

        Full name of the user, incl. titles, middle names etc.  # noqa: E501

        :param full_name: The full_name of this TenantUser.  # noqa: E501
        :type full_name: str
        """
        if self.local_vars_configuration.client_side_validation and full_name is None:  # noqa: E501
            raise ValueError("Invalid value for `full_name`, must not be `None`")  # noqa: E501

        self._full_name = full_name

    @property
    def first_name(self):
        """Gets the first_name of this TenantUser.  # noqa: E501


        :return: The first_name of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this TenantUser.


        :param first_name: The first_name of this TenantUser.  # noqa: E501
        :type first_name: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this TenantUser.  # noqa: E501


        :return: The last_name of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this TenantUser.


        :param last_name: The last_name of this TenantUser.  # noqa: E501
        :type last_name: str
        """

        self._last_name = last_name

    @property
    def email(self):
        """Gets the email of this TenantUser.  # noqa: E501


        :return: The email of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this TenantUser.


        :param email: The email of this TenantUser.  # noqa: E501
        :type email: str
        """

        self._email = email

    @property
    def picture_url(self):
        """Gets the picture_url of this TenantUser.  # noqa: E501

        URL of the user's avatar picture. Can be external URL or data-URI.  # noqa: E501

        :return: The picture_url of this TenantUser.  # noqa: E501
        :rtype: str
        """
        return self._picture_url

    @picture_url.setter
    def picture_url(self, picture_url):
        """Sets the picture_url of this TenantUser.

        URL of the user's avatar picture. Can be external URL or data-URI.  # noqa: E501

        :param picture_url: The picture_url of this TenantUser.  # noqa: E501
        :type picture_url: str
        """

        self._picture_url = picture_url

    @property
    def role(self):
        """Gets the role of this TenantUser.  # noqa: E501


        :return: The role of this TenantUser.  # noqa: E501
        :rtype: TenantUserRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this TenantUser.


        :param role: The role of this TenantUser.  # noqa: E501
        :type role: TenantUserRole
        """
        if self.local_vars_configuration.client_side_validation and role is None:  # noqa: E501
            raise ValueError("Invalid value for `role`, must not be `None`")  # noqa: E501

        self._role = role

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TenantUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TenantUser):
            return True

        return self.to_dict() != other.to_dict()
