# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from unicatdb.openapi_client.configuration import Configuration


class Attachment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'original_filename': 'str',
        'content_type': 'str',
        'length': 'float',
        'upload_timestamp': 'date'
    }

    attribute_map = {
        'original_filename': 'originalFilename',
        'content_type': 'contentType',
        'length': 'length',
        'upload_timestamp': 'uploadTimestamp'
    }

    def __init__(self, original_filename=None, content_type=None, length=None, upload_timestamp=None, local_vars_configuration=None):  # noqa: E501
        """Attachment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._original_filename = None
        self._content_type = None
        self._length = None
        self._upload_timestamp = None
        self.discriminator = None

        self.original_filename = original_filename
        self.content_type = content_type
        self.length = length
        self.upload_timestamp = upload_timestamp

    @property
    def original_filename(self):
        """Gets the original_filename of this Attachment.  # noqa: E501


        :return: The original_filename of this Attachment.  # noqa: E501
        :rtype: str
        """
        return self._original_filename

    @original_filename.setter
    def original_filename(self, original_filename):
        """Sets the original_filename of this Attachment.


        :param original_filename: The original_filename of this Attachment.  # noqa: E501
        :type original_filename: str
        """
        if self.local_vars_configuration.client_side_validation and original_filename is None:  # noqa: E501
            raise ValueError("Invalid value for `original_filename`, must not be `None`")  # noqa: E501

        self._original_filename = original_filename

    @property
    def content_type(self):
        """Gets the content_type of this Attachment.  # noqa: E501

        MIME type of the file  # noqa: E501

        :return: The content_type of this Attachment.  # noqa: E501
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """Sets the content_type of this Attachment.

        MIME type of the file  # noqa: E501

        :param content_type: The content_type of this Attachment.  # noqa: E501
        :type content_type: str
        """
        if self.local_vars_configuration.client_side_validation and content_type is None:  # noqa: E501
            raise ValueError("Invalid value for `content_type`, must not be `None`")  # noqa: E501

        self._content_type = content_type

    @property
    def length(self):
        """Gets the length of this Attachment.  # noqa: E501

        Size of the file in bytes  # noqa: E501

        :return: The length of this Attachment.  # noqa: E501
        :rtype: float
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this Attachment.

        Size of the file in bytes  # noqa: E501

        :param length: The length of this Attachment.  # noqa: E501
        :type length: float
        """
        if self.local_vars_configuration.client_side_validation and length is None:  # noqa: E501
            raise ValueError("Invalid value for `length`, must not be `None`")  # noqa: E501

        self._length = length

    @property
    def upload_timestamp(self):
        """Gets the upload_timestamp of this Attachment.  # noqa: E501

        ISO 8601 formatted date, UTC time of day component may be present and equals to zero (00:00:00.000Z)  # noqa: E501

        :return: The upload_timestamp of this Attachment.  # noqa: E501
        :rtype: date
        """
        return self._upload_timestamp

    @upload_timestamp.setter
    def upload_timestamp(self, upload_timestamp):
        """Sets the upload_timestamp of this Attachment.

        ISO 8601 formatted date, UTC time of day component may be present and equals to zero (00:00:00.000Z)  # noqa: E501

        :param upload_timestamp: The upload_timestamp of this Attachment.  # noqa: E501
        :type upload_timestamp: date
        """
        if self.local_vars_configuration.client_side_validation and upload_timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `upload_timestamp`, must not be `None`")  # noqa: E501

        self._upload_timestamp = upload_timestamp

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Attachment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Attachment):
            return True

        return self.to_dict() != other.to_dict()
