# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from unicatdb.openapi_client.api_client import ApiClient
from unicatdb.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FindingsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_findings_delete_by_id(self, tenant_id, id, **kwargs):  # noqa: E501
        """Delete a specific finding, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_delete_by_id(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_delete_by_id_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_delete_by_id_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Delete a specific finding, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_delete_by_id_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_delete_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_delete_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_delete_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_get(self, tenant_id, **kwargs):  # noqa: E501
        """Get paged list of findings matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param sort: **Sort results by specified property name.**  ---------------  Default sorting order is descending. To sort in ascending order, prepend hypen charater (-) before the property name.  Nested object properties CAN be referenced by the dot notation (e.g: *dynamicData.kraj*). Entities with missing referenced property are sorted on top of the results (missing propety = smallest value).  Sorting by multiple properties is supported - individual property names can be separated by comma charater (,). Order of the properties does matter.  **Examples:**   * `?sort=documentName,-amount` - sort by document name in descending order, then by amount in ascending order * `?sort=dynamicData.kraj` - sort by *kraj* property of the dynamic data, findings missing the *kraj* property will be on top 
        :type sort: str
        :param page: **Specifies page size and page number for paged data responses.**  ---------------  Paging is optional. If not specified, the result will be paged based on the application defaults.  Paging may be turned off by passing page size of -1.  Links to the next, previous, first and last pages are provided in the `meta` property of the response, if applicable.  **Examples:**   * `?page[number]=2&page[size]=15` * `?page[size]=-1` - turns of paging 
        :type page: PageQuery
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. dynamicData.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=documentName,amount` * `?fields=dynamicData` - works OK  * `?fields=dynamicData.kraj` - **DOES NOT WORK!** 
        :type fields: FindingFieldsQuery
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_get_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def api_findings_get_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """Get paged list of findings matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param sort: **Sort results by specified property name.**  ---------------  Default sorting order is descending. To sort in ascending order, prepend hypen charater (-) before the property name.  Nested object properties CAN be referenced by the dot notation (e.g: *dynamicData.kraj*). Entities with missing referenced property are sorted on top of the results (missing propety = smallest value).  Sorting by multiple properties is supported - individual property names can be separated by comma charater (,). Order of the properties does matter.  **Examples:**   * `?sort=documentName,-amount` - sort by document name in descending order, then by amount in ascending order * `?sort=dynamicData.kraj` - sort by *kraj* property of the dynamic data, findings missing the *kraj* property will be on top 
        :type sort: str
        :param page: **Specifies page size and page number for paged data responses.**  ---------------  Paging is optional. If not specified, the result will be paged based on the application defaults.  Paging may be turned off by passing page size of -1.  Links to the next, previous, first and last pages are provided in the `meta` property of the response, if applicable.  **Examples:**   * `?page[number]=2&page[size]=15` * `?page[size]=-1` - turns of paging 
        :type page: PageQuery
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. dynamicData.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=documentName,amount` * `?fields=dynamicData` - works OK  * `?fields=dynamicData.kraj` - **DOES NOT WORK!** 
        :type fields: FindingFieldsQuery
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'sort',
            'page',
            'fields',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json', 'text/csv'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "FindingArrayResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_get_by_id(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get a specific finding, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. dynamicData.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=documentName,amount` * `?fields=dynamicData` - works OK  * `?fields=dynamicData.kraj` - **DOES NOT WORK!** 
        :type fields: FindingFieldsQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_get_by_id_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_get_by_id_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get a specific finding, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param fields: **Returns sparse field sets for a given resource type.**  ---------------  Since relationships and inclusion are not supported, use only resource type of the main entity (in this case findings).  Only specified fields will be returned, individual fields needs to be separated by comma (,) character.  Field set limiting by the nested properties (e.g. dynamicData.something) is NOT SUPPORTED and will result in HTTP 400 error.  **Examples:** * `?fields=documentName,amount` * `?fields=dynamicData` - works OK  * `?fields=dynamicData.kraj` - **DOES NOT WORK!** 
        :type fields: FindingFieldsQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id',
            'fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_get_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json', 'text/csv'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "FindingSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_get_by_id_attachments(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get attachments related to a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_attachments(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AttachmentArrayResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_get_by_id_attachments_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_get_by_id_attachments_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get attachments related to a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_attachments_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AttachmentArrayResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_get_by_id_attachments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_get_by_id_attachments`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_get_by_id_attachments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "AttachmentArrayResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_get_by_id_relationship_attachments(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get resource identifier for a given relationship of a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_relationship_attachments(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationshipResourceIdentifierResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_get_by_id_relationship_attachments_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_get_by_id_relationship_attachments_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get resource identifier for a given relationship of a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_relationship_attachments_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationshipResourceIdentifierResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_get_by_id_relationship_attachments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_get_by_id_relationship_attachments`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_get_by_id_relationship_attachments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "RelationshipResourceIdentifierResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}/relationships/attachments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_get_by_id_relationship_schema(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get resource identifier for a given relationship of a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_relationship_schema(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RelationshipResourceIdentifierResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_get_by_id_relationship_schema_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_get_by_id_relationship_schema_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get resource identifier for a given relationship of a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_relationship_schema_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RelationshipResourceIdentifierResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_get_by_id_relationship_schema" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_get_by_id_relationship_schema`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_get_by_id_relationship_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "RelationshipResourceIdentifierResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}/relationships/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_get_by_id_schema(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get schema related to a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_schema(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSchemaSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_get_by_id_schema_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_get_by_id_schema_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get schema related to a finding  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_get_by_id_schema_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSchemaSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_get_by_id_schema" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_get_by_id_schema`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_get_by_id_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "FindingSchemaSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
            415: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}/schema', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_patch_by_id(self, tenant_id, id, **kwargs):  # noqa: E501
        """Update an existing finding, if exists  # noqa: E501

        Notes concerinig the payload:  * **Use ISO date format** (e.g. 2018-10-08), time of day must be ommited or zero (e.g. 2018-10-08T00:00:00.000Z)  * Partial updates are supported. Ommited attributes will not be changed.  * Schema realtionship cannot be changed on existing findings (internal policy). Should the schema relationship be present in the request, HTTP 409 response will be returned and changes won't be saved.   * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_patch_by_id(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param existing_finding_request_body:
        :type existing_finding_request_body: ExistingFindingRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_patch_by_id_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_patch_by_id_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Update an existing finding, if exists  # noqa: E501

        Notes concerinig the payload:  * **Use ISO date format** (e.g. 2018-10-08), time of day must be ommited or zero (e.g. 2018-10-08T00:00:00.000Z)  * Partial updates are supported. Ommited attributes will not be changed.  * Schema realtionship cannot be changed on existing findings (internal policy). Should the schema relationship be present in the request, HTTP 409 response will be returned and changes won't be saved.   * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_patch_by_id_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param existing_finding_request_body:
        :type existing_finding_request_body: ExistingFindingRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id',
            'existing_finding_request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_patch_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_patch_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_patch_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'existing_finding_request_body' in local_var_params:
            body_params = local_var_params['existing_finding_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/vnd.api+json'],
                'PATCH', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "FindingSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
            409: "ErrorResponse",
            415: None,
            442: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_post(self, tenant_id, **kwargs):  # noqa: E501
        """Insert new finding to the database  # noqa: E501

        Notes concerinig the payload:  * **Use ISO date format** (e.g. 2018-10-08), time of day must be ommited or zero (e.g. 2018-10-08T00:00:00.000Z)  * ID of the inserted entity is created dynamically by the server, **providing client-generated ID in the request will result in HTTP 403 error**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_post(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param new_finding_request_body:
        :type new_finding_request_body: NewFindingRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FindingSingleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_post_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def api_findings_post_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """Insert new finding to the database  # noqa: E501

        Notes concerinig the payload:  * **Use ISO date format** (e.g. 2018-10-08), time of day must be ommited or zero (e.g. 2018-10-08T00:00:00.000Z)  * ID of the inserted entity is created dynamically by the server, **providing client-generated ID in the request will result in HTTP 403 error**   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_post_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param new_finding_request_body:
        :type new_finding_request_body: NewFindingRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FindingSingleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'new_finding_request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_finding_request_body' in local_var_params:
            body_params = local_var_params['new_finding_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.api+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/vnd.api+json'],
                'POST', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            201: "FindingSingleResponse",
            400: "ErrorResponse",
            401: None,
            403: None,
            409: "ErrorResponse",
            415: None,
            442: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/findings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_findings_put_by_id_attachments(self, tenant_id, id, **kwargs):  # noqa: E501
        """Upload a new attachment to an existing finding  # noqa: E501

        Notes concerinig the payload:  * File size is limited to 10 MB   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_put_by_id_attachments(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier of the finding, 24 lowercase hex digit string. (required)
        :type id: str
        :param file:
        :type file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AttachmentPutResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.api_findings_put_by_id_attachments_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_findings_put_by_id_attachments_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Upload a new attachment to an existing finding  # noqa: E501

        Notes concerinig the payload:  * File size is limited to 10 MB   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_findings_put_by_id_attachments_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier of the finding, 24 lowercase hex digit string. (required)
        :type id: str
        :param file:
        :type file: file
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AttachmentPutResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id',
            'file'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_findings_put_by_id_attachments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_findings_put_by_id_attachments`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_findings_put_by_id_attachments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}
        if 'file' in local_var_params:
            local_var_files['file'] = local_var_params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = local_var_params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data'],
                'PUT', body_params))  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            201: "AttachmentPutResponse",
            401: None,
            403: None,
            404: None,
            413: "ErrorResponse",
        }

        return self.api_client.call_api(
            '/{tenantId}/findings/{id}/attachments', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
