# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from unicatdb.openapi_client.api_client import ApiClient
from unicatdb.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ExportApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_export_findings_get(self, tenant_id, **kwargs):  # noqa: E501
        """Get semicolon-delimited CSV export of findings matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_export_findings_get(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.api_export_findings_get_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def api_export_findings_get_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """Get semicolon-delimited CSV export of findings matching optional criteria  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_export_findings_get_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_export_findings_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_export_findings_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/csv', 'application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorResponse",
            401: None,
            403: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/export/findings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_export_findings_get_by_id(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get semicolon-delimited CSV export of a specific finding, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_export_findings_get_by_id(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.api_export_findings_get_by_id_with_http_info(tenant_id, id, **kwargs)  # noqa: E501

    def api_export_findings_get_by_id_with_http_info(self, tenant_id, id, **kwargs):  # noqa: E501
        """Get semicolon-delimited CSV export of a specific finding, if exists  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_export_findings_get_by_id_with_http_info(tenant_id, id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param id: Resource identifier, 24 lowercase hex digit string. (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_export_findings_get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_export_findings_get_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `api_export_findings_get_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/csv', 'application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "str",
            400: "ErrorResponse",
            401: None,
            403: None,
            404: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/export/findings/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
