# coding: utf-8

"""
    UniCatDB API

    UniCatDB application API documentation, with examples and live testing.  This API is built in accordance with the **JSON API 1.0 standard**. For general information, see [the documentation](http://jsonapi.org/format/).  **Notes:** * JSON API standard requires use of the JSON API media type (application/vnd.api+json) for exchanging data. Clients must send all JSON API data with the headers `Content-Type: application/vnd.api+json` (POST, PATCH) and `Accept: application/vnd.api+json` (GET, DELETE). * [Relationships](http://jsonapi.org/format/#fetching-relationships) and their [inclusions](http://jsonapi.org/format/#fetching-includes) via the `include` query parameter, as specified by the standard, **are not implemented**, since there are no relationships present in the data model. * The standard does not prescribe any filtering strategies. This API implements two strategies which can be combined: **Basic filtering** based on the used [JSON API library](https://json-api-dotnet.github.io/#/filtering) and **Custom filtering** which allow for any possible query to the MongoDB server and can be extended and customize in the future. For more information about filtering, see the description of the `filter` down bellow. * **Non-standard PATCH behavior:** Sucessfull PATCH reuest always result in HTTP 200 response with the updated resource object, even if the server does not perform any additional modifications. HTTP 204 is never used in PATCH responses.   # noqa: E501

    The version of the OpenAPI document: v2
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from unicatdb.openapi_client.api_client import ApiClient
from unicatdb.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ChartsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_charts_findings_frequency(self, tenant_id, aggregate, **kwargs):  # noqa: E501
        """Frequency counts of findings' properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_charts_findings_frequency(tenant_id, aggregate, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param aggregate: Name of the property to aggregate (nested properties are supported via dot notation, including relationship identifier).  * This parameter is targeted on properties with **discrete**, non-numeric values. Numerical values are treated as strings. * Findings which are missing the selected property are omitted    (required)
        :type aggregate: str
        :param group: Optional groupping of the results by other property  * This parameter is targeted on properties with **discrete**, non-numeric values. Numerical values are treated as strings. * Findings which are missing the selected property, or when the property is not set are groupped into the NULL virual group.  
        :type group: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param max_items_per_group: Optional aggregation of items. Items in group after the set count will be summed into one virtual item whit _(Other)_ label. 
        :type max_items_per_group: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FrequencyChart
        """
        kwargs['_return_http_data_only'] = True
        return self.api_charts_findings_frequency_with_http_info(tenant_id, aggregate, **kwargs)  # noqa: E501

    def api_charts_findings_frequency_with_http_info(self, tenant_id, aggregate, **kwargs):  # noqa: E501
        """Frequency counts of findings' properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_charts_findings_frequency_with_http_info(tenant_id, aggregate, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param aggregate: Name of the property to aggregate (nested properties are supported via dot notation, including relationship identifier).  * This parameter is targeted on properties with **discrete**, non-numeric values. Numerical values are treated as strings. * Findings which are missing the selected property are omitted    (required)
        :type aggregate: str
        :param group: Optional groupping of the results by other property  * This parameter is targeted on properties with **discrete**, non-numeric values. Numerical values are treated as strings. * Findings which are missing the selected property, or when the property is not set are groupped into the NULL virual group.  
        :type group: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param max_items_per_group: Optional aggregation of items. Items in group after the set count will be summed into one virtual item whit _(Other)_ label. 
        :type max_items_per_group: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(FrequencyChart, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'aggregate',
            'group',
            'filter',
            'max_items_per_group'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_charts_findings_frequency" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_charts_findings_frequency`")  # noqa: E501
        # verify the required parameter 'aggregate' is set
        if self.api_client.client_side_validation and ('aggregate' not in local_var_params or  # noqa: E501
                                                        local_var_params['aggregate'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `aggregate` when calling `api_charts_findings_frequency`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if 'aggregate' in local_var_params and local_var_params['aggregate'] is not None:  # noqa: E501
            query_params.append(('aggregate', local_var_params['aggregate']))  # noqa: E501
        if 'group' in local_var_params and local_var_params['group'] is not None:  # noqa: E501
            query_params.append(('group', local_var_params['group']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'max_items_per_group' in local_var_params and local_var_params['max_items_per_group'] is not None:  # noqa: E501
            query_params.append(('max-items-per-group', local_var_params['max_items_per_group']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "FrequencyChart",
            400: "ErrorResponse",
            401: None,
            403: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/charts/findings/frequency', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_charts_findings_minimap(self, tenant_id, **kwargs):  # noqa: E501
        """Data for frequency heatmap  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_charts_findings_minimap(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MiniMapData
        """
        kwargs['_return_http_data_only'] = True
        return self.api_charts_findings_minimap_with_http_info(tenant_id, **kwargs)  # noqa: E501

    def api_charts_findings_minimap_with_http_info(self, tenant_id, **kwargs):  # noqa: E501
        """Data for frequency heatmap  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_charts_findings_minimap_with_http_info(tenant_id, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MiniMapData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_charts_findings_minimap" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_charts_findings_minimap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "MiniMapData",
            401: None,
            403: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/charts/findings/minimap', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def api_charts_findings_statistics(self, tenant_id, aggregate, **kwargs):  # noqa: E501
        """Statisctical data for findings' numerical properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_charts_findings_statistics(tenant_id, aggregate, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param aggregate: Name of the property to aggregate (nested properties are supported via dot notation, including relationship identifier).  * This parameter is targeted on properties with **numerical** values. Discrete, non-numeric values are filtered-out (number of filtered items with invalid type is in response meta). * Findings which are missing the selected property are omitted    (required)
        :type aggregate: str
        :param group: Optional groupping of the results by other property  * This parameter is targeted on properties with **discrete**, non-numeric values. Numerical values are treated as strings. * Findings which are missing the selected property, or when the property is not set are groupped into the NULL virual group.  
        :type group: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatisticalData
        """
        kwargs['_return_http_data_only'] = True
        return self.api_charts_findings_statistics_with_http_info(tenant_id, aggregate, **kwargs)  # noqa: E501

    def api_charts_findings_statistics_with_http_info(self, tenant_id, aggregate, **kwargs):  # noqa: E501
        """Statisctical data for findings' numerical properties  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.api_charts_findings_statistics_with_http_info(tenant_id, aggregate, async_req=True)
        >>> result = thread.get()

        :param tenant_id: Tenant identifier, 24 lowercase hex digit string. (required)
        :type tenant_id: str
        :param aggregate: Name of the property to aggregate (nested properties are supported via dot notation, including relationship identifier).  * This parameter is targeted on properties with **numerical** values. Discrete, non-numeric values are filtered-out (number of filtered items with invalid type is in response meta). * Findings which are missing the selected property are omitted    (required)
        :type aggregate: str
        :param group: Optional groupping of the results by other property  * This parameter is targeted on properties with **discrete**, non-numeric values. Numerical values are treated as strings. * Findings which are missing the selected property, or when the property is not set are groupped into the NULL virual group.  
        :type group: str
        :param filter: **Provides filter to be applied on the result set returned.**  ---------------  Filters are specified as as collection of *key<>value* pairs representing individual filters. If more filters are specifies, they are combined using *AND* logic operator.  Two filtering strategies are suported:  **Basic filter**  * *Key* - property name (nested properties are supported via dot notation, including relationship identifier)  * *Value* - filter expression prefixed with operation (operation is optional, defaults to **eq:** if not specified). Supprted operations:   * <code>filter[*property*]=<b>eq:</b>*value*</code> - Is equal to   * <code>filter[*property*]=<b>eqi:</b>*value*</code> - Is equal to (case insensitive)   * <code>filter[*property*]=<b>ne:</b>*value*</code> - Is not equal to   * <code>filter[*property*]=<b>lt:</b>*value*</code> - Is less than   * <code>filter[*property*]=<b>gt:</b>*value*</code> - Is greater than   * <code>filter[*property*]=<b>le:</b>*value*</code> - Is less than or equal   * <code>filter[*property*]=<b>ge:</b>*value*</code> - Is greater than or equal   * <code>filter[*property*]=<b>like:</b>*value*</code> - Contains substring   * <code>filter[*property*]=<b>in:</b>*value1*,*value2*,...</code> - Is in list   * <code>filter[*property*]=<b>nin:</b>*value1*,*value2*,...</code> - Is not in list  **Relationship filter**  * Filtering by properties of related resources. Only *id* is supported at the moment.   * <code>filter[schema.id]=<b>eq:</b>*id*</code> - Findings based on a specific schema  **Custom filter**  * *Key* - filter name, prefixed by underschore character (_)  * *Value* - filter expression, format depends on the selected filter. *Supported filters **for findings***:   * <code>filter[**_latlngbounds**]=*lat_lo|lng_lo|lat_hi|lng_hi*</code> - Filter findings with locationGpsPoint insige a bounding box where \"lo\" corresponds to the southwest corner of the bounding box, while \"hi\" corresponds to the northeast corner of that box.   
        :type filter: dict(str, str)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StatisticalData, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'aggregate',
            'group',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_charts_findings_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `api_charts_findings_statistics`")  # noqa: E501
        # verify the required parameter 'aggregate' is set
        if self.api_client.client_side_validation and ('aggregate' not in local_var_params or  # noqa: E501
                                                        local_var_params['aggregate'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `aggregate` when calling `api_charts_findings_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tenant_id' in local_var_params:
            path_params['tenantId'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []
        if 'aggregate' in local_var_params and local_var_params['aggregate'] is not None:  # noqa: E501
            query_params.append(('aggregate', local_var_params['aggregate']))  # noqa: E501
        if 'group' in local_var_params and local_var_params['group'] is not None:  # noqa: E501
            query_params.append(('group', local_var_params['group']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/vnd.api+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearerAuth']  # noqa: E501

        response_types_map = {
            200: "StatisticalData",
            400: "ErrorResponse",
            401: None,
            403: None,
        }

        return self.api_client.call_api(
            '/{tenantId}/charts/findings/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
