"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const kinesis = require("@aws-cdk/aws-kinesis");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const aws_kinesis_1 = require("@aws-cdk/aws-kinesis");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-iot-kinesisstreams';
// Definitions
const existingKinesisStream = new kinesis.Stream(stack, `existing-stream`, {
    shardCount: 2,
    retentionPeriod: core_1.Duration.hours(25),
    encryption: aws_kinesis_1.StreamEncryption.MANAGED
});
const props = {
    iotTopicRuleProps: {
        topicRulePayload: {
            description: "sends data to kinesis streams",
            sql: "SELECT * FROM 'solutions/constructs'",
            actions: []
        },
    },
    existingStreamObj: existingKinesisStream
};
new lib_1.IotToKinesisStreams(stack, 'test-iot-kinesisstreams', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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