# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mkdocs_version_annotations']

package_data = \
{'': ['*']}

entry_points = \
{'mkdocs.plugins': ['mkdocs-version-annotations = '
                    'mkdocs_version_annotations:MkDocsVersionAnnotationsPlugin']}

setup_kwargs = {
    'name': 'mkdocs-version-annotations',
    'version': '1.0.0',
    'description': 'MkDocs plugin to add custom admonitions for documenting version differences',
    'long_description': '# MkDocs Version Annotations\n\nThis is a simple [MkDocs](https://www.mkdocs.org/) plugin that adds a few simple macros to make it quicker and easier to add self-consistent annotations to your documentation about differences between project versions.\n\nThis plugin was originally developed for use with the [Nautobot](https://docs.nautobot.com/) project\'s documentation but should be reusable.\n\n## Usage\n\nInstall this plugin with `pip install mkdocs_version_annotations` and enable it as a plugin in your `mkdocs.yml`. You also should enable the [`admonition`](https://python-markdown.github.io/extensions/admonition/) Markdown extension:\n\n```yaml\nmarkdown_extensions:\n  - "admonition"\n\nplugins:\n  - "search"\n  - "mkdocs-version-annotations"\n```\n\nIn your documentation, you can then use any of the following macros at the start of any line:\n\n- `+++ 1.0.0` as an annotation that something was added in version 1.0.0 of your project\n- `+/- 1.0.0` as a annotation that something was changed in version 1.0.0 of your project\n- `--- 1.0.0` as a annotation that something was removed in version 1.0.0 of your project\n\nBecause these macros will be transformed into Markdown ["admonitions"](https://python-markdown.github.io/extensions/admonition/), you can optionally include details of the change as text on the following line(s) with a four-space indent, such as:\n\n```markdown\n+++ 1.0.0\n    Added the following parameters:\n\n    - "mass"\n    - "spin"\n    - "flavor"\n```\n\nwhich would render in the MkDocs-generated HTML as:\n\n```html\n<div class="admonition version-added">\n<p class="admonition-title">Added in version 1.0.0</p>\n<p>Added the following parameters:</p>\n<ul>...</ul>\n</div>\n```\n\n## Plugin Configuration\n\nBy default, these macros will render as the following admonitions, which are suitable for use with [`mkdocs-material`](https://squidfunk.github.io/mkdocs-material/) or similar themes that allow for [custom admonition styling](https://squidfunk.github.io/mkdocs-material/reference/admonitions/#custom-admonitions):\n\n```markdown\n!!! version-added "Added in version <version>"\n```\n\n```markdown\n!!! version-changed "Changed in version <version>"\n```\n\n```markdown\n!!! version-removed "Removed in version <version>"\n```\n\nThis can be fully customized via configuration, if desired! The following configuration keys can be specified in `mkdocs.yaml` under the `mkdocs-version-annotations` entry:\n\n| Configuration                | Default Value              |\n| ---------------------------- | -------------------------- |\n| `version_added_admonition`   | `"version-added"`          |\n| `version_added_title`        | `"Added in version \\\\1"`   |\n| `version_changed_admonition` | `"version-changed"`        |\n| `version_changed_title`      | `"Changed in version \\\\1"` |\n| `version_removed_admonition` | `"version-removed"`        |\n| `version_removed_title`      | `"Removed in version \\\\1"` |\n\nIn the `_title` configs, the `\\1` (backslash-escaped in YAML as `"\\\\1"`) corresponds to the version number specified in any given usage of the macro.\n\nSo for example, you could configure:\n\n```yaml\nplugins:\n  - mkdocs-version-annotations:\n      version_added_admonition: "info"\n      version_added_title: "New in version \\\\1"\n```\n\nin which case a `+++ 1.2.3` macro would now be rendered as:\n\n```markdown\n!!! info "New in version 1.2.3"\n```\n\n## Styling with `mkdocs-material`\n\nIf using [`mkdocs-material`](https://squidfunk.github.io/mkdocs-material/), you might want to add something like the following to the `extra.css` for your project documentation in order to have custom styling for each of these three custom admonition types. (If you don\'t add this, or use a different theme, they should still render nonetheless, most likely using the same styling as generic "info" admonitions.)\n\n```css\n:root {     \n    /* Icon for "version-added" admonition: Material Design Icons "plus-box-outline" */\n    --md-admonition-icon--version-added: url(\'data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M19 19V5H5v14h14m0-16a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h14m-8 4h2v4h4v2h-4v4h-2v-4H7v-2h4V7Z"/></svg>\');\n    /* Icon for "version-changed" admonition: Material Design Icons "delta" */\n    --md-admonition-icon--version-changed: url(\'data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 7.77 18.39 18H5.61L12 7.77M12 4 2 20h20"/></svg>\');\n    /* Icon for "version-removed" admonition: Material Design Icons "minus-circle-outline" */\n    --md-admonition-icon--version-removed: url(\'data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8m0-18A10 10 0 0 0 2 12a10 10 0 0 0 10 10 10 10 0 0 0 10-10A10 10 0 0 0 12 2M7 13h10v-2H7"/></svg>\');\n}\n\n/* "version-added" admonition in green */\n.md-typeset .admonition.version-added,\n.md-typeset details.version-added {\n    border-color: rgb(0, 200, 83);\n}\n.md-typeset .version-added > .admonition-title,\n.md-typeset .version-added > summary {\n    background-color: rgba(0, 200, 83, .1);\n}\n.md-typeset .version-added > .admonition-title::before,\n.md-typeset .version-added > summary::before {\n    background-color: rgb(0, 200, 83);\n    -webkit-mask-image: var(--md-admonition-icon--version-added);\n    mask-image: var(--md-admonition-icon--version-added);\n}\n\n/* "version-changed" admonition in orange */\n.md-typeset .admonition.version-changed,\n.md-typeset details.version-changed {\n    border-color: rgb(255, 145, 0);\n}\n.md-typeset .version-changed > .admonition-title,\n.md-typeset .version-changed > summary {\n    background-color: rgba(255, 145, 0, .1);\n}\n.md-typeset .version-changed > .admonition-title::before,\n.md-typeset .version-changed > summary::before {\n    background-color: rgb(255, 145, 0);\n    -webkit-mask-image: var(--md-admonition-icon--version-changed);\n    mask-image: var(--md-admonition-icon--version-changed);\n}\n\n/* "version-removed" admonition in red */\n.md-typeset .admonition.version-removed,\n.md-typeset details.version-removed {\n    border-color: rgb(255, 82, 82);\n}\n.md-typeset .version-removed > .admonition-title,\n.md-typeset .version-removed > summary {\n    background-color: rgba(255, 82, 82, .1);\n}\n.md-typeset .version-removed > .admonition-title::before,\n.md-typeset .version-removed > summary::before {\n    background-color: rgb(255, 82, 82);\n    -webkit-mask-image: var(--md-admonition-icon--version-removed);\n    mask-image: var(--md-admonition-icon--version-removed);\n}\n```\n\n## Development\n\nThe development environment for this plugin is based on [`invoke`](http://www.pyinvoke.org/) and [`Poetry`](https://python-poetry.org/). After installing Poetry itself, you can run `poetry shell` followed by `poetry install` to set up a Python virtual environment populated with this plugin\'s development tool dependencies. You can then use the installed `invoke` command to execute various development tasks:\n\n```\n$ invoke --list\nAvailable tasks:\n\n  bandit       Run bandit to validate basic static code security analysis.\n  black        Run black to check that Python files are consistently formatted.\n  flake8       Run flake8 code analysis.\n  pydocstyle   Run pydocstyle to validate docstring formatting adheres to standards.\n  pylint       Run pylint code static analysis.\n  tests        Run all linters and tests for this repository.\n```\n\nAfter making any code change, it is recommended to run `invoke tests` before committing your code.\n',
    'author': 'Glenn Matthews',
    'author_email': 'glenn@e-dad.net',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/glennmatthews/mkdocs-version-annotations',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
