# tkinterDev

`tkinter`高级工具包，实现了许多高级功能，我会持续更新的。😁😁😁
____
## 依赖问题
这个库拥有许多好用的功能，但是很多功能的代价就是需要依赖库，如果想要体验到完整内容就可以使用pip下载以下所有的库。

- [tkinter-tooltip](https://pypi.org/project/tkinter-tooltip/) 用于DevToolTip组件
- [pywin32](https://pypi.org/project/pywin/) 实现诸多高级功能需要的
- [win32mica](https://pypi.org/project/win32mica/) 实现云母高级特效需要的
- [BlurWindow](https://pypi.org/project/BlurWindow/) 实现亚克力高级特效需要的
- [darkdetect](https://pypi.org/project/darkdetect/) 用于检测是否是深色主题或是浅色主题
```bash
pip install tkinter-tooltip
```
```bash
pip install pywin32
```
```bash
pip install win32mica
```
```bash
pip install BlurWindow
```
```bash
pip install darkdetect
```
____
## 版本信息
请使用最新的稳定版，虽然最新版可以用，但不排除会出现一些不可免得错误，大版本更新有时会出现BUG，但是小版本可以考虑，因为小版本是对大版本的优化和改正，请按照下方标准进行安装。🐋🐳🐋🐳
- 不稳定版本 1.0.0 - 1.5.0 1.8.3 - 1.8.4 2.2.2
- 最新稳定版本 2.3.2
- 最低稳定版本 1.6.0
 
1.6.0 稳定版发布。

1.7.0 功能补充，添加`DevAppBar`模块。

1.8.0 `DevDrag`优化，预添加组件`DevAccumulatorButton`、`DevDocs`、`DevResize`（在以后可能会删除的组件）。

1.8.1 `DevWindow`优化，加入标题栏后，可显示在任务栏内。

1.8.2 `DevTitleBar`修正标题按钮放大按钮，删去最小化按钮的函数，因为最小化后就找不到窗口了，任务栏中的窗口也不见了，所以等以后尝试改正。

1.8.3 `DevTitleBar`优化。

1.8.4 `DevToplevel`修正。

1.8.5 `DevTitleBar`修正，真的最后一次修正了！

1.8.6 `DevWindow`优化，可以选择是否将窗口显示在任务栏。

1.8.7 `DevWindow`优化，可以使用`centre()`将窗口居中。

1.8.8 `DevTitleBar`优化，双击窗口放大。

1.9.0 正式稳定更新，组件参数各种优化，添加`DevSideBar`组件。

1.9.1 文档改正。

1.9.2 `DevTitleBar`修正最大化按钮和最小化按钮的的事件特征。

2.0.0 添加`DevResize`，可以通过`DevResize`来移动组件。

2.0.1 修正`DevResize`，在组件被消除时，将会批次销毁按钮组件

2.0.2 修改一些BUG，添加`DevObject`组件，用于管理组件。

2.0.3 修正错误。

2.0.4 修正错误。

2.0.6 添加图标，从tkdev.devicon里导入

2.1.0 优化代码，去除大量的windll代码，改用win32代码。添加window_custom函数，window参数输入tkinter.Tk窗口，即可使用win32去除窗口（因为可以用overrideredirect来自定义），所以还是摆在那，想用就用。添加window_embed函数，window填入tkinter.Tk窗口，toplevel填入tkinter.Toplevel窗口，即可使用系统的嵌套子系统。

2.1.1 添加window_custom_border_taskbar可以实现真正的自定义窗口。

2.1.2 添加window_minbox、window_maxbox。

2.1.3 添加devcore.DevSysTray组件，需安装pystray库使用

2.1.4 修正BUG

2.1.5 添加Stack组件

2.1.6 添加window_pos方法，可以快速移动窗口位置。添加taskbar_height参数快速获取任务栏高度。

2.1.7 添加devwin包，里面将是使用win32开发的组件。WinMDIWindow组件可以将TopLevel组件嵌入容器

2.2.0 添加devdraw包，使用Canvas进行绘画，现已做好DrawButton组件。并修改了一些默认值

2.2.1 导入win32mica库，添加DevWindow方法mica()启用云母效果，此功能仅在Windows11上可用。

2.2.2 更多功能实现 🚫（有严重BUG请勿使用）

2.3.0 严重BUG修正，请勿使用2.2.2版本。请勿同时使用mica()和acrylic()，如果需要，那么请将mica特效排在前面，acrylic排在后面，否则会出现不兼容的情况。

2.3.1 BUG修复

2.3.2 添加一键安装所有依赖库的功能，Install_ALL()
____

## devdemo
在终端输入以下代码，即可打开实例，看各个组件的功能🤣🤣
```commandline
python -m tkdev
```
____

## DevDrag 🤖
可以使组件拖动另一个组件进行移动，这算是里面做得最好的了。第一个填拖动那个组件使另一个组件移动，第二个填被拖动的组件。第三个填是否是窗口，默认为`False`。

```python

import tkdev as dev
import tkinter as tk

if __name__ == '__main__':
    root = tk.Tk()
    root.geometry("500x500")
    drag_widget = tk.Label(root, background="black", foreground="white", text="Hello DevDrag")
    drag_widget.pack(fill=tk.BOTH, expand=tk.YES)
    dev.DevDrag(drag_widget, drag_widget)
    root.mainloop()
```
运行以上代码，即可拖动窗口中的`Label`组件，因为是用18行代码写出来，并且无依赖，运行速度很快。但是还未实现调整组件大小的功能，有点苦恼。

### 运行问题❓
1.为什么我用这个拖动窗口会报错？
答：那是因为组件判断不了你是窗口还是组件，窗口用`geometry`，组件用`place`，两种方法不同。所以如果要用来拖动窗口的话，请加上`iswindow`参数，为`True`，即可正常运行。

```python

import tkdev as dev

dev.DevDrag(widget, window, iswindow=true)
```
____

## DevResize
可以通过拖拽旁边的按钮来修改组件的大小。
```python
import tkdev as dev
import tkinter as tk

if __name__ == '__main__':
    root = tk.Tk() 
    root.geometry("500x500")
    button = tk.Button(root)
    button.place(x=10, y=10, width=480, height=480)
    dev.DevResize(widget=button)
    root.mainloop()
```

____

## DevSubWindow🤖
在`Qt`里可以使用`MDI`这个组件制作子窗口，而tkinter中未实现这个功能，而我又想制作`tkinter`的设计器，需要子窗口功能，于是我就自己做了一个，里面都是有`tkinter`组件做的，并非`ttk`。不是我不想要漂亮的界面，而是我发现使用`ttk`，按钮的边框太长了，显得不美观，于是就用`tk`组件了。

```python

import tkdev as dev
import tkinter as tk

if __name__ == '__main__':
    root = tk.Tk()
    root.geometry("300x300")
    subwindow = dev.DevSubWindow(root, title="DevSubWindow")
    subwindow.place(x=5, y=5, width=290, height=290)

    root.mainloop()
```
### 运行问题❓
1.暂无，等待反馈
____

## DevTitleBar和DevWindow
这两个组件需要一起搭配着进行使用最好，`DevWindow`的`wm_titlebar`可以设置标题栏，而`DevTitleBar`做的标题栏与`DevWindow`正好很搭配。

```python

import tkdev as dev
import tkinter as tk

if __name__ == '__main__':
    root = dev.DevWindow()
    root.geometry("300x300")
    titlebar = dev.DevTitleBar(root, iswindow=True, window=root, title_label="Hello")
    root.titlebar(titlebar)
    root.mainloop()
```
可是，当你运行以上的代码之后，你会发现，这个`DevTitleBar`和`DevSubWindow`的标题栏一模一样，其实`DevSubWindow`就是使用`DevTitleBar`做的。`close`是指定是否显示关闭按钮，`max`是指定是否显示放大按钮，`min`是指定是否显示缩小按钮，`title`是指定是否显示标题栏。如果后面想要加入标题按钮、标题，可以使用`add_close()` `add_max()` `add_min()` `add_title()`进行添加
### 运行问题❓
1.为什么我用`DevTitleBa`r时标题没有出现？答：这个组件的参数`title`并不是直接写入标题参数，而是需要用`title_label`参数设置标题栏的标题，因为`title`参数是决定是否显示标题栏的参数，写True则显示标题栏，反之隐藏。
____

## DevStatusBar