#
# This code has been auto-generated by the MDE Workbench
# Version: 3.0.4.
#
# File: Pete ABS_mod
# Date: 2022-10-26 10:48
# Time: 10:48
#


import pytest
from ..src.pypws.calculations import VesselLeakCalculation
from ..src.pypws.calculations import DispersionCalculation
from ..src.pypws.calculations import MaxConcFootprintCalculation

from ..src.pypws.entities import DischargeParameters, Leak, State
from ..src.pypws.entities import Material, Vessel, MaterialComponent
from ..src.pypws.entities import LocalPosition, Weather
from ..src.pypws.entities import DispersionParameters, Substrate
from ..src.pypws.entities import DispersionOutputConfig

from ..src.pypws.enums import ResultCode, FlashAtOrifice
from ..src.pypws.enums import TimeVaryingOption, FluidSpec
from ..src.pypws.enums import MixtureModelling, PropertyTemplate
from ..src.pypws.enums import VesselShape, VesselConditions
from ..src.pypws.enums import AtmosphericStabilityClass
from ..src.pypws.enums import RainoutThermoFlag, SurfaceType
from ..src.pypws.enums import PoolSurfaceType, Resolution
from ..src.pypws.enums import SpecialConcentration, ContourType

from ..src.pypws.utilities import getApiTarget

@pytest.mark.skip(reason="Skipped pending changes to authentication.")
def test_peteABS_mod():

  print('\n******************************************************************************************')
  print(' Running against: %s' % (getApiTarget()))
  print('******************************************************************************************\n')

  # Declare the entities required by the vesselLeakCalculation instance.
  dischargeParameters = DischargeParameters()
  leak = Leak()
  state = State()
  material = Material()
  vessel = Vessel()

  # Set properties with data mappings to the vesselLeakCalculation instance.
  # Set data for the dischargeParameters property.
  dischargeParameters.flashAtOrifice = FlashAtOrifice.DISALLOW_LIQUID_FLASH

  # Set data for the leak property.
  leak.releaseAngle = 0.0
  leak.timeVaryingOption = TimeVaryingOption.TIME_VARYING_RATE
  leak.holeDiameter = 0.025
  leak.holeHeightFraction = 0.0

  # Set data for the state property.
  state.pressure = 500000.0
  state.temperature = 265.0
  state.liquidFraction = 0.0
  state.flashFlag = FluidSpec.TP
  state.mixtureModelling = MixtureModelling.PC

  # Set data for the material property.
  material.componentCount = 1
  materialComponent = MaterialComponent()
  materialComponent.name = "METHANE"
  materialComponent.moleFraction = 1.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)
  materialComponent = MaterialComponent()
  materialComponent.name = ""
  materialComponent.moleFraction = 0.0
  material.components.append(materialComponent)

  material.propertyTemplate = PropertyTemplate.PHAST_MC

  # Set data for the vessel property.
  vessel.location.x = 0.0
  vessel.location.y = 0.0
  vessel.location.z = 0.0
  vessel.state = state
  vessel.diameter = 5.0
  vessel.height = 0.0
  vessel.length = 15.0
  vessel.width = 0.0
  vessel.shape = VesselShape.HORIZONTAL_CYLINDER
  vessel.material = material
  vessel.vesselConditions = VesselConditions.PURE_GAS
  vessel.liquidFillFractionByVolume = 0.0

  # Declare the vesselLeakCalculation calculation instance.
  vesselLeakCalculation = VesselLeakCalculation()

  vesselLeakCalculation.vessel = vessel
  vesselLeakCalculation.leak = leak
  vesselLeakCalculation.dischargeParameters = dischargeParameters

  # Run the vesselLeakCalculation instance.
  print('.... Running vessel leak calculation')

  resultCode = vesselLeakCalculation.run()

  print('>>>> Result code of vesselLeakCalculation (VesselLeakCalculation) run: ', resultCode)

  # Print out any messages
  vesselLeakCalculation.print_messages()

  assert resultCode == ResultCode.SUCCESS, f'Errors encountered running vesselLeakCalculation. Result Code: {resultCode}.'

  print('>>>> Vessel leak calculation ran successfully')

  # Declare the entities required by the dispersionCalculation instance.
  weather = Weather()
  dispersionParameters = DispersionParameters()

  # Set properties with data mappings to the dispersionCalculation instance.
  # Set data for the weather property.
  weather.windSpeed = 2.0
  weather.stabilityClass = AtmosphericStabilityClass.STABILITY_F
  weather.temperature = 283.0
  weather.relativeHumidity = 0.7
  weather.mixingLayerHeight = 800.0
  weather.solarRadiation = 500.0

  # Set data for the dispersionParameters property.
  dispersionParameters.relativeTolerance = 0.001
  dispersionParameters.rainoutThermoFlag = RainoutThermoFlag.RAINOUT_NON_EQUILIBRIUM
  dispersionParameters.fixedStepSize = 0.01
  dispersionParameters.outputStepMultiplier = 1.2
  dispersionParameters.maxDispersionDistance = 50000.0
  dispersionParameters.maxDispersionHeight = 1000.0
  dispersionParameters.numberOfReleaseObservers = 5
  dispersionParameters.numberOfPoolObservers = 10
  dispersionParameters.averagingTime = 18.75
  dispersionParameters.lflFractionToStop = 0.5

  # Declare the dispersionCalculation calculation instance.
  dispersionCalculation = DispersionCalculation()

  dispersionCalculation.material = vesselLeakCalculation.exitMaterial
  dispersionCalculation.dischargeResult = vesselLeakCalculation.dischargeResult
  dispersionCalculation.dischargeRecords = vesselLeakCalculation.dischargeRecords
  dispersionCalculation.dispersionParameters = dispersionParameters
  dispersionCalculation.weather = weather

  # Set unmapped properties for dispersionCalculation (Substrate property).
  dispersionCalculation.substrate.surfaceRoughness = 0.183
  dispersionCalculation.substrate.surfaceType = SurfaceType.LAND
  dispersionCalculation.substrate.poolSurfaceType = PoolSurfaceType.CONCRETE

  # Set unmapped properties for dispersionCalculation (EndPointConcentration property).
  dispersionCalculation.endPointConcentration = 0.0

  # Run the dispersionCalculation instance.
  print('.... Running dispersion calculation')

  resultCode = dispersionCalculation.run()

  print('>>>> Result code of dispersionCalculation (DispersionCalculation) run: ', resultCode)

  # Print out any messages
  dispersionCalculation.print_messages()

  assert resultCode == ResultCode.SUCCESS, f'Errors encountered running dispersionCalculation. Result Code: {resultCode}.'

  print('>>>> Dispersion calculation ran successfully')

  # Declare the entities required by the maxConcFootprintCalculation instance.

  # Set properties with data mappings to the maxConcFootprintCalculation instance.
  # Declare the maxConcFootprintCalculation calculation instance.
  maxConcFootprintCalculation = MaxConcFootprintCalculation()

  maxConcFootprintCalculation.scalarUdmOutputs = dispersionCalculation.scalarUdmOutputs
  maxConcFootprintCalculation.weather = dispersionCalculation.weather
  maxConcFootprintCalculation.dispersionRecords = dispersionCalculation.dispersionRecords
  maxConcFootprintCalculation.substrate = dispersionCalculation.substrate
  maxConcFootprintCalculation.material = dispersionCalculation.material
  maxConcFootprintCalculation.dispersionParameters = dispersionCalculation.dispersionParameters

  # Set unmapped properties for maxConcFootprintCalculation (DispersionOutputConfig property).
  maxConcFootprintCalculation.dispersionOutputConfig.downwindDistance = 100.0
  maxConcFootprintCalculation.dispersionOutputConfig.time = 60.0
  maxConcFootprintCalculation.dispersionOutputConfig.resolution = Resolution.HIGH
  maxConcFootprintCalculation.dispersionOutputConfig.elevation = 1.0
  maxConcFootprintCalculation.dispersionOutputConfig.specialConcentration = SpecialConcentration.MIN
  maxConcFootprintCalculation.dispersionOutputConfig.concentration = 0.0
  maxConcFootprintCalculation.dispersionOutputConfig.crosswindDistance = 0.0
  maxConcFootprintCalculation.dispersionOutputConfig.contourType = ContourType.FOOTPRINT
  maxConcFootprintCalculation.dispersionOutputConfig.lflFractionValue = 0.5

  # Run the maxConcFootprintCalculation instance.
  print('.... Running max conc footprint calculation')

  resultCode = maxConcFootprintCalculation.run()

  print('>>>> Result code of maxConcFootprintCalculation (MaxConcFootprintCalculation) run: ', resultCode)

  # Print out any messages
  maxConcFootprintCalculation.print_messages()

  assert resultCode == ResultCode.SUCCESS, f'Errors encountered running maxConcFootprintCalculation. Result Code: {resultCode}.'

  print('>>>> Max conc footprint calculation ran successfully')

  # Declare the entities required by the footprintAtTimeCalculation instance.

  # Set properties with data mappings to the footprintAtTimeCalculation instance.
  # Declare the footprintAtTimeCalculation calculation instance.
  footprintAtTimeCalculation = MaxConcFootprintCalculation()

  footprintAtTimeCalculation.scalarUdmOutputs = dispersionCalculation.scalarUdmOutputs
  footprintAtTimeCalculation.weather = dispersionCalculation.weather
  footprintAtTimeCalculation.dispersionRecords = dispersionCalculation.dispersionRecords
  footprintAtTimeCalculation.substrate = dispersionCalculation.substrate
  footprintAtTimeCalculation.material = dispersionCalculation.material
  footprintAtTimeCalculation.dispersionParameters = dispersionCalculation.dispersionParameters

  # Set unmapped properties for footprintAtTimeCalculation (DispersionOutputConfig property).
  footprintAtTimeCalculation.dispersionOutputConfig.downwindDistance = 100.0
  footprintAtTimeCalculation.dispersionOutputConfig.time = 300.0
  footprintAtTimeCalculation.dispersionOutputConfig.resolution = Resolution.HIGH
  footprintAtTimeCalculation.dispersionOutputConfig.elevation = 1.0
  footprintAtTimeCalculation.dispersionOutputConfig.specialConcentration = SpecialConcentration.MIN
  footprintAtTimeCalculation.dispersionOutputConfig.concentration = 0.0
  footprintAtTimeCalculation.dispersionOutputConfig.crosswindDistance = 0.0
  footprintAtTimeCalculation.dispersionOutputConfig.contourType = ContourType.FOOTPRINT_AT_TIME
  footprintAtTimeCalculation.dispersionOutputConfig.lflFractionValue = 0.5

  # Run the footprintAtTimeCalculation instance.
  print('.... Running max conc footprint calculation')

  resultCode = footprintAtTimeCalculation.run()

  print('>>>> Result code of footprintAtTimeCalculation (MaxConcFootprintCalculation) run: ', resultCode)

  # Print out any messages
  footprintAtTimeCalculation.print_messages()

  assert resultCode == ResultCode.SUCCESS, f'Errors encountered running footprintAtTimeCalculation. Result Code: {resultCode}.'

  print('>>>> Max conc footprint calculation ran successfully')
