import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::SageMaker::CodeRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 * @external
 */
export interface CfnCodeRepositoryProps {
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     * @external
     */
    readonly gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     * @external
     */
    readonly codeRepositoryName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 * @external
 * @cloudformationResource AWS::SageMaker::CodeRepository
 */
export declare class CfnCodeRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::CodeRepository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCodeRepository;
    /**
     * @external
     * @cloudformationAttribute CodeRepositoryName
     */
    readonly attrCodeRepositoryName: string;
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     * @external
     */
    gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     * @external
     */
    codeRepositoryName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCodeRepositoryProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 * @external
 * @cloudformationResource AWS::SageMaker::CodeRepository
 */
export declare namespace CfnCodeRepository {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
     * @external
     */
    interface GitConfigProperty {
        /**
         * `CfnCodeRepository.GitConfigProperty.Branch`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
         * @external
         */
        readonly branch?: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.RepositoryUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
         * @external
         */
        readonly repositoryUrl: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.SecretArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
         * @external
         */
        readonly secretArn?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 */
export interface CfnDataQualityJobDefinitionProps {
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
     * @external
     */
    readonly dataQualityAppSpecification: CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
     * @external
     */
    readonly dataQualityJobInput: CfnDataQualityJobDefinition.DataQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
     * @external
     */
    readonly dataQualityJobOutputConfig: CfnDataQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
     * @external
     */
    readonly jobResources: CfnDataQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
     * @external
     */
    readonly dataQualityBaselineConfig?: CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
     * @external
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
     * @external
     */
    readonly networkConfig?: CfnDataQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
     * @external
     */
    readonly stoppingCondition?: CfnDataQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare class CfnDataQualityJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::DataQualityJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataQualityJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification
     * @external
     */
    dataQualityAppSpecification: CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput
     * @external
     */
    dataQualityJobInput: CfnDataQualityJobDefinition.DataQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjoboutputconfig
     * @external
     */
    dataQualityJobOutputConfig: CfnDataQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobresources
     * @external
     */
    jobResources: CfnDataQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.DataQualityBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig
     * @external
     */
    dataQualityBaselineConfig: CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-jobdefinitionname
     * @external
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig
     * @external
     */
    networkConfig: CfnDataQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition
     * @external
     */
    stoppingCondition: CfnDataQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::DataQualityJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html#cfn-sagemaker-dataqualityjobdefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::DataQualityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataQualityJobDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html
     * @external
     */
    interface ClusterConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancecount
         * @external
         */
        readonly instanceCount: number;
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumekmskeyid
         * @external
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnDataQualityJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-clusterconfig.html#cfn-sagemaker-dataqualityjobdefinition-clusterconfig-volumesizeingb
         * @external
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html
     * @external
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnDataQualityJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-constraintsresource.html#cfn-sagemaker-dataqualityjobdefinition-constraintsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html
     * @external
     */
    interface DataQualityAppSpecificationProperty {
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.ContainerArguments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerarguments
         * @external
         */
        readonly containerArguments?: string[];
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-containerentrypoint
         * @external
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-environment
         * @external
         */
        readonly environment?: CfnDataQualityJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-imageuri
         * @external
         */
        readonly imageUri: string;
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-postanalyticsprocessorsourceuri
         * @external
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnDataQualityJobDefinition.DataQualityAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityappspecification.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityappspecification-recordpreprocessorsourceuri
         * @external
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html
     * @external
     */
    interface DataQualityBaselineConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty.BaseliningJobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-baseliningjobname
         * @external
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty.ConstraintsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-constraintsresource
         * @external
         */
        readonly constraintsResource?: CfnDataQualityJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.DataQualityBaselineConfigProperty.StatisticsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig.html#cfn-sagemaker-dataqualityjobdefinition-dataqualitybaselineconfig-statisticsresource
         * @external
         */
        readonly statisticsResource?: CfnDataQualityJobDefinition.StatisticsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html
     * @external
     */
    interface DataQualityJobInputProperty {
        /**
         * `CfnDataQualityJobDefinition.DataQualityJobInputProperty.EndpointInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-dataqualityjobinput.html#cfn-sagemaker-dataqualityjobdefinition-dataqualityjobinput-endpointinput
         * @external
         */
        readonly endpointInput: CfnDataQualityJobDefinition.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html
     * @external
     */
    interface EndpointInputProperty {
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-endpointname
         * @external
         */
        readonly endpointName: string;
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3datadistributiontype
         * @external
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnDataQualityJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-endpointinput.html#cfn-sagemaker-dataqualityjobdefinition-endpointinput-s3inputmode
         * @external
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-environment.html
     * @external
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html
     * @external
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnDataQualityJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutput-s3output
         * @external
         */
        readonly s3Output: CfnDataQualityJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html
     * @external
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnDataQualityJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-dataqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
         * @external
         */
        readonly monitoringOutputs: Array<CfnDataQualityJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html
     * @external
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnDataQualityJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-monitoringresources.html#cfn-sagemaker-dataqualityjobdefinition-monitoringresources-clusterconfig
         * @external
         */
        readonly clusterConfig: CfnDataQualityJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html
     * @external
     */
    interface NetworkConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
         * @external
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-enablenetworkisolation
         * @external
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnDataQualityJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-networkconfig.html#cfn-sagemaker-dataqualityjobdefinition-networkconfig-vpcconfig
         * @external
         */
        readonly vpcConfig?: CfnDataQualityJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html
     * @external
     */
    interface S3OutputProperty {
        /**
         * `CfnDataQualityJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnDataQualityJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uploadmode
         * @external
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnDataQualityJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-s3output.html#cfn-sagemaker-dataqualityjobdefinition-s3output-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html
     * @external
     */
    interface StatisticsResourceProperty {
        /**
         * `CfnDataQualityJobDefinition.StatisticsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-statisticsresource.html#cfn-sagemaker-dataqualityjobdefinition-statisticsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html
     * @external
     */
    interface StoppingConditionProperty {
        /**
         * `CfnDataQualityJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-dataqualityjobdefinition-stoppingcondition-maxruntimeinseconds
         * @external
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::DataQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-dataqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::DataQualityJobDefinition
 */
export declare namespace CfnDataQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnDataQualityJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDataQualityJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-dataqualityjobdefinition-vpcconfig.html#cfn-sagemaker-dataqualityjobdefinition-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Device`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 * @external
 */
export interface CfnDeviceProps {
    /**
     * `AWS::SageMaker::Device.Device`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
     * @external
     */
    readonly device?: CfnDevice.DeviceProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Device.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Device`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 * @external
 * @cloudformationResource AWS::SageMaker::Device
 */
export declare class CfnDevice extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Device";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDevice;
    /**
     * @external
     * @cloudformationAttribute DeviceFleetName
     */
    readonly attrDeviceFleetName: string;
    /**
     * `AWS::SageMaker::Device.Device`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-device
     * @external
     */
    device: CfnDevice.DeviceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Device.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html#cfn-sagemaker-device-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Device`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeviceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Device`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-device.html
 * @external
 * @cloudformationResource AWS::SageMaker::Device
 */
export declare namespace CfnDevice {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html
     * @external
     */
    interface DeviceProperty {
        /**
         * `CfnDevice.DeviceProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnDevice.DeviceProperty.DeviceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-devicename
         * @external
         */
        readonly deviceName: string;
        /**
         * `CfnDevice.DeviceProperty.IotThingName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-device-device.html#cfn-sagemaker-device-device-iotthingname
         * @external
         */
        readonly iotThingName?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::DeviceFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 * @external
 */
export interface CfnDeviceFleetProps {
    /**
     * `AWS::SageMaker::DeviceFleet.OutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
     * @external
     */
    readonly outputConfig: CfnDeviceFleet.EdgeOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DeviceFleet.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::DeviceFleet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::DeviceFleet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::DeviceFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 * @external
 * @cloudformationResource AWS::SageMaker::DeviceFleet
 */
export declare class CfnDeviceFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::DeviceFleet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeviceFleet;
    /**
     * @external
     * @cloudformationAttribute DeviceFleetName
     */
    readonly attrDeviceFleetName: string;
    /**
     * `AWS::SageMaker::DeviceFleet.OutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-outputconfig
     * @external
     */
    outputConfig: CfnDeviceFleet.EdgeOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::DeviceFleet.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::DeviceFleet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::DeviceFleet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html#cfn-sagemaker-devicefleet-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::DeviceFleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeviceFleetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::DeviceFleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-devicefleet.html
 * @external
 * @cloudformationResource AWS::SageMaker::DeviceFleet
 */
export declare namespace CfnDeviceFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html
     * @external
     */
    interface EdgeOutputConfigProperty {
        /**
         * `CfnDeviceFleet.EdgeOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnDeviceFleet.EdgeOutputConfigProperty.S3OutputLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-devicefleet-edgeoutputconfig.html#cfn-sagemaker-devicefleet-edgeoutputconfig-s3outputlocation
         * @external
         */
        readonly s3OutputLocation: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 */
export interface CfnEndpointProps {
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     * @external
     */
    readonly endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.DeploymentConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
     * @external
     */
    readonly deploymentConfig?: CfnEndpoint.DeploymentConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     * @external
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     * @external
     */
    readonly excludeRetainedVariantProperties?: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     * @external
     */
    readonly retainAllVariantProperties?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Endpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpoint;
    /**
     * @external
     * @cloudformationAttribute EndpointName
     */
    readonly attrEndpointName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     * @external
     */
    endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.DeploymentConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-deploymentconfig
     * @external
     */
    deploymentConfig: CfnEndpoint.DeploymentConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     * @external
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     * @external
     */
    excludeRetainedVariantProperties: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     * @external
     */
    retainAllVariantProperties: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Endpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html
     * @external
     */
    interface AlarmProperty {
        /**
         * `CfnEndpoint.AlarmProperty.AlarmName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-alarm.html#cfn-sagemaker-endpoint-alarm-alarmname
         * @external
         */
        readonly alarmName: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html
     * @external
     */
    interface AutoRollbackConfigProperty {
        /**
         * `CfnEndpoint.AutoRollbackConfigProperty.Alarms`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-autorollbackconfig.html#cfn-sagemaker-endpoint-autorollbackconfig-alarms
         * @external
         */
        readonly alarms: Array<CfnEndpoint.AlarmProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html
     * @external
     */
    interface BlueGreenUpdatePolicyProperty {
        /**
         * `CfnEndpoint.BlueGreenUpdatePolicyProperty.MaximumExecutionTimeoutInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-maximumexecutiontimeoutinseconds
         * @external
         */
        readonly maximumExecutionTimeoutInSeconds?: number;
        /**
         * `CfnEndpoint.BlueGreenUpdatePolicyProperty.TerminationWaitInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-terminationwaitinseconds
         * @external
         */
        readonly terminationWaitInSeconds?: number;
        /**
         * `CfnEndpoint.BlueGreenUpdatePolicyProperty.TrafficRoutingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-bluegreenupdatepolicy.html#cfn-sagemaker-endpoint-bluegreenupdatepolicy-trafficroutingconfiguration
         * @external
         */
        readonly trafficRoutingConfiguration: CfnEndpoint.TrafficRoutingConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html
     * @external
     */
    interface CapacitySizeProperty {
        /**
         * `CfnEndpoint.CapacitySizeProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnEndpoint.CapacitySizeProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-capacitysize.html#cfn-sagemaker-endpoint-capacitysize-value
         * @external
         */
        readonly value: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html
     * @external
     */
    interface DeploymentConfigProperty {
        /**
         * `CfnEndpoint.DeploymentConfigProperty.AutoRollbackConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-autorollbackconfiguration
         * @external
         */
        readonly autoRollbackConfiguration?: CfnEndpoint.AutoRollbackConfigProperty | cdk.IResolvable;
        /**
         * `CfnEndpoint.DeploymentConfigProperty.BlueGreenUpdatePolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-deploymentconfig.html#cfn-sagemaker-endpoint-deploymentconfig-bluegreenupdatepolicy
         * @external
         */
        readonly blueGreenUpdatePolicy: CfnEndpoint.BlueGreenUpdatePolicyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html
     * @external
     */
    interface TrafficRoutingConfigProperty {
        /**
         * `CfnEndpoint.TrafficRoutingConfigProperty.CanarySize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-canarysize
         * @external
         */
        readonly canarySize?: CfnEndpoint.CapacitySizeProperty | cdk.IResolvable;
        /**
         * `CfnEndpoint.TrafficRoutingConfigProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnEndpoint.TrafficRoutingConfigProperty.WaitIntervalInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-trafficroutingconfig.html#cfn-sagemaker-endpoint-trafficroutingconfig-waitintervalinseconds
         * @external
         */
        readonly waitIntervalInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 * @external
 * @cloudformationResource AWS::SageMaker::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
     * @external
     */
    interface VariantPropertyProperty {
        /**
         * `CfnEndpoint.VariantPropertyProperty.VariantPropertyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
         * @external
         */
        readonly variantPropertyType?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 */
export interface CfnEndpointConfigProps {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     * @external
     */
    readonly productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     * @external
     */
    readonly dataCaptureConfig?: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     * @external
     */
    readonly endpointConfigName?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare class CfnEndpointConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::EndpointConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpointConfig;
    /**
     * @external
     * @cloudformationAttribute EndpointConfigName
     */
    readonly attrEndpointConfigName: string;
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     * @external
     */
    productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.DataCaptureConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig
     * @external
     */
    dataCaptureConfig: CfnEndpointConfig.DataCaptureConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     * @external
     */
    endpointConfigName: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html
     * @external
     */
    interface CaptureContentTypeHeaderProperty {
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.CsvContentTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-csvcontenttypes
         * @external
         */
        readonly csvContentTypes?: string[];
        /**
         * `CfnEndpointConfig.CaptureContentTypeHeaderProperty.JsonContentTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader-jsoncontenttypes
         * @external
         */
        readonly jsonContentTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html
     * @external
     */
    interface CaptureOptionProperty {
        /**
         * `CfnEndpointConfig.CaptureOptionProperty.CaptureMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode
         * @external
         */
        readonly captureMode: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html
     * @external
     */
    interface DataCaptureConfigProperty {
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureContentTypeHeader`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader
         * @external
         */
        readonly captureContentTypeHeader?: CfnEndpointConfig.CaptureContentTypeHeaderProperty | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.CaptureOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions
         * @external
         */
        readonly captureOptions: Array<CfnEndpointConfig.CaptureOptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.DestinationS3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri
         * @external
         */
        readonly destinationS3Uri: string;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.EnableCapture`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture
         * @external
         */
        readonly enableCapture?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.InitialSamplingPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage
         * @external
         */
        readonly initialSamplingPercentage: number;
        /**
         * `CfnEndpointConfig.DataCaptureConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 */
export declare namespace CfnEndpointConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     * @external
     */
    interface ProductionVariantProperty {
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         * @external
         */
        readonly acceleratorType?: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         * @external
         */
        readonly initialInstanceCount: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         * @external
         */
        readonly initialVariantWeight: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         * @external
         */
        readonly modelName: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         * @external
         */
        readonly variantName: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 */
export interface CfnModelProps {
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     * @external
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     * @external
     */
    readonly containers?: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     * @external
     */
    readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.ModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     * @external
     */
    readonly modelName?: string;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     * @external
     */
    readonly primaryContainer?: CfnModel.ContainerDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Model.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnModel.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Model";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModel;
    /**
     * @external
     * @cloudformationAttribute ModelName
     */
    readonly attrModelName: string;
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     * @external
     */
    executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     * @external
     */
    containers: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.EnableNetworkIsolation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-enablenetworkisolation
     * @external
     */
    enableNetworkIsolation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.ModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     * @external
     */
    modelName: string | undefined;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     * @external
     */
    primaryContainer: CfnModel.ContainerDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Model.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     * @external
     */
    vpcConfig: CfnModel.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::Model`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare namespace CfnModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     * @external
     */
    interface ContainerDefinitionProperty {
        /**
         * `CfnModel.ContainerDefinitionProperty.ContainerHostname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         * @external
         */
        readonly containerHostname?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         * @external
         */
        readonly environment?: any | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Image`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         * @external
         */
        readonly image?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ImageConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-imageconfig
         * @external
         */
        readonly imageConfig?: CfnModel.ImageConfigProperty | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
         * @external
         */
        readonly mode?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         * @external
         */
        readonly modelDataUrl?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelPackageName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modelpackagename
         * @external
         */
        readonly modelPackageName?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.MultiModelConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-multimodelconfig
         * @external
         */
        readonly multiModelConfig?: CfnModel.MultiModelConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare namespace CfnModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html
     * @external
     */
    interface ImageConfigProperty {
        /**
         * `CfnModel.ImageConfigProperty.RepositoryAccessMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-imageconfig.html#cfn-sagemaker-model-containerdefinition-imageconfig-repositoryaccessmode
         * @external
         */
        readonly repositoryAccessMode: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare namespace CfnModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html
     * @external
     */
    interface MultiModelConfigProperty {
        /**
         * `CfnModel.MultiModelConfigProperty.ModelCacheSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition-multimodelconfig.html#cfn-sagemaker-model-containerdefinition-multimodelconfig-modelcachesetting
         * @external
         */
        readonly modelCacheSetting?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Model`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 * @external
 * @cloudformationResource AWS::SageMaker::Model
 */
export declare namespace CfnModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnModel.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModel.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 */
export interface CfnModelBiasJobDefinitionProps {
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
     * @external
     */
    readonly jobResources: CfnModelBiasJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
     * @external
     */
    readonly modelBiasAppSpecification: CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
     * @external
     */
    readonly modelBiasJobInput: CfnModelBiasJobDefinition.ModelBiasJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
     * @external
     */
    readonly modelBiasJobOutputConfig: CfnModelBiasJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
     * @external
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
     * @external
     */
    readonly modelBiasBaselineConfig?: CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
     * @external
     */
    readonly networkConfig?: CfnModelBiasJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
     * @external
     */
    readonly stoppingCondition?: CfnModelBiasJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare class CfnModelBiasJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelBiasJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelBiasJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobresources
     * @external
     */
    jobResources: CfnModelBiasJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification
     * @external
     */
    modelBiasAppSpecification: CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput
     * @external
     */
    modelBiasJobInput: CfnModelBiasJobDefinition.ModelBiasJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjoboutputconfig
     * @external
     */
    modelBiasJobOutputConfig: CfnModelBiasJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-jobdefinitionname
     * @external
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.ModelBiasBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig
     * @external
     */
    modelBiasBaselineConfig: CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig
     * @external
     */
    networkConfig: CfnModelBiasJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition
     * @external
     */
    stoppingCondition: CfnModelBiasJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelBiasJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html#cfn-sagemaker-modelbiasjobdefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelBiasJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelBiasJobDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html
     * @external
     */
    interface ClusterConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancecount
         * @external
         */
        readonly instanceCount: number;
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumekmskeyid
         * @external
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnModelBiasJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-clusterconfig.html#cfn-sagemaker-modelbiasjobdefinition-clusterconfig-volumesizeingb
         * @external
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html
     * @external
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnModelBiasJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-constraintsresource.html#cfn-sagemaker-modelbiasjobdefinition-constraintsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html
     * @external
     */
    interface EndpointInputProperty {
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.EndTimeOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endtimeoffset
         * @external
         */
        readonly endTimeOffset?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-endpointname
         * @external
         */
        readonly endpointName: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.FeaturesAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-featuresattribute
         * @external
         */
        readonly featuresAttribute?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.InferenceAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-inferenceattribute
         * @external
         */
        readonly inferenceAttribute?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.ProbabilityAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilityattribute
         * @external
         */
        readonly probabilityAttribute?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.ProbabilityThresholdAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-probabilitythresholdattribute
         * @external
         */
        readonly probabilityThresholdAttribute?: number;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3datadistributiontype
         * @external
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-s3inputmode
         * @external
         */
        readonly s3InputMode?: string;
        /**
         * `CfnModelBiasJobDefinition.EndpointInputProperty.StartTimeOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-endpointinput.html#cfn-sagemaker-modelbiasjobdefinition-endpointinput-starttimeoffset
         * @external
         */
        readonly startTimeOffset?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-environment.html
     * @external
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html
     * @external
     */
    interface ModelBiasAppSpecificationProperty {
        /**
         * `CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty.ConfigUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-configuri
         * @external
         */
        readonly configUri: string;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-environment
         * @external
         */
        readonly environment?: CfnModelBiasJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasAppSpecificationProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasappspecification.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasappspecification-imageuri
         * @external
         */
        readonly imageUri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html
     * @external
     */
    interface ModelBiasBaselineConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty.BaseliningJobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-baseliningjobname
         * @external
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasBaselineConfigProperty.ConstraintsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasbaselineconfig-constraintsresource
         * @external
         */
        readonly constraintsResource?: CfnModelBiasJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html
     * @external
     */
    interface ModelBiasJobInputProperty {
        /**
         * `CfnModelBiasJobDefinition.ModelBiasJobInputProperty.EndpointInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-endpointinput
         * @external
         */
        readonly endpointInput: CfnModelBiasJobDefinition.EndpointInputProperty | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.ModelBiasJobInputProperty.GroundTruthS3Input`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-modelbiasjobinput.html#cfn-sagemaker-modelbiasjobdefinition-modelbiasjobinput-groundtruths3input
         * @external
         */
        readonly groundTruthS3Input: CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html
     * @external
     */
    interface MonitoringGroundTruthS3InputProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringGroundTruthS3InputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelbiasjobdefinition-monitoringgroundtruths3input-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html
     * @external
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutput.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutput-s3output
         * @external
         */
        readonly s3Output: CfnModelBiasJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html
     * @external
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnModelBiasJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelbiasjobdefinition-monitoringoutputconfig-monitoringoutputs
         * @external
         */
        readonly monitoringOutputs: Array<CfnModelBiasJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html
     * @external
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnModelBiasJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-monitoringresources.html#cfn-sagemaker-modelbiasjobdefinition-monitoringresources-clusterconfig
         * @external
         */
        readonly clusterConfig: CfnModelBiasJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html
     * @external
     */
    interface NetworkConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enableintercontainertrafficencryption
         * @external
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-enablenetworkisolation
         * @external
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnModelBiasJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-networkconfig.html#cfn-sagemaker-modelbiasjobdefinition-networkconfig-vpcconfig
         * @external
         */
        readonly vpcConfig?: CfnModelBiasJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html
     * @external
     */
    interface S3OutputProperty {
        /**
         * `CfnModelBiasJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnModelBiasJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uploadmode
         * @external
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnModelBiasJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-s3output.html#cfn-sagemaker-modelbiasjobdefinition-s3output-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html
     * @external
     */
    interface StoppingConditionProperty {
        /**
         * `CfnModelBiasJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-stoppingcondition.html#cfn-sagemaker-modelbiasjobdefinition-stoppingcondition-maxruntimeinseconds
         * @external
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelBiasJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelbiasjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelBiasJobDefinition
 */
export declare namespace CfnModelBiasJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnModelBiasJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModelBiasJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelbiasjobdefinition-vpcconfig.html#cfn-sagemaker-modelbiasjobdefinition-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 */
export interface CfnModelExplainabilityJobDefinitionProps {
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobresources
     * @external
     */
    readonly jobResources: CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification
     * @external
     */
    readonly modelExplainabilityAppSpecification: CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput
     * @external
     */
    readonly modelExplainabilityJobInput: CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjoboutputconfig
     * @external
     */
    readonly modelExplainabilityJobOutputConfig: CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobdefinitionname
     * @external
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig
     * @external
     */
    readonly modelExplainabilityBaselineConfig?: CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig
     * @external
     */
    readonly networkConfig?: CfnModelExplainabilityJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition
     * @external
     */
    readonly stoppingCondition?: CfnModelExplainabilityJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare class CfnModelExplainabilityJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelExplainabilityJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelExplainabilityJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobresources
     * @external
     */
    jobResources: CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification
     * @external
     */
    modelExplainabilityAppSpecification: CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput
     * @external
     */
    modelExplainabilityJobInput: CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjoboutputconfig
     * @external
     */
    modelExplainabilityJobOutputConfig: CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-jobdefinitionname
     * @external
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig
     * @external
     */
    modelExplainabilityBaselineConfig: CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig
     * @external
     */
    networkConfig: CfnModelExplainabilityJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition
     * @external
     */
    stoppingCondition: CfnModelExplainabilityJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelExplainabilityJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html#cfn-sagemaker-modelexplainabilityjobdefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelExplainabilityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelExplainabilityJobDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html
     * @external
     */
    interface ClusterConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-instancecount
         * @external
         */
        readonly instanceCount: number;
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-volumekmskeyid
         * @external
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-clusterconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-clusterconfig-volumesizeingb
         * @external
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-constraintsresource.html
     * @external
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-constraintsresource.html#cfn-sagemaker-modelexplainabilityjobdefinition-constraintsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html
     * @external
     */
    interface EndpointInputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-endpointname
         * @external
         */
        readonly endpointName: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.FeaturesAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-featuresattribute
         * @external
         */
        readonly featuresAttribute?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.InferenceAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-inferenceattribute
         * @external
         */
        readonly inferenceAttribute?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.ProbabilityAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-probabilityattribute
         * @external
         */
        readonly probabilityAttribute?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-s3datadistributiontype
         * @external
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-endpointinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-endpointinput-s3inputmode
         * @external
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-environment.html
     * @external
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html
     * @external
     */
    interface ModelExplainabilityAppSpecificationProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty.ConfigUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-configuri
         * @external
         */
        readonly configUri: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-environment
         * @external
         */
        readonly environment?: CfnModelExplainabilityJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityAppSpecificationProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityappspecification-imageuri
         * @external
         */
        readonly imageUri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html
     * @external
     */
    interface ModelExplainabilityBaselineConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty.BaseliningJobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig-baseliningjobname
         * @external
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityBaselineConfigProperty.ConstraintsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilitybaselineconfig-constraintsresource
         * @external
         */
        readonly constraintsResource?: CfnModelExplainabilityJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html
     * @external
     */
    interface ModelExplainabilityJobInputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.ModelExplainabilityJobInputProperty.EndpointInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput.html#cfn-sagemaker-modelexplainabilityjobdefinition-modelexplainabilityjobinput-endpointinput
         * @external
         */
        readonly endpointInput: CfnModelExplainabilityJobDefinition.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutput.html
     * @external
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutput-s3output
         * @external
         */
        readonly s3Output: CfnModelExplainabilityJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html
     * @external
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringoutputconfig-monitoringoutputs
         * @external
         */
        readonly monitoringOutputs: Array<CfnModelExplainabilityJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringresources.html
     * @external
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-monitoringresources.html#cfn-sagemaker-modelexplainabilityjobdefinition-monitoringresources-clusterconfig
         * @external
         */
        readonly clusterConfig: CfnModelExplainabilityJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html
     * @external
     */
    interface NetworkConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-enableintercontainertrafficencryption
         * @external
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnModelExplainabilityJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-enablenetworkisolation
         * @external
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnModelExplainabilityJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-networkconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-networkconfig-vpcconfig
         * @external
         */
        readonly vpcConfig?: CfnModelExplainabilityJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html
     * @external
     */
    interface S3OutputProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnModelExplainabilityJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-s3uploadmode
         * @external
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnModelExplainabilityJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-s3output.html#cfn-sagemaker-modelexplainabilityjobdefinition-s3output-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-stoppingcondition.html
     * @external
     */
    interface StoppingConditionProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelexplainabilityjobdefinition-stoppingcondition-maxruntimeinseconds
         * @external
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelExplainabilityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelexplainabilityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelExplainabilityJobDefinition
 */
export declare namespace CfnModelExplainabilityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnModelExplainabilityJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModelExplainabilityJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelexplainabilityjobdefinition-vpcconfig.html#cfn-sagemaker-modelexplainabilityjobdefinition-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::ModelPackageGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html
 * @external
 */
export interface CfnModelPackageGroupProps {
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupname
     * @external
     */
    readonly modelPackageGroupName: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupdescription
     * @external
     */
    readonly modelPackageGroupDescription?: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegrouppolicy
     * @external
     */
    readonly modelPackageGroupPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelPackageGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelPackageGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelPackageGroup
 */
export declare class CfnModelPackageGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelPackageGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelPackageGroup;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute ModelPackageGroupArn
     */
    readonly attrModelPackageGroupArn: string;
    /**
     * @external
     * @cloudformationAttribute ModelPackageGroupStatus
     */
    readonly attrModelPackageGroupStatus: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupname
     * @external
     */
    modelPackageGroupName: string;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegroupdescription
     * @external
     */
    modelPackageGroupDescription: string | undefined;
    /**
     * `AWS::SageMaker::ModelPackageGroup.ModelPackageGroupPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-modelpackagegrouppolicy
     * @external
     */
    modelPackageGroupPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelPackageGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelpackagegroup.html#cfn-sagemaker-modelpackagegroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelPackageGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelPackageGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 */
export interface CfnModelQualityJobDefinitionProps {
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources
     * @external
     */
    readonly jobResources: CfnModelQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification
     * @external
     */
    readonly modelQualityAppSpecification: CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput
     * @external
     */
    readonly modelQualityJobInput: CfnModelQualityJobDefinition.ModelQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig
     * @external
     */
    readonly modelQualityJobOutputConfig: CfnModelQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobdefinitionname
     * @external
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig
     * @external
     */
    readonly modelQualityBaselineConfig?: CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig
     * @external
     */
    readonly networkConfig?: CfnModelQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition
     * @external
     */
    readonly stoppingCondition?: CfnModelQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare class CfnModelQualityJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::ModelQualityJobDefinition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnModelQualityJobDefinition;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute JobDefinitionArn
     */
    readonly attrJobDefinitionArn: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobresources
     * @external
     */
    jobResources: CfnModelQualityJobDefinition.MonitoringResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityAppSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification
     * @external
     */
    modelQualityAppSpecification: CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput
     * @external
     */
    modelQualityJobInput: CfnModelQualityJobDefinition.ModelQualityJobInputProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityJobOutputConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjoboutputconfig
     * @external
     */
    modelQualityJobOutputConfig: CfnModelQualityJobDefinition.MonitoringOutputConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-jobdefinitionname
     * @external
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.ModelQualityBaselineConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig
     * @external
     */
    modelQualityBaselineConfig: CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.NetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig
     * @external
     */
    networkConfig: CfnModelQualityJobDefinition.NetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.StoppingCondition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition
     * @external
     */
    stoppingCondition: CfnModelQualityJobDefinition.StoppingConditionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::ModelQualityJobDefinition.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html#cfn-sagemaker-modelqualityjobdefinition-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::ModelQualityJobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelQualityJobDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html
     * @external
     */
    interface ClusterConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancecount
         * @external
         */
        readonly instanceCount: number;
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumekmskeyid
         * @external
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnModelQualityJobDefinition.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-clusterconfig.html#cfn-sagemaker-modelqualityjobdefinition-clusterconfig-volumesizeingb
         * @external
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html
     * @external
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnModelQualityJobDefinition.ConstraintsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-constraintsresource.html#cfn-sagemaker-modelqualityjobdefinition-constraintsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html
     * @external
     */
    interface EndpointInputProperty {
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.EndTimeOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endtimeoffset
         * @external
         */
        readonly endTimeOffset?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-endpointname
         * @external
         */
        readonly endpointName: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.InferenceAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-inferenceattribute
         * @external
         */
        readonly inferenceAttribute?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.ProbabilityAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilityattribute
         * @external
         */
        readonly probabilityAttribute?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.ProbabilityThresholdAttribute`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-probabilitythresholdattribute
         * @external
         */
        readonly probabilityThresholdAttribute?: number;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.S3DataDistributionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3datadistributiontype
         * @external
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.S3InputMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-s3inputmode
         * @external
         */
        readonly s3InputMode?: string;
        /**
         * `CfnModelQualityJobDefinition.EndpointInputProperty.StartTimeOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-endpointinput.html#cfn-sagemaker-modelqualityjobdefinition-endpointinput-starttimeoffset
         * @external
         */
        readonly startTimeOffset?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-environment.html
     * @external
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html
     * @external
     */
    interface ModelQualityAppSpecificationProperty {
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ContainerArguments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerarguments
         * @external
         */
        readonly containerArguments?: string[];
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-containerentrypoint
         * @external
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-environment
         * @external
         */
        readonly environment?: CfnModelQualityJobDefinition.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-imageuri
         * @external
         */
        readonly imageUri: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-postanalyticsprocessorsourceuri
         * @external
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.ProblemType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-problemtype
         * @external
         */
        readonly problemType: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityappspecification.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityappspecification-recordpreprocessorsourceuri
         * @external
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html
     * @external
     */
    interface ModelQualityBaselineConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty.BaseliningJobName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-baseliningjobname
         * @external
         */
        readonly baseliningJobName?: string;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityBaselineConfigProperty.ConstraintsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig.html#cfn-sagemaker-modelqualityjobdefinition-modelqualitybaselineconfig-constraintsresource
         * @external
         */
        readonly constraintsResource?: CfnModelQualityJobDefinition.ConstraintsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html
     * @external
     */
    interface ModelQualityJobInputProperty {
        /**
         * `CfnModelQualityJobDefinition.ModelQualityJobInputProperty.EndpointInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-endpointinput
         * @external
         */
        readonly endpointInput: CfnModelQualityJobDefinition.EndpointInputProperty | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.ModelQualityJobInputProperty.GroundTruthS3Input`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-modelqualityjobinput.html#cfn-sagemaker-modelqualityjobdefinition-modelqualityjobinput-groundtruths3input
         * @external
         */
        readonly groundTruthS3Input: CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html
     * @external
     */
    interface MonitoringGroundTruthS3InputProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringGroundTruthS3InputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input.html#cfn-sagemaker-modelqualityjobdefinition-monitoringgroundtruths3input-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html
     * @external
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringOutputProperty.S3Output`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutput.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutput-s3output
         * @external
         */
        readonly s3Output: CfnModelQualityJobDefinition.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html
     * @external
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnModelQualityJobDefinition.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringoutputconfig.html#cfn-sagemaker-modelqualityjobdefinition-monitoringoutputconfig-monitoringoutputs
         * @external
         */
        readonly monitoringOutputs: Array<CfnModelQualityJobDefinition.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html
     * @external
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnModelQualityJobDefinition.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-monitoringresources.html#cfn-sagemaker-modelqualityjobdefinition-monitoringresources-clusterconfig
         * @external
         */
        readonly clusterConfig: CfnModelQualityJobDefinition.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html
     * @external
     */
    interface NetworkConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enableintercontainertrafficencryption
         * @external
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-enablenetworkisolation
         * @external
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnModelQualityJobDefinition.NetworkConfigProperty.VpcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-networkconfig.html#cfn-sagemaker-modelqualityjobdefinition-networkconfig-vpcconfig
         * @external
         */
        readonly vpcConfig?: CfnModelQualityJobDefinition.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html
     * @external
     */
    interface S3OutputProperty {
        /**
         * `CfnModelQualityJobDefinition.S3OutputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnModelQualityJobDefinition.S3OutputProperty.S3UploadMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uploadmode
         * @external
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnModelQualityJobDefinition.S3OutputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-s3output.html#cfn-sagemaker-modelqualityjobdefinition-s3output-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html
     * @external
     */
    interface StoppingConditionProperty {
        /**
         * `CfnModelQualityJobDefinition.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-stoppingcondition.html#cfn-sagemaker-modelqualityjobdefinition-stoppingcondition-maxruntimeinseconds
         * @external
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::ModelQualityJobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-modelqualityjobdefinition.html
 * @external
 * @cloudformationResource AWS::SageMaker::ModelQualityJobDefinition
 */
export declare namespace CfnModelQualityJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnModelQualityJobDefinition.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModelQualityJobDefinition.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelqualityjobdefinition-vpcconfig.html#cfn-sagemaker-modelqualityjobdefinition-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 */
export interface CfnMonitoringScheduleProps {
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     * @external
     */
    readonly monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     * @external
     */
    readonly monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     * @external
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     * @external
     */
    readonly failureReason?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     * @external
     */
    readonly lastMonitoringExecutionSummary?: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     * @external
     */
    readonly monitoringScheduleStatus?: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare class CfnMonitoringSchedule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::MonitoringSchedule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMonitoringSchedule;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute LastModifiedTime
     */
    readonly attrLastModifiedTime: string;
    /**
     * @external
     * @cloudformationAttribute MonitoringScheduleArn
     */
    readonly attrMonitoringScheduleArn: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig
     * @external
     */
    monitoringScheduleConfig: CfnMonitoringSchedule.MonitoringScheduleConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename
     * @external
     */
    monitoringScheduleName: string;
    /**
     * `AWS::SageMaker::MonitoringSchedule.EndpointName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname
     * @external
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.FailureReason`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason
     * @external
     */
    failureReason: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.LastMonitoringExecutionSummary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary
     * @external
     */
    lastMonitoringExecutionSummary: CfnMonitoringSchedule.MonitoringExecutionSummaryProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.MonitoringScheduleStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus
     * @external
     */
    monitoringScheduleStatus: string | undefined;
    /**
     * `AWS::SageMaker::MonitoringSchedule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::MonitoringSchedule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMonitoringScheduleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html
     * @external
     */
    interface BaselineConfigProperty {
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.ConstraintsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource
         * @external
         */
        readonly constraintsResource?: CfnMonitoringSchedule.ConstraintsResourceProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.BaselineConfigProperty.StatisticsResource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource
         * @external
         */
        readonly statisticsResource?: CfnMonitoringSchedule.StatisticsResourceProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html
     * @external
     */
    interface ClusterConfigProperty {
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount
         * @external
         */
        readonly instanceCount: number;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeKmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid
         * @external
         */
        readonly volumeKmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.ClusterConfigProperty.VolumeSizeInGB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb
         * @external
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html
     * @external
     */
    interface ConstraintsResourceProperty {
        /**
         * `CfnMonitoringSchedule.ConstraintsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html
     * @external
     */
    interface EndpointInputProperty {
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname
         * @external
         */
        readonly endpointName: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3DataDistributionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype
         * @external
         */
        readonly s3DataDistributionType?: string;
        /**
         * `CfnMonitoringSchedule.EndpointInputProperty.S3InputMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode
         * @external
         */
        readonly s3InputMode?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-environment.html
     * @external
     */
    interface EnvironmentProperty {
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html
     * @external
     */
    interface MonitoringAppSpecificationProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerArguments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments
         * @external
         */
        readonly containerArguments?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ContainerEntrypoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint
         * @external
         */
        readonly containerEntrypoint?: string[];
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri
         * @external
         */
        readonly imageUri: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.PostAnalyticsProcessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri
         * @external
         */
        readonly postAnalyticsProcessorSourceUri?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringAppSpecificationProperty.RecordPreprocessorSourceUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri
         * @external
         */
        readonly recordPreprocessorSourceUri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html
     * @external
     */
    interface MonitoringExecutionSummaryProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.CreationTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime
         * @external
         */
        readonly creationTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.EndpointName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname
         * @external
         */
        readonly endpointName?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.FailureReason`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason
         * @external
         */
        readonly failureReason?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.LastModifiedTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime
         * @external
         */
        readonly lastModifiedTime: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringExecutionStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus
         * @external
         */
        readonly monitoringExecutionStatus: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.MonitoringScheduleName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename
         * @external
         */
        readonly monitoringScheduleName: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ProcessingJobArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn
         * @external
         */
        readonly processingJobArn?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringExecutionSummaryProperty.ScheduledTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime
         * @external
         */
        readonly scheduledTime: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html
     * @external
     */
    interface MonitoringInputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputProperty.EndpointInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput
         * @external
         */
        readonly endpointInput: CfnMonitoringSchedule.EndpointInputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html
     * @external
     */
    interface MonitoringInputsProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringInputsProperty.MonitoringInputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinputs.html#cfn-sagemaker-monitoringschedule-monitoringinputs-monitoringinputs
         * @external
         */
        readonly monitoringInputs?: Array<CfnMonitoringSchedule.MonitoringInputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html
     * @external
     */
    interface MonitoringJobDefinitionProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.BaselineConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig
         * @external
         */
        readonly baselineConfig?: CfnMonitoringSchedule.BaselineConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment
         * @external
         */
        readonly environment?: CfnMonitoringSchedule.EnvironmentProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringAppSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification
         * @external
         */
        readonly monitoringAppSpecification: CfnMonitoringSchedule.MonitoringAppSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringInputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs
         * @external
         */
        readonly monitoringInputs: CfnMonitoringSchedule.MonitoringInputsProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringOutputConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig
         * @external
         */
        readonly monitoringOutputConfig: CfnMonitoringSchedule.MonitoringOutputConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.MonitoringResources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources
         * @external
         */
        readonly monitoringResources: CfnMonitoringSchedule.MonitoringResourcesProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.NetworkConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig
         * @external
         */
        readonly networkConfig?: CfnMonitoringSchedule.NetworkConfigProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnMonitoringSchedule.MonitoringJobDefinitionProperty.StoppingCondition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition
         * @external
         */
        readonly stoppingCondition?: CfnMonitoringSchedule.StoppingConditionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html
     * @external
     */
    interface MonitoringOutputProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputProperty.S3Output`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output
         * @external
         */
        readonly s3Output: CfnMonitoringSchedule.S3OutputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html
     * @external
     */
    interface MonitoringOutputConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.KmsKeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid
         * @external
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringOutputConfigProperty.MonitoringOutputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs
         * @external
         */
        readonly monitoringOutputs: Array<CfnMonitoringSchedule.MonitoringOutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html
     * @external
     */
    interface MonitoringResourcesProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringResourcesProperty.ClusterConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig
         * @external
         */
        readonly clusterConfig: CfnMonitoringSchedule.ClusterConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html
     * @external
     */
    interface MonitoringScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition
         * @external
         */
        readonly monitoringJobDefinition?: CfnMonitoringSchedule.MonitoringJobDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringJobDefinitionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinitionname
         * @external
         */
        readonly monitoringJobDefinitionName?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.MonitoringType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringtype
         * @external
         */
        readonly monitoringType?: string;
        /**
         * `CfnMonitoringSchedule.MonitoringScheduleConfigProperty.ScheduleConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig
         * @external
         */
        readonly scheduleConfig?: CfnMonitoringSchedule.ScheduleConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html
     * @external
     */
    interface NetworkConfigProperty {
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableInterContainerTrafficEncryption`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption
         * @external
         */
        readonly enableInterContainerTrafficEncryption?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.EnableNetworkIsolation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation
         * @external
         */
        readonly enableNetworkIsolation?: boolean | cdk.IResolvable;
        /**
         * `CfnMonitoringSchedule.NetworkConfigProperty.VpcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig
         * @external
         */
        readonly vpcConfig?: CfnMonitoringSchedule.VpcConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html
     * @external
     */
    interface S3OutputProperty {
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.LocalPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath
         * @external
         */
        readonly localPath: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3UploadMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode
         * @external
         */
        readonly s3UploadMode?: string;
        /**
         * `CfnMonitoringSchedule.S3OutputProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri
         * @external
         */
        readonly s3Uri: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html
     * @external
     */
    interface ScheduleConfigProperty {
        /**
         * `CfnMonitoringSchedule.ScheduleConfigProperty.ScheduleExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression
         * @external
         */
        readonly scheduleExpression: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html
     * @external
     */
    interface StatisticsResourceProperty {
        /**
         * `CfnMonitoringSchedule.StatisticsResourceProperty.S3Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri
         * @external
         */
        readonly s3Uri?: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html
     * @external
     */
    interface StoppingConditionProperty {
        /**
         * `CfnMonitoringSchedule.StoppingConditionProperty.MaxRuntimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds
         * @external
         */
        readonly maxRuntimeInSeconds: number;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::MonitoringSchedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html
 * @external
 * @cloudformationResource AWS::SageMaker::MonitoringSchedule
 */
export declare namespace CfnMonitoringSchedule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnMonitoringSchedule.VpcConfigProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets
         * @external
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 * @external
 */
export interface CfnNotebookInstanceProps {
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     * @external
     */
    readonly acceleratorTypes?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     * @external
     */
    readonly additionalCodeRepositories?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     * @external
     */
    readonly defaultCodeRepository?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     * @external
     */
    readonly directInternetAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     * @external
     */
    readonly lifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     * @external
     */
    readonly notebookInstanceName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     * @external
     */
    readonly rootAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     * @external
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     * @external
     */
    readonly subnetId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     * @external
     */
    readonly volumeSizeInGb?: number;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstance
 */
export declare class CfnNotebookInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotebookInstance;
    /**
     * @external
     * @cloudformationAttribute NotebookInstanceName
     */
    readonly attrNotebookInstanceName: string;
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     * @external
     */
    acceleratorTypes: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     * @external
     */
    additionalCodeRepositories: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     * @external
     */
    defaultCodeRepository: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     * @external
     */
    directInternetAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     * @external
     */
    lifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     * @external
     */
    notebookInstanceName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     * @external
     */
    rootAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     * @external
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     * @external
     */
    subnetId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     * @external
     */
    volumeSizeInGb: number | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotebookInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 * @external
 */
export interface CfnNotebookInstanceLifecycleConfigProps {
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     * @external
     */
    readonly notebookInstanceLifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     * @external
     */
    readonly onCreate?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     * @external
     */
    readonly onStart?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 */
export declare class CfnNotebookInstanceLifecycleConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstanceLifecycleConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotebookInstanceLifecycleConfig;
    /**
     * @external
     * @cloudformationAttribute NotebookInstanceLifecycleConfigName
     */
    readonly attrNotebookInstanceLifecycleConfigName: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     * @external
     */
    notebookInstanceLifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     * @external
     */
    onCreate: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     * @external
     */
    onStart: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnNotebookInstanceLifecycleConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 * @external
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 */
export declare namespace CfnNotebookInstanceLifecycleConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html
     * @external
     */
    interface NotebookInstanceLifecycleHookProperty {
        /**
         * `CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty.Content`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook-content
         * @external
         */
        readonly content?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Pipeline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html
 * @external
 */
export interface CfnPipelineProps {
    /**
     * `AWS::SageMaker::Pipeline.PipelineDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedefinition
     * @external
     */
    readonly pipelineDefinition: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Pipeline.PipelineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinename
     * @external
     */
    readonly pipelineName: string;
    /**
     * `AWS::SageMaker::Pipeline.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedescription
     * @external
     */
    readonly pipelineDescription?: string;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedisplayname
     * @external
     */
    readonly pipelineDisplayName?: string;
    /**
     * `AWS::SageMaker::Pipeline.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Pipeline`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html
 * @external
 * @cloudformationResource AWS::SageMaker::Pipeline
 */
export declare class CfnPipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Pipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPipeline;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedefinition
     * @external
     */
    pipelineDefinition: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Pipeline.PipelineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinename
     * @external
     */
    pipelineName: string;
    /**
     * `AWS::SageMaker::Pipeline.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedescription
     * @external
     */
    pipelineDescription: string | undefined;
    /**
     * `AWS::SageMaker::Pipeline.PipelineDisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-pipelinedisplayname
     * @external
     */
    pipelineDisplayName: string | undefined;
    /**
     * `AWS::SageMaker::Pipeline.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-pipeline.html#cfn-sagemaker-pipeline-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Pipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPipelineProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html
 * @external
 */
export interface CfnProjectProps {
    /**
     * `AWS::SageMaker::Project.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectname
     * @external
     */
    readonly projectName: string;
    /**
     * `AWS::SageMaker::Project.ServiceCatalogProvisioningDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-servicecatalogprovisioningdetails
     * @external
     */
    readonly serviceCatalogProvisioningDetails: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Project.ProjectDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectdescription
     * @external
     */
    readonly projectDescription?: string;
    /**
     * `AWS::SageMaker::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html
 * @external
 * @cloudformationResource AWS::SageMaker::Project
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Project";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProject;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: string;
    /**
     * @external
     * @cloudformationAttribute ProjectArn
     */
    readonly attrProjectArn: string;
    /**
     * @external
     * @cloudformationAttribute ProjectId
     */
    readonly attrProjectId: string;
    /**
     * @external
     * @cloudformationAttribute ProjectStatus
     */
    readonly attrProjectStatus: string;
    /**
     * @external
     * @cloudformationAttribute ServiceCatalogProvisionedProductDetails
     */
    readonly attrServiceCatalogProvisionedProductDetails: cdk.IResolvable;
    /**
     * `AWS::SageMaker::Project.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectname
     * @external
     */
    projectName: string;
    /**
     * `AWS::SageMaker::Project.ServiceCatalogProvisioningDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-servicecatalogprovisioningdetails
     * @external
     */
    serviceCatalogProvisioningDetails: any | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Project.ProjectDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-projectdescription
     * @external
     */
    projectDescription: string | undefined;
    /**
     * `AWS::SageMaker::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-project.html#cfn-sagemaker-project-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Project`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 */
export interface CfnWorkteamProps {
    /**
     * `AWS::SageMaker::Workteam.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     * @external
     */
    readonly memberDefinitions?: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     * @external
     */
    readonly notificationConfiguration?: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     * @external
     */
    readonly workteamName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare class CfnWorkteam extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Workteam";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkteam;
    /**
     * @external
     * @cloudformationAttribute WorkteamName
     */
    readonly attrWorkteamName: string;
    /**
     * `AWS::SageMaker::Workteam.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     * @external
     */
    memberDefinitions: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     * @external
     */
    notificationConfiguration: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     * @external
     */
    workteamName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::Workteam`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkteamProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare namespace CfnWorkteam {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html
     * @external
     */
    interface CognitoMemberDefinitionProperty {
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitoclientid
         * @external
         */
        readonly cognitoClientId: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitousergroup
         * @external
         */
        readonly cognitoUserGroup: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitouserpool
         * @external
         */
        readonly cognitoUserPool: string;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare namespace CfnWorkteam {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html
     * @external
     */
    interface MemberDefinitionProperty {
        /**
         * `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html#cfn-sagemaker-workteam-memberdefinition-cognitomemberdefinition
         * @external
         */
        readonly cognitoMemberDefinition: CfnWorkteam.CognitoMemberDefinitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 * @external
 * @cloudformationResource AWS::SageMaker::Workteam
 */
export declare namespace CfnWorkteam {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html
     * @external
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html#cfn-sagemaker-workteam-notificationconfiguration-notificationtopicarn
         * @external
         */
        readonly notificationTopicArn: string;
    }
}
