import glob
import os
import shutil
import platform
import subprocess
from pathlib import Path
import sysconfig
import sys

from hatchling.builders.hooks.plugin.interface import BuildHookInterface

def clean_folder(folder):
    files = glob.glob(folder + "/*")
    for f in files:
        if os.path.isfile(f):
            os.remove(f)
        else:
            if not (os.path.basename(f) == "Mac" or os.path.basename(f) == "Win"):
                shutil.rmtree(f)

def copy_files(fromPath, toPath, files, bads = [], bad_word = ""):
    for f in files:
        if f not in bads and (bad_word == "" or bad_word not in f):
            shutil.copy(fromPath + "/" + f, toPath)

class CustomBuildHook(BuildHookInterface):
    def initialize(self, version, build_data):
        platform_config = sysconfig.get_platform()
        #path to dlls folder for package
        dlls_path = "dymo_sdk/dlls"
        curr_file = Path(self.directory).parent.resolve()
        #build the sample app
        if "platform" in self.config and self.config["platform"] != "":
            chosen_plat = self.config["platform"]
        else:
            chosen_plat = platform.system()
        arch = self.config["arch"]
        if chosen_plat == "Windows":
            #Windows
            #path to sample
            proj_path_win = curr_file.parent / "Samples" / "SDKMauiSample" / "SDKSample.WinUI" / "SDKSample.WinUI.csproj"
            proj_path_win = str(proj_path_win.resolve())
            label_api_win_path = curr_file.parent.parent / "Components" / "DYMO.LabelAPI.Windows" / "DYMO.LabelAPI.Windows.csproj"
            label_api_win_path = str(label_api_win_path.resolve())

            inter_folder1 = ""
            inter_folder2 = ""
            if arch == "":
                if "arm64" in platform_config:
                    inter_folder1 = "arm64"
                    inter_folder2 = "win-arm64"
                elif "amd64" in platform_config:
                    inter_folder1 = "x64"
                    inter_folder2 = "win-x64"
                elif "win32" in platform_config:
                    inter_folder1 = "x86"
                    inter_folder2 = "win-x86"
            else:
                if arch == "arm64":
                    inter_folder1 = "arm64"
                    inter_folder2 = "win-arm64"
                elif arch == "x64":
                    inter_folder1 = "x64"
                    inter_folder2 = "win-x64"
                elif arch == "x86":
                    inter_folder1 = "x86"
                    inter_folder2 = "win-x86"
            
            #path to sample's bin
            bin_path_win = curr_file.parent / "Samples" / "SDKMauiSample" / "SDKSample.WinUI" / "bin"/ inter_folder1 / "Release" / "net8.0-windows10.0.19041.0" / inter_folder2
            bin_path_win = str(bin_path_win.resolve())
            
            clean_command = ["dotnet", "clean", proj_path_win]
            build_command = ["dotnet", "build", proj_path_win, "--configuration", "Release", "--arch", inter_folder1, "--property:", "Platform=" + inter_folder1]

            try:
                dotnet_clean_result = subprocess.run(clean_command, check=True, capture_output=True, text=True, shell=True)
                dotnet_build_result = subprocess.run(build_command, check=True, capture_output=True, text=True, shell=True)
                successful = True
            except subprocess.CalledProcessError as e:
                print(f"Ran into error: {e}")
                print(e.stdout)
                print("now printing errors")
                print(e.stderr)
                successful = False
                #raise e
            
            #copy the required files
            if successful:
                clean_folder(dlls_path)
                dlls = glob.glob("*.dll", root_dir=bin_path_win)
                copy_files(bin_path_win, dlls_path, dlls)
                print("successfully copied dlls")
            else:
                print("did not copy new dlls")
        else:
            #path to sample
            proj_path_mac = curr_file.parent / "Samples" / "SDKMauiSample" / "SDKSample.Mac" / "SDKSample.Mac.csproj"
            proj_path_mac = str(proj_path_mac.resolve())
            label_api_mac_path = curr_file.parent.parent / "Components" / "DYMO.LabelAPI.Mac" / "DYMO.LabelAPI.Mac.csproj"
            label_api_mac_path = str(label_api_mac_path.resolve())

            bin_path_mac = curr_file.parent / "Samples" / "SDKMauiSample" / "SDKSample.Mac" / "bin" / "Release" / "net8.0-maccatalyst" / "maccatalyst-arm64"
            bin_path_mac = str(bin_path_mac.resolve())

            clean_command = ["dotnet clean " + proj_path_mac]
            build_command = ["dotnet build " + proj_path_mac + " --configuration Release -r maccatalyst-arm64 -p:CheckEolWorkloads=False --property:TargetFramework=net8.0-maccatalyst"]
            native_build_command = ["./build.native.osx.arm64.sh"]

            try:
                dotnet_clean_result = subprocess.run(clean_command, check=True, capture_output=True, text=True, shell=True)
                print(dotnet_clean_result.stdout)
                dotnet_build_result = subprocess.run(build_command, check=True, capture_output=True, text=True, shell=True)
                print(dotnet_build_result.stdout)
                build_native_result = subprocess.run(native_build_command, check=True, capture_output=True, text=True, shell=True, cwd="../../Components.Native")
                successful = True
            except subprocess.CalledProcessError as e:
                print(f"Ran into error: {e}")
                print(e.stdout)
                print("now printing errors")
                print(e.stderr)
                successful = False
                #raise e
            
            #copy the required files
            if successful:
                clean_folder(dlls_path)
                dlls = glob.glob("*.dll", root_dir=bin_path_mac)
                copy_files(bin_path_mac, dlls_path, dlls)
                dylibs = glob.glob("*.dylib", root_dir=bin_path_mac)
                aFiles = glob.glob("*.a", root_dir=bin_path_mac)
                copy_files(bin_path_mac, dlls_path, dylibs, bad_word="Maui")
                copy_files(bin_path_mac, dlls_path, aFiles, bad_word="Maui")
                mac_os_native_skiasharp = str(Path.home().resolve()) + "/.nuget/packages/skiasharp.nativeassets.macos/3.116.1/runtimes/osx/native/libSkiaSharp.dylib"
                os.makedirs(dlls_path + "/@rpath/libSkiaSharp.framework", exist_ok=True)
                shutil.copy(mac_os_native_skiasharp, dlls_path + "/@rpath/libSkiaSharp.framework")
                native_files = "../../native/osx/dylib/Release"
                native_dlls = glob.glob("*.dylib", root_dir=native_files)
                copy_files(native_files, dlls_path, native_dlls)
                print("successfully copied dlls")


        #set build tags
        build_data["infer_tag"] = False

        build_data["pure_python"] = False

        if platform.system() == "Windows":
            platform_tag = platform_config.replace("-", "_").replace(".","_")
            if arch == "arm64":
                platform_tag = platform_tag.replace("amd64", "arm64")
            elif arch == "x86":
                platform_tag = platform_tag.replace("win_amd64", "win32")
            print(f"platform_tag:{platform_tag}")
        else:
            platform_tag = "macosx_13_0_arm64"
        
        abi_tag = "none"
        python_tag = "py2.py3"

        build_data["tag"] = python_tag + "-" + abi_tag + "-" + platform_tag