# Getting Started

## Installation
To use the SDK you will need a .NET Desktop Runtime, which can be downloaded here: <https://dotnet.microsoft.com/en-us/download/dotnet/8.0>. You should also install DYMO Connect which should install any drivers you need and allow you to design the label files necessary, although DYMO Connect is not strictly necessary. DYMO Connect can be downloaded here: <https://www.dymo.com/support?cfid=user-guide>. 
```{warning} 
Note that currently for MacOS only arm chips are supported. In addition, bluetooth devices may not currently be working on mac. Also, you must be running .net 8.0 for Mac.
```
  After that, you can simply run
```{code}
pip install dymo_sdk
```

## Basic Usage
The package contains two main objects DymoLabel and DymoPrinter. A basic script to print a .dymo label generated by Dymo Connect might go like:
``` python
import dymo_sdk as dsdk

#load label from file
dymo_label = dsdk.DymoLabel("/path/to/label.dymo")
#get detected printers
printers = dsdk.get_printers()
#selected first found connected printer
for p in printers:
    if p.is_connected:
        selected_printer = p
#print label
selected_printer.print_label(label)
```
More information can be found via our documentation: <INSERT LINK HERE>
